/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TableCellState;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ComboBoxTableRenderer<T>
extends JLabel
implements TableCellRenderer,
TableCellEditor,
JBPopupListener {
    private final TableCellState myCellState = new TableCellState();
    private final T[] myValues;
    private WeakReference<ListPopup> myPopupRef;
    private ChangeEvent myChangeEvent = null;
    private T myValue;
    private int myClickCount = 2;
    protected EventListenerList myListenerList = new EventListenerList();
    private Runnable myFinalRunnable;

    public ComboBoxTableRenderer(T[] values) {
        this.myValues = values;
        this.setFont(UIUtil.getButtonFont());
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
    }

    public ComboBoxTableRenderer<T> withClickCount(int clickCount) {
        this.myClickCount = clickCount;
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = ComboBoxTableRenderer.addIconSize(super.getPreferredSize());
        if (this.myValues != null) {
            String oldText = this.getText();
            Icon oldIcon = this.getIcon();
            int limit = this.getPreferredSizeMaxValues();
            for (int i = 0; i < this.myValues.length && i < limit; ++i) {
                T v = this.myValues[i];
                this.setText(this.getTextFor(v));
                this.setIcon(this.getIconFor(v));
                Dimension vSize = ComboBoxTableRenderer.addIconSize(super.getPreferredSize());
                size.width = Math.max(size.width, vSize.width);
                size.height = Math.max(size.height, vSize.height);
            }
            this.setText(oldText);
            this.setIcon(oldIcon);
        }
        return size;
    }

    protected int getPreferredSizeMaxValues() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private static Dimension addIconSize(Dimension d) {
        return new Dimension(d.width + AllIcons.General.ArrowDown.getIconWidth() + JBUIScale.scale((int)2), Math.max(d.height, AllIcons.General.ArrowDown.getIconHeight()));
    }

    @NlsContexts.Label
    protected String getTextFor(@NotNull T value2) {
        if (value2 == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(0);
        }
        return value2.toString();
    }

    protected Icon getIconFor(@NotNull T value2) {
        if (value2 == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(1);
        }
        return null;
    }

    protected ListSeparator getSeparatorAbove(T value2) {
        return null;
    }

    protected Runnable onChosen(@NotNull T value2) {
        if (value2 == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(2);
        }
        this.stopCellEditing(value2);
        return () -> this.stopCellEditing(value2);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!StringUtil.isEmpty((String)this.getText())) {
            Rectangle r = this.getBounds();
            Insets i = this.getInsets();
            int x = r.width - i.right - AllIcons.General.ArrowDown.getIconWidth();
            int y = i.top + (r.height - i.top - i.bottom - AllIcons.General.ArrowDown.getIconHeight()) / 2;
            AllIcons.General.ArrowDown.paintIcon(this, g, x, y);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Object t = value2;
        this.myCellState.collectState(table, isSelected, hasFocus, row, column);
        this.myCellState.updateRenderer((JComponent)this);
        this.customizeComponent(t, table, isSelected);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        Object t = value2;
        this.myValue = t;
        this.myCellState.collectState(table, isSelected, true, row, column);
        this.myCellState.updateRenderer((JComponent)this);
        this.customizeComponent(t, table, true);
        Rectangle popupLocation = table.getCellRect(row, column, true);
        popupLocation.y += table.getRowHeight();
        SwingUtilities.invokeLater(() -> this.showPopup(t, row, new RelativePoint((Component)table, popupLocation.getLocation())));
        return this;
    }

    protected boolean isApplicable(T value2, int row) {
        return true;
    }

    private void showPopup(T value2, int row, @NotNull RelativePoint location) {
        if (location == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(3);
        }
        List filtered = ContainerUtil.findAll((Object[])this.myValues, t -> this.isApplicable(t, row));
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup(new ListStep<T>(this, filtered, value2));
        popup2.addListener((JBPopupListener)this);
        popup2.setRequestFocus(false);
        this.myPopupRef = new WeakReference<ListPopup>(popup2);
        PopupUtil.setPopupToggleComponent((JBPopup)popup2, this);
        popup2.show(location);
    }

    public void onClosed(@NotNull LightweightWindowEvent event) {
        if (event == null) {
            ComboBoxTableRenderer.$$$reportNull$$$0(4);
        }
        this.fireEditingCanceled();
    }

    protected void customizeComponent(T value2, JTable table, boolean isSelected) {
        this.setOpaque(true);
        this.setText(value2 == null ? "" : this.getTextFor(value2));
        this.setIcon(value2 == null ? null : this.getIconFor(value2));
    }

    @Override
    public Object getCellEditorValue() {
        return this.myValue;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= this.myClickCount;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    private void stopCellEditing(T value2) {
        this.myValue = value2;
        this.stopCellEditing();
    }

    @TestOnly
    public void chooseItem(int idx) {
        this.stopCellEditing(this.myValues[idx]);
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        this.hidePopup();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
        this.hidePopup();
    }

    protected void fireEditingStopped() {
        this.fireEditingEvent(false);
    }

    protected void fireEditingCanceled() {
        this.fireEditingEvent(true);
    }

    protected void fireEditingEvent(boolean cancelled) {
        Object[] listeners = this.myListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.myChangeEvent == null) {
                this.myChangeEvent = new ChangeEvent(this);
            }
            CellEditorListener listener2 = (CellEditorListener)listeners[i + 1];
            if (cancelled) {
                listener2.editingCanceled(this.myChangeEvent);
                continue;
            }
            listener2.editingStopped(this.myChangeEvent);
        }
    }

    private void hidePopup() {
        if (this.myPopupRef != null) {
            ListPopup popup2 = (ListPopup)this.myPopupRef.get();
            if (popup2 != null && popup2.isVisible()) {
                popup2.cancel();
            }
            this.myPopupRef = null;
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.myListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.myListenerList.remove(CellEditorListener.class, l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/ComboBoxTableRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIconFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onChosen";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ListStep<T>
    implements ListPopupStep<T>,
    SpeedSearchFilter<T> {
        private final ComboBoxTableRenderer<T> myHost;
        private final List<T> myValues;
        private final T mySelected;

        ListStep(ComboBoxTableRenderer<T> host, List<T> values, T selected2) {
            this.myHost = host;
            this.myValues = values;
            this.mySelected = selected2;
        }

        public String getTitle() {
            return null;
        }

        @Nullable
        public PopupStep<?> onChosen(T selectedValue, boolean finalChoice) {
            this.myHost.myFinalRunnable = this.myHost.onChosen(selectedValue);
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(T selectedValue) {
            return false;
        }

        public void canceled() {
            this.myHost.cancelCellEditing();
        }

        public boolean isMnemonicsNavigationEnabled() {
            return false;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        @Nullable
        public Runnable getFinalRunnable() {
            return this.myHost.myFinalRunnable;
        }

        @NotNull
        public List<T> getValues() {
            List<T> list = this.myValues;
            if (list == null) {
                ListStep.$$$reportNull$$$0(0);
            }
            return list;
        }

        public boolean isSelectable(T value2) {
            return true;
        }

        public Icon getIconFor(T value2) {
            return this.myHost.getIconFor(value2);
        }

        @NlsContexts.ListItem
        @NotNull
        public String getTextFor(T value2) {
            String string = this.myHost.getTextFor(value2);
            if (string == null) {
                ListStep.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(T value2) {
            return this.myHost.getSeparatorAbove(value2);
        }

        public int getDefaultOptionIndex() {
            return this.mySelected == null ? 0 : this.myValues.indexOf(this.mySelected);
        }

        public MnemonicNavigationFilter<T> getMnemonicNavigationFilter() {
            return null;
        }

        public SpeedSearchFilter<T> getSpeedSearchFilter() {
            return this;
        }

        public String getIndexedString(T value2) {
            return this.getTextFor(value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/ui/ComboBoxTableRenderer$ListStep";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

