/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.panel.ComponentPanel;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.LabelUI;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Provides incorrect spacing between components and out-dated. The functionality is covered by Kotlin UI DSL,\n  which should be used instead. ComponentPanelBuilder will be removed after moving Kotlin UI DSL into platform API package")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 E2\u00020\u0001:\u0003CDEB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\nH\u0016J\u0015\u0010\"\u001a\u00020\u00002\u000b\u0010#\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\b\u0010$\u001a\u00020\u0000H\u0016J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001bH\u0016J\u0017\u0010'\u001a\u00020\u00002\r\b\u0001\u0010(\u001a\u00070\u0007\u00a2\u0006\u0002\b\fH\u0016J\u001d\u0010'\u001a\u00020\u00002\u000b\u0010(\u001a\u00070\u0007\u00a2\u0006\u0002\b\f2\u0006\u0010)\u001a\u00020\nH\u0016J\u0010\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u000eH\u0016J\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0010H\u0016J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0003H\u0016J\b\u00100\u001a\u00020\u0000H\u0016J\u0015\u00101\u001a\u00020\u00002\u000b\u00102\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0014H\u0016J\u001d\u00103\u001a\u00020\u00002\u000b\u00104\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00162\u0006\u00105\u001a\u00020\u0018H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\nH\u0016J\b\u00109\u001a\u00020:H\u0016J \u0010;\u001a\u00020<2\u0006\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\nH\u0016J\b\u0010A\u001a\u00020BH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0013\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0015\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/openapi/ui/panel/ComponentPanelBuilder;", "Lcom/intellij/openapi/ui/panel/GridBagPanelBuilder;", "myComponent", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "myLabelText", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "myLabelOnTop", "", "myCommentText", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "myCommentIcon", "Ljavax/swing/Icon;", "myHyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "myCommentBelow", "myCommentAllowAutoWrapping", "myHTDescription", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "myHTLinkText", "Lcom/intellij/openapi/util/NlsContexts$LinkLabel;", "myHTAction", "Ljava/lang/Runnable;", "myTopRightComponent", "myAnchor", "Lcom/intellij/util/ui/UI$Anchor;", "myResizeY", "myResizeX", "valid", "resizeY", "resize", "resizeX", "withLabel", "labelText", "moveLabelOnTop", "anchorLabelOn", "anchor", "withComment", "comment", "allowAutoWrapping", "withCommentIcon", "icon", "withCommentHyperlinkListener", "listener", "withTopRightComponent", "topRightComponent", "moveCommentRight", "withTooltip", "description", "withTooltipLink", "linkText", "action", "createPanel", "Ljavax/swing/JPanel;", "constrainsValid", "gridWidth", "", "addToPanel", "", "panel", "gc", "Ljava/awt/GridBagConstraints;", "splitColumns", "getCommentBorder", "Ljavax/swing/border/Border;", "CommentLabel", "ComponentPanelImpl", "Companion", "intellij.platform.ide"})
public class ComponentPanelBuilder
implements GridBagPanelBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JComponent myComponent;
    @Nullable
    private String myLabelText;
    private boolean myLabelOnTop;
    @Nullable
    private String myCommentText;
    @Nullable
    private Icon myCommentIcon;
    @NotNull
    private HyperlinkListener myHyperlinkListener;
    private boolean myCommentBelow;
    private boolean myCommentAllowAutoWrapping;
    @Nullable
    private String myHTDescription;
    @Nullable
    private String myHTLinkText;
    @Nullable
    private Runnable myHTAction;
    @Nullable
    private JComponent myTopRightComponent;
    @NotNull
    private UI.Anchor myAnchor;
    private boolean myResizeY;
    private boolean myResizeX;
    private boolean valid;
    public static final int MAX_COMMENT_WIDTH = 70;

    public ComponentPanelBuilder(@NotNull JComponent myComponent) {
        Intrinsics.checkNotNullParameter((Object)myComponent, (String)"myComponent");
        this.myComponent = myComponent;
        BrowserHyperlinkListener browserHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)browserHyperlinkListener), (String)"INSTANCE");
        this.myHyperlinkListener = (HyperlinkListener)((Object)browserHyperlinkListener);
        this.myCommentBelow = true;
        this.myCommentAllowAutoWrapping = true;
        this.myAnchor = UI.Anchor.Center;
        this.myResizeX = true;
        this.valid = true;
    }

    @NotNull
    public ComponentPanelBuilder resizeY(boolean resize) {
        this.myResizeY = resize;
        return this;
    }

    @NotNull
    public ComponentPanelBuilder resizeX(boolean resize) {
        this.myResizeX = resize;
        return this;
    }

    @NotNull
    public ComponentPanelBuilder withLabel(@NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        this.myLabelText = labelText;
        return this;
    }

    @NotNull
    public ComponentPanelBuilder moveLabelOnTop() {
        this.myLabelOnTop = true;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    @NotNull
    public ComponentPanelBuilder anchorLabelOn(@NotNull UI.Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)((Object)anchor), (String)"anchor");
        this.myAnchor = anchor;
        return this;
    }

    @NotNull
    public ComponentPanelBuilder withComment(@NlsContexts.DetailedDescription @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        return this.withComment(comment, true);
    }

    @NotNull
    public ComponentPanelBuilder withComment(@NotNull String comment, boolean allowAutoWrapping) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.myCommentText = comment;
        this.myCommentAllowAutoWrapping = allowAutoWrapping;
        this.valid = StringUtil.isEmpty((String)comment) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    @NotNull
    public ComponentPanelBuilder withCommentIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.myCommentIcon = icon;
        return this;
    }

    @NotNull
    public ComponentPanelBuilder withCommentHyperlinkListener(@NotNull HyperlinkListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myHyperlinkListener = listener2;
        return this;
    }

    @NotNull
    public ComponentPanelBuilder withTopRightComponent(@NotNull JComponent topRightComponent) {
        Intrinsics.checkNotNullParameter((Object)topRightComponent, (String)"topRightComponent");
        this.myTopRightComponent = topRightComponent;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)this.myHTDescription);
        return this;
    }

    @NotNull
    public ComponentPanelBuilder moveCommentRight() {
        this.myCommentBelow = false;
        return this;
    }

    @NotNull
    public ComponentPanelBuilder withTooltip(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.myHTDescription = description;
        this.valid = StringUtil.isEmpty((String)this.myCommentText) || StringUtil.isEmpty((String)description);
        return this;
    }

    @NotNull
    public ComponentPanelBuilder withTooltipLink(@NotNull String linkText, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)linkText, (String)"linkText");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.myHTLinkText = linkText;
        this.myHTAction = action;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        JPanel panel2 = null;
        if (UIUtil.getDeprecatedBackground() == null) {
            panel2 = new NonOpaquePanel(new GridBagLayout());
        } else {
            panel2 = new JPanel(new GridBagLayout());
            UIUtil.applyDeprecatedBackground((JComponent)panel2);
            UIUtil.applyDeprecatedBackground((JComponent)this.myComponent);
        }
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel2, gc, false);
        return panel2;
    }

    @Override
    public boolean constrainsValid() {
        return this.valid;
    }

    @Override
    public int gridWidth() {
        return this.myCommentBelow ? 2 : (this.myResizeX ? 4 : 3);
    }

    @Override
    public void addToPanel(@NotNull JPanel panel2, @NotNull GridBagConstraints gc, boolean splitColumns) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        if (this.constrainsValid()) {
            new ComponentPanelImpl(splitColumns).addToPanel(panel2, gc);
        }
    }

    private final Border getCommentBorder() {
        if (StringUtil.isNotEmpty((String)this.myCommentText)) {
            return (Border)new JBEmptyBorder(Companion.computeCommentInsets(this.myComponent, this.myCommentBelow));
        }
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        return (Border)jBEmptyBorder;
    }

    @JvmStatic
    @NotNull
    public static final Insets computeCommentInsets(@NotNull JComponent component, boolean commentBelow) {
        return Companion.computeCommentInsets(component, commentBelow);
    }

    @JvmStatic
    @NotNull
    public static final JLabel createCommentComponent(@Nullable String commentText, boolean isCommentBelow) {
        return Companion.createCommentComponent(commentText, isCommentBelow);
    }

    @JvmStatic
    @NotNull
    public static final JLabel createCommentComponent(@Nullable String commentText, boolean isCommentBelow, int maxLineLength) {
        return Companion.createCommentComponent(commentText, isCommentBelow, maxLineLength);
    }

    @JvmStatic
    @NotNull
    public static final JLabel createCommentComponent(@Nullable String commentText, boolean isCommentBelow, int maxLineLength, boolean allowAutoWrapping) {
        return Companion.createCommentComponent(commentText, isCommentBelow, maxLineLength, allowAutoWrapping);
    }

    @JvmStatic
    @NotNull
    public static final JLabel createNonWrappingCommentComponent(@NlsContexts.DetailedDescription @NotNull String commentText) {
        return Companion.createNonWrappingCommentComponent(commentText);
    }

    @JvmStatic
    @NotNull
    public static final Font getCommentFont(@Nullable Font font) {
        return Companion.getCommentFont(font);
    }

    public static final /* synthetic */ HyperlinkListener access$getMyHyperlinkListener$p(ComponentPanelBuilder $this) {
        return $this.myHyperlinkListener;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0016\u0012\r\b\u0001\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/ui/panel/ComponentPanelBuilder$CommentLabel;", "Lcom/intellij/ui/components/JBLabel;", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "<init>", "(Ljava/lang/String;)V", "setUI", "", "ui", "Ljavax/swing/plaf/LabelUI;", "intellij.platform.ide"})
    private static class CommentLabel
    extends JBLabel {
        public CommentLabel(@NlsContexts.Label @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
            this.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        }

        @Override
        public void setUI(@Nullable LabelUI ui) {
            super.setUI(ui);
            this.setFont(Companion.getCommentFont(this.getFont()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001f\u0010\f\u001a\u00020\r2\r\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0007J'\u0010\f\u001a\u00020\r2\r\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J/\u0010\f\u001a\u00020\r2\r\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000bH\u0007JA\u0010\f\u001a\u00020\r2\u0010\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u00152\r\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0017\u0010\u0017\u001a\u00020\r2\r\b\u0001\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0007J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0007J/\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\r2\r\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/ui/panel/ComponentPanelBuilder$Companion;", "", "<init>", "()V", "MAX_COMMENT_WIDTH", "", "computeCommentInsets", "Ljava/awt/Insets;", "component", "Ljavax/swing/JComponent;", "commentBelow", "", "createCommentComponent", "Ljavax/swing/JLabel;", "commentText", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "isCommentBelow", "maxLineLength", "allowAutoWrapping", "labelSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/ui/components/JBLabel;", "createNonWrappingCommentComponent", "getCommentFont", "Ljava/awt/Font;", "font", "setCommentText", "", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Insets computeCommentInsets(@NotNull JComponent component, boolean commentBelow) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            boolean isMacDefault = UIUtil.isUnderDefaultMacTheme();
            boolean isWin10 = UIUtil.isUnderWin10LookAndFeel();
            if (commentBelow) {
                int top = 8;
                int left = 2;
                int bottom = 0;
                if (component instanceof JRadioButton || component instanceof JCheckBox) {
                    int n = isWin10 ? 10 : (bottom = isMacDefault ? 8 : 9);
                    if (component instanceof JCheckBox) {
                        left = UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)((JCheckBox)component));
                        return new Insets(0, left, JBUIScale.scale((int)bottom), 0);
                    }
                    left = isMacDefault ? 26 : (isWin10 ? 17 : 23);
                } else if (component instanceof JTextField || component instanceof EditorTextComponent || component instanceof JComboBox || component instanceof ComponentWithBrowseButton) {
                    int n = top = isWin10 ? 3 : 4;
                    int n2 = isWin10 ? 2 : (left = isMacDefault ? 5 : 4);
                    bottom = isWin10 ? 10 : (isMacDefault ? 8 : 9);
                } else if (component instanceof JButton) {
                    int n = top = isWin10 ? 2 : 4;
                    left = isWin10 ? 2 : (isMacDefault ? 5 : 4);
                    bottom = 0;
                }
                JBInsets jBInsets = JBUI.insets((int)top, (int)left, (int)bottom, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
                return (Insets)jBInsets;
            }
            int left = 14;
            if (component instanceof JRadioButton || component instanceof JCheckBox) {
                left = isMacDefault ? 8 : 13;
            } else if (component instanceof JTextField || component instanceof EditorTextComponent || component instanceof JComboBox || component instanceof ComponentWithBrowseButton) {
                left = isMacDefault ? 13 : 14;
            }
            JBInsets jBInsets = JBUI.insetsLeft((int)left);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insetsLeft(...)");
            return (Insets)jBInsets;
        }

        @JvmStatic
        @NotNull
        public final JLabel createCommentComponent(@Nullable String commentText, boolean isCommentBelow) {
            return this.createCommentComponent(commentText, isCommentBelow, 70, true);
        }

        @JvmStatic
        @NotNull
        public final JLabel createCommentComponent(@Nullable String commentText, boolean isCommentBelow, int maxLineLength) {
            return this.createCommentComponent(commentText, isCommentBelow, maxLineLength, true);
        }

        @JvmStatic
        @NotNull
        public final JLabel createCommentComponent(@Nullable String commentText, boolean isCommentBelow, int maxLineLength, boolean allowAutoWrapping) {
            return this.createCommentComponent(Companion::createCommentComponent$lambda$0, commentText, isCommentBelow, maxLineLength, allowAutoWrapping);
        }

        private final JLabel createCommentComponent(Supplier<? extends JBLabel> labelSupplier, String commentText, boolean isCommentBelow, int maxLineLength, boolean allowAutoWrapping) {
            boolean isCopyable = SystemProperties.getBooleanProperty((String)"idea.ui.comment.copyable", (boolean)true);
            JBLabel jBLabel = labelSupplier.get().setCopyable(isCopyable).setAllowAutoWrapping(allowAutoWrapping);
            Intrinsics.checkNotNullExpressionValue((Object)jBLabel, (String)"setAllowAutoWrapping(...)");
            JLabel component = jBLabel;
            component.setVerticalTextPosition(1);
            component.setFocusable(false);
            if (isCopyable) {
                this.setCommentText(component, commentText, isCommentBelow, maxLineLength);
            } else {
                component.setText(commentText);
            }
            return component;
        }

        @JvmStatic
        @NotNull
        public final JLabel createNonWrappingCommentComponent(@NlsContexts.DetailedDescription @NotNull String commentText) {
            Intrinsics.checkNotNullParameter((Object)commentText, (String)"commentText");
            return new CommentLabel(commentText);
        }

        @JvmStatic
        @NotNull
        public final Font getCommentFont(@Nullable Font font) {
            if (ExperimentalUI.Companion.isNewUI()) {
                JBFont jBFont = JBFont.medium();
                Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"medium(...)");
                return (Font)jBFont;
            }
            Font font2 = RelativeFont.NORMAL.fromResource("ContextHelp.fontSizeOffset", -2).derive(font);
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"derive(...)");
            return font2;
        }

        private final void setCommentText(JLabel component, String commentText, boolean isCommentBelow, int maxLineLength) {
            if (commentText != null) {
                String css = "<head><style type=\"text/css\">\na, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}\na:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.VISITED) + ";}\na:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}\na:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}\n</style>\n</head>";
                HtmlChunk htmlChunk = HtmlChunk.raw((String)commentText);
                Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
                HtmlChunk text = htmlChunk;
                if (maxLineLength > 0 && commentText.length() > maxLineLength && isCommentBelow) {
                    FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
                    String string = commentText.substring(0, maxLineLength);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    int width = fontMetrics.stringWidth(string);
                    HtmlChunk.Element element = text.wrapWith(HtmlChunk.div().attr("width", width));
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"wrapWith(...)");
                    text = (HtmlChunk)element;
                } else {
                    HtmlChunk.Element element = text.wrapWith(HtmlChunk.div());
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"wrapWith(...)");
                    text = (HtmlChunk)element;
                }
                component.setText(new HtmlBuilder().append(HtmlChunk.raw((String)css)).append((HtmlChunk)text.wrapWith("body")).wrapWith("html").toString());
            }
        }

        private static final CommentLabel createCommentComponent$lambda$0() {
            return new CommentLabel("");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000e\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/ui/panel/ComponentPanelBuilder$ComponentPanelImpl;", "Lcom/intellij/openapi/ui/panel/ComponentPanel;", "splitColumns", "", "<init>", "(Lcom/intellij/openapi/ui/panel/ComponentPanelBuilder;Z)V", "label", "Ljavax/swing/JLabel;", "comment", "getCommentText", "", "setCommentText", "", "commentText", "setCommentTextImpl", "addToPanel", "panel", "Ljavax/swing/JPanel;", "gc", "Ljava/awt/GridBagConstraints;", "convertMouseEvent", "Ljava/awt/event/MouseEvent;", "e", "intellij.platform.ide"})
    private final class ComponentPanelImpl
    extends ComponentPanel {
        private final boolean splitColumns;
        @NotNull
        private final JLabel label;
        @NotNull
        private final JLabel comment;

        public ComponentPanelImpl(boolean splitColumns) {
            this.splitColumns = splitColumns;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                this.label = new JLabel();
                LabeledComponent.TextWithMnemonic.fromTextWithMnemonic(ComponentPanelBuilder.this.myLabelText).setToLabel(this.label);
                this.label.setLabelFor(ComponentPanelBuilder.this.myComponent);
            } else {
                this.label = new JLabel("");
            }
            this.comment = Companion.createCommentComponent(() -> ComponentPanelImpl._init_$lambda$0(ComponentPanelBuilder.this), ComponentPanelBuilder.this.myCommentText, ComponentPanelBuilder.this.myCommentBelow, 70, ComponentPanelBuilder.this.myCommentAllowAutoWrapping);
            if (ComponentPanelBuilder.this.myCommentIcon != null) {
                this.comment.setIcon(ComponentPanelBuilder.this.myCommentIcon);
            }
            this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
        }

        @Override
        @Nullable
        public String getCommentText() {
            return ComponentPanelBuilder.this.myCommentText;
        }

        @Override
        public void setCommentText(@Nullable String commentText) {
            if (!StringUtil.equals((CharSequence)ComponentPanelBuilder.this.myCommentText, (CharSequence)commentText)) {
                ComponentPanelBuilder.this.myCommentText = commentText;
                this.setCommentTextImpl(commentText);
            }
        }

        public void setCommentTextImpl(@Nullable String commentText) {
            Companion.setCommentText(this.comment, commentText, ComponentPanelBuilder.this.myCommentBelow, 70);
        }

        public void addToPanel(@NotNull JPanel panel2, @NotNull GridBagConstraints gc) {
            int n;
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.anchor = 21;
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myLabelText)) {
                if (ComponentPanelBuilder.this.myLabelOnTop || ComponentPanelBuilder.this.myTopRightComponent != null) {
                    gc.insets = (Insets)JBUI.insetsBottom((int)4);
                    gc.gridx = 1;
                    JPanel topPanel = new JPanel();
                    topPanel.setLayout(new BoxLayout(topPanel, 0));
                    if (ComponentPanelBuilder.this.myLabelOnTop) {
                        topPanel.add(this.label);
                    }
                    if (ComponentPanelBuilder.this.myTopRightComponent != null) {
                        topPanel.add(new Box.Filler((Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)10, (int)0), (Dimension)JBUI.size((int)Integer.MAX_VALUE)));
                        topPanel.add(ComponentPanelBuilder.this.myTopRightComponent);
                    }
                    panel2.add((Component)topPanel, gc);
                    n = gc.gridy;
                    gc.gridy = n + 1;
                }
                if (!ComponentPanelBuilder.this.myLabelOnTop) {
                    gc.gridx = 0;
                    switch (WhenMappings.$EnumSwitchMapping$0[ComponentPanelBuilder.this.myAnchor.ordinal()]) {
                        case 1: {
                            gc.anchor = 19;
                            gc.insets = (Insets)JBUI.insets((int)4, (int)0, (int)0, (int)8);
                            break;
                        }
                        case 2: {
                            gc.anchor = 21;
                            gc.insets = (Insets)JBUI.insetsRight((int)8);
                            break;
                        }
                        case 3: {
                            gc.anchor = 20;
                            gc.insets = (Insets)JBUI.insets((int)0, (int)0, (int)4, (int)8);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    panel2.add((Component)this.label, gc);
                }
            }
            gc.gridx = gc.gridx + (ComponentPanelBuilder.this.myLabelOnTop ? 0 : 1);
            gc.weightx = 1.0;
            gc.insets = (Insets)JBInsets.emptyInsets();
            gc.fill = ComponentPanelBuilder.this.myResizeY ? 1 : (ComponentPanelBuilder.this.myResizeX ? 2 : 0);
            double d = gc.weighty = ComponentPanelBuilder.this.myResizeY ? 1.0 : 0.0;
            if (this.splitColumns) {
                panel2.add((Component)ComponentPanelBuilder.this.myComponent, gc);
            }
            if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription) || !ComponentPanelBuilder.this.myCommentBelow) {
                JPanel componentPanel = new JPanel();
                componentPanel.setLayout(new BoxLayout(componentPanel, 0));
                if (!this.splitColumns) {
                    componentPanel.add(ComponentPanelBuilder.this.myComponent);
                }
                if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTDescription)) {
                    ContextHelpLabel contextHelpLabel;
                    if (StringUtil.isNotEmpty((String)ComponentPanelBuilder.this.myHTLinkText) && ComponentPanelBuilder.this.myHTAction != null) {
                        String string = ComponentPanelBuilder.this.myHTDescription;
                        Intrinsics.checkNotNull((Object)string);
                        String string2 = ComponentPanelBuilder.this.myHTLinkText;
                        Intrinsics.checkNotNull((Object)string2);
                        Runnable runnable = ComponentPanelBuilder.this.myHTAction;
                        Intrinsics.checkNotNull((Object)runnable);
                        contextHelpLabel = ContextHelpLabel.createWithLink(null, string, string2, runnable);
                    } else {
                        String string = ComponentPanelBuilder.this.myHTDescription;
                        Intrinsics.checkNotNull((Object)string);
                        contextHelpLabel = ContextHelpLabel.create(string);
                    }
                    ContextHelpLabel contextHelpLabel2 = contextHelpLabel;
                    Intrinsics.checkNotNull((Object)contextHelpLabel2);
                    ContextHelpLabel lbl = contextHelpLabel2;
                    JBUI.Borders.emptyLeft((int)7).wrap((JComponent)lbl);
                    componentPanel.add(lbl);
                    ComponentValidator.getInstance(ComponentPanelBuilder.this.myComponent).ifPresent(arg_0 -> ComponentPanelImpl.addToPanel$lambda$0(componentPanel, ComponentPanelBuilder.this, this, lbl, arg_0));
                    panel2.add((Component)componentPanel, gc);
                } else if (!ComponentPanelBuilder.this.myCommentBelow) {
                    if (this.splitColumns) {
                        n = gc.gridx;
                        gc.gridx = n + 1;
                        gc.weightx = 0.0;
                        gc.fill = 0;
                        gc.weighty = 0.0;
                        panel2.add((Component)this.comment, gc);
                    } else {
                        this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
                        componentPanel.add(this.comment);
                        panel2.add((Component)componentPanel, gc);
                    }
                }
            } else if (!this.splitColumns) {
                panel2.add((Component)ComponentPanelBuilder.this.myComponent, gc);
            }
            if (!this.splitColumns && !ComponentPanelBuilder.this.myResizeX) {
                int n2 = gc.gridx;
                gc.gridx = n2 + 1;
                gc.weightx = 1.0;
                gc.fill = 0;
                panel2.add((Component)new JPanel(), gc);
            }
            gc.fill = 2;
            gc.weighty = 0.0;
            if (ComponentPanelBuilder.this.myCommentBelow) {
                gc.gridx = 1;
                int n3 = gc.gridy;
                gc.gridy = n3 + 1;
                gc.weightx = 0.0;
                gc.anchor = 18;
                gc.insets = (Insets)JBInsets.emptyInsets();
                this.comment.setBorder(ComponentPanelBuilder.this.getCommentBorder());
                panel2.add((Component)this.comment, gc);
                if (!ComponentPanelBuilder.this.myResizeX) {
                    n3 = gc.gridx;
                    gc.gridx = n3 + 1;
                    gc.weightx = 1.0;
                    gc.fill = 0;
                    panel2.add((Component)new JPanel(), gc);
                }
            }
            ComponentPanelBuilder.this.myComponent.putClientProperty("JComponent.decoratedPanel", this);
            int n4 = gc.gridy;
            gc.gridy = n4 + 1;
        }

        @NotNull
        public final MouseEvent convertMouseEvent(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Point p = e.getPoint();
            SwingUtilities.convertPoint(e.getComponent(), p, ComponentPanelBuilder.this.myComponent);
            return new MouseEvent(ComponentPanelBuilder.this.myComponent, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        private static final JBLabel _init_$lambda$0(ComponentPanelBuilder this$0) {
            return new CommentLabel(this$0){
                final /* synthetic */ ComponentPanelBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super("");
                }

                protected HyperlinkListener createHyperlinkListener() {
                    return ComponentPanelBuilder.access$getMyHyperlinkListener$p(this.this$0);
                }
            };
        }

        private static final void addToPanel$lambda$0$0(JLabel $iconLabel, ContextHelpLabel $lbl, JPanel $componentPanel, PropertyChangeEvent evt) {
            PropertyChangeEvent propertyChangeEvent = evt;
            Intrinsics.checkNotNull((Object)propertyChangeEvent);
            if (propertyChangeEvent.getNewValue() == null) {
                $iconLabel.setVisible(false);
                $lbl.setVisible(true);
            } else if (Intrinsics.areEqual((Object)"warning", (Object)evt.getNewValue())) {
                $iconLabel.setIcon(AllIcons.General.BalloonWarning);
                $iconLabel.setVisible(true);
                $lbl.setVisible(false);
            } else if (Intrinsics.areEqual((Object)"error", (Object)evt.getNewValue())) {
                $iconLabel.setIcon(AllIcons.General.BalloonError);
                $iconLabel.setVisible(true);
                $lbl.setVisible(false);
            }
            $componentPanel.revalidate();
            $componentPanel.repaint();
        }

        private static final void addToPanel$lambda$0(JPanel $componentPanel, ComponentPanelBuilder this$0, ComponentPanelImpl this$1, ContextHelpLabel $lbl, ComponentValidator componentValidator) {
            Intrinsics.checkNotNullParameter((Object)componentValidator, (String)"<unused var>");
            JLabel iconLabel = new JLabel();
            JBUI.Borders.emptyLeft((int)7).wrap((JComponent)iconLabel);
            iconLabel.setVisible(false);
            $componentPanel.add(iconLabel);
            iconLabel.addMouseListener(new MouseAdapter(this$0, this$1){
                final /* synthetic */ ComponentPanelBuilder this$0;
                final /* synthetic */ ComponentPanelImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void mouseEntered(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ComponentPanelBuilder.access$getMyComponent$p(this.this$0).dispatchEvent(this.this$1.convertMouseEvent(e));
                    e.consume();
                }

                public void mouseExited(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ComponentPanelBuilder.access$getMyComponent$p(this.this$0).dispatchEvent(this.this$1.convertMouseEvent(e));
                    e.consume();
                }
            });
            this$0.myComponent.addPropertyChangeListener("JComponent.outline", arg_0 -> ComponentPanelImpl.addToPanel$lambda$0$0(iconLabel, $lbl, $componentPanel, arg_0));
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[UI.Anchor.values().length];
                try {
                    nArray[UI.Anchor.Top.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UI.Anchor.Center.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UI.Anchor.Bottom.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

