/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service
@ApiStatus.Experimental
public final class HelpIdAwareLinkListener
extends BrowserHyperlinkListener {
    @NonNls
    private static final String HELP_LINK_MARKER = "helpInstance:";
    @NonNls
    private static final String URL_TEMPLATE = "https://www.jetbrains.com/help/%s?%s&utm_version=%s";

    @NotNull
    public static HelpIdAwareLinkListener getInstance() {
        HelpIdAwareLinkListener helpIdAwareLinkListener = (HelpIdAwareLinkListener)((Object)ApplicationManager.getApplication().getService(HelpIdAwareLinkListener.class));
        if (helpIdAwareLinkListener == null) {
            HelpIdAwareLinkListener.$$$reportNull$$$0(0);
        }
        return helpIdAwareLinkListener;
    }

    @Override
    protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
        String wouldBeHelpId;
        String description;
        if (e == null) {
            HelpIdAwareLinkListener.$$$reportNull$$$0(1);
        }
        if ((description = e.getDescription()) != null && description.trim().startsWith(HELP_LINK_MARKER) && StringUtil.isNotEmpty((String)(wouldBeHelpId = description.trim().substring(HELP_LINK_MARKER.length()).trim()))) {
            String productName;
            ApplicationNamesInfo nameInfo = ApplicationNamesInfo.getInstance();
            String editionName = nameInfo.getEditionName();
            String productWebPath = switch (productName = StringUtil.toLowerCase((String)nameInfo.getProductName())) {
                case "rubymine", "ruby" -> "ruby";
                case "intellij idea", "idea" -> "idea";
                case "goland" -> "go";
                case "appcode" -> "objc";
                case "rustrover" -> "rust";
                case "pycharm" -> {
                    if (editionName != null && "edu".equals(StringUtil.toLowerCase((String)editionName))) {
                        yield "pycharm-edu";
                    }
                    yield "pycharm";
                }
                default -> productName;
            };
            BrowserUtil.browse(String.format(URL_TEMPLATE, productWebPath, wouldBeHelpId, ApplicationInfo.getInstance().getShortVersion()));
            return;
        }
        super.hyperlinkActivated(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/HelpIdAwareLinkListener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/HelpIdAwareLinkListener";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hyperlinkActivated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

