/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.InlineBannerBase;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.FinalLayoutWrapper;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u000256B&\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u000bB\"\b\u0017\u0012\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\fJ%\u0010\u001b\u001a\u00020\u00162\u000b\u0010\u001c\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0013\u0010!\u001a\u00020\u00002\u000b\u0010\"\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004J\u0010\u0010#\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001d\u0010$\u001a\u00020\u00162\u000b\u0010\"\u001a\u00070\u0003\u00a2\u0006\u0002\b%2\u0006\u0010&\u001a\u00020\u0019H\u0007J#\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(2\u000b\u0010)\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010&\u001a\u00020\u0019H\u0002J+\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190(2\u000b\u0010)\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020\u0019J\u001b\u0010*\u001a\u00020\u00002\u000b\u0010)\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010&\u001a\u00020\u0019J\b\u0010+\u001a\u00020,H\u0007J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0019J\u0006\u00101\u001a\u00020,J\b\u00102\u001a\u00020,H\u0016J\u001b\u00103\u001a\u00020\u00002\u000b\u0010\u001c\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010&\u001a\u00020\u0019J\b\u00104\u001a\u00020,H\u0002R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/ui/InlineBanner;", "Lcom/intellij/ui/InlineBannerBase;", "messageText", "", "Lorg/jetbrains/annotations/Nls;", "status", "Lcom/intellij/ui/EditorNotificationPanel$Status;", "gap", "", "<init>", "(Ljava/lang/String;Lcom/intellij/ui/EditorNotificationPanel$Status;I)V", "(Lcom/intellij/ui/EditorNotificationPanel$Status;)V", "(Ljava/lang/String;Lcom/intellij/ui/EditorNotificationPanel$Status;)V", "value", "getStatus", "()Lcom/intellij/ui/EditorNotificationPanel$Status;", "setStatus", "myIcon", "Lcom/intellij/ui/components/JBLabel;", "myButtonPanel", "Ljavax/swing/JPanel;", "myCloseButton", "Ljavax/swing/JComponent;", "myGearButton", "myCloseAction", "Ljava/lang/Runnable;", "myActionPanel", "createInplaceButton", "tooltip", "icon", "Ljavax/swing/Icon;", "listener", "Ljava/awt/event/ActionListener;", "setMessage", "text", "setIcon", "createActionLabel", "Lcom/intellij/openapi/util/NlsContexts$Label;", "action", "addActionImpl", "Lcom/intellij/ui/components/labels/LinkLabel;", "name", "addAction", "removeAllActions", "", "showCloseButton", "visible", "", "setCloseAction", "close", "removeFromParent", "setGearAction", "updateButtonsSize", "DropDownActionLayout", "DropDownAction", "intellij.platform.ide"})
public class InlineBanner
extends InlineBannerBase {
    @NotNull
    private EditorNotificationPanel.Status status;
    @NotNull
    private final JBLabel myIcon;
    @NotNull
    private final JPanel myButtonPanel;
    @NotNull
    private final JComponent myCloseButton;
    @Nullable
    private JComponent myGearButton;
    @Nullable
    private Runnable myCloseAction;
    @NotNull
    private final JPanel myActionPanel;

    private InlineBanner(String messageText, EditorNotificationPanel.Status status, int gap) {
        super(status, gap, messageText);
        this.status = status;
        this.myIcon = new JBLabel();
        String string = IdeBundle.message("editor.banner.close.tooltip", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = AllIcons.General.Close;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Close");
        this.myCloseButton = this.createInplaceButton(string, icon, arg_0 -> InlineBanner._init_$lambda$0(this, arg_0));
        this.setLayout(new BorderLayout(gap){

            @Override
            public void addLayoutComponent(String name, Component comp) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                if (comp != myCloseButton && comp != myGearButton) {
                    super.addLayoutComponent(name, comp);
                }
            }

            @Override
            public void layoutContainer(Container target) {
                Dimension size;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super.layoutContainer(target);
                int y = JBUI.scale((int)7);
                int x = target.getWidth() - JBUI.scale((int)7);
                if (myCloseButton.isVisible()) {
                    size = myCloseButton.getPreferredSize();
                    myCloseButton.setBounds(x -= size.width, y, size.width, size.height);
                    x -= JBUI.scale((int)2);
                }
                if (myGearButton != null) {
                    JComponent jComponent = myGearButton;
                    Intrinsics.checkNotNull((Object)jComponent);
                    size = jComponent.getPreferredSize();
                    JComponent jComponent2 = myGearButton;
                    Intrinsics.checkNotNull((Object)jComponent2);
                    jComponent2.setBounds(x -= size.width, y, size.width, size.height);
                }
            }
        });
        this.getIconPanel().add((Component)this.myIcon, "North");
        this.setIcon(status.getIcon());
        this.add(this.getIconPanel(), "West");
        this.add(this.getCenterPanel());
        this.add(this.myCloseButton);
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setOpaque(this.isOpaque());
        titlePanel.setBackground(this.getBackground());
        titlePanel.add(this.getMessage());
        this.getCenterPanel().add(titlePanel);
        this.myButtonPanel = new JPanel();
        this.myButtonPanel.setOpaque(this.isOpaque());
        this.updateButtonsSize();
        titlePanel.add((Component)this.myButtonPanel, "East");
        this.myActionPanel = new JPanel((LayoutManager)((Object)new DropDownActionLayout(new HorizontalLayout(JBUI.scale((int)16), 0, 2, null))));
        this.myActionPanel.setOpaque(this.isOpaque());
        this.myActionPanel.setVisible(false);
        this.myActionPanel.add(new DropDownAction());
        this.getCenterPanel().add(this.myActionPanel);
        this.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
    }

    @Override
    @NotNull
    public EditorNotificationPanel.Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(@NotNull EditorNotificationPanel.Status value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        this.status = value2;
        this.setIcon(value2.getIcon());
        super.setStatus(value2);
    }

    public InlineBanner(@NotNull EditorNotificationPanel.Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this("", status);
    }

    @JvmOverloads
    public InlineBanner(@NotNull String messageText, @NotNull EditorNotificationPanel.Status status) {
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this(messageText, status, JBUI.scale((int)8));
    }

    public /* synthetic */ InlineBanner(String string, EditorNotificationPanel.Status status, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            status = EditorNotificationPanel.Status.Info;
        }
        this(string, status);
    }

    private final JComponent createInplaceButton(String tooltip, Icon icon, ActionListener listener2) {
        IconButton iconButton = new IconButton(null, icon, null, null);
        InplaceButton button2 = new InplaceButton(tooltip, listener2, iconButton){
            private final Timer myTimer;
            private boolean myClick;
            {
                this.myTimer = new Timer(300, arg_0 -> createInplaceButton.button.1.myTimer$lambda$0(this, arg_0));
            }

            private final void startClickTimer() {
                this.myClick = true;
                this.repaint();
                this.myTimer.start();
            }

            private final void stopClickTimer() {
                this.myClick = false;
                this.repaint();
                this.myTimer.stop();
            }

            public void doClick(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.startClickTimer();
                super.doClick(e);
            }

            protected void paintHover(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                this.paintHover(g, this.myClick ? JBUI.CurrentTheme.InlineBanner.PRESSED_BACKGROUND : JBUI.CurrentTheme.InlineBanner.HOVER_BACKGROUND);
            }

            private static final void myTimer$lambda$0(createInplaceButton.button.1 this$0, ActionEvent it) {
                this$0.stopClickTimer();
            }
        };
        button2.setPreferredSize((Dimension)new JBDimension(26, 26));
        return button2;
    }

    @NotNull
    public final InlineBanner setMessage(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setMessageText(text);
        return this;
    }

    @NotNull
    public final InlineBanner setIcon(@Nullable Icon icon) {
        this.myIcon.setIcon(icon);
        this.myIcon.setVisible(icon != null);
        this.getIconPanel().setVisible(icon != null);
        return this;
    }

    @ApiStatus.Internal
    @NotNull
    public final JComponent createActionLabel(@NotNull String text, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.addActionImpl(text, action);
    }

    private final LinkLabel<Runnable> addActionImpl(String name, Runnable action) {
        return this.addAction(name, null, action);
    }

    @NotNull
    public final LinkLabel<Runnable> addAction(@NotNull String name, @Nullable Icon icon, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.myActionPanel.setVisible(true);
        LinkListener<Runnable> linkListener = InlineBanner::addAction$lambda$0;
        LinkLabel<Runnable> label2 = new LinkLabel<Runnable>(name, icon, action, linkListener){

            protected Color getTextColor() {
                Color color = JBUI.CurrentTheme.Link.Foreground.ENABLED;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ENABLED");
                return color;
            }
        };
        this.myActionPanel.add((Component)label2, this.myActionPanel.getComponentCount() - 1);
        return label2;
    }

    @NotNull
    public final InlineBanner addAction(@NotNull String name, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.addActionImpl(name, action);
        return this;
    }

    @ApiStatus.Internal
    public final void removeAllActions() {
        this.myActionPanel.removeAll();
        this.myActionPanel.add(new DropDownAction());
    }

    @NotNull
    public final InlineBanner showCloseButton(boolean visible) {
        this.myCloseButton.setVisible(visible);
        this.updateButtonsSize();
        return this;
    }

    @NotNull
    public final InlineBanner setCloseAction(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.myCloseAction = action;
        return this;
    }

    public final void close() {
        Runnable runnable = this.myCloseAction;
        if (runnable != null) {
            runnable.run();
        }
        this.removeFromParent();
    }

    public void removeFromParent() {
        block3: {
            Container parent;
            Container container = parent = this.getParent();
            if (container != null) {
                container.remove((Component)((Object)this));
            }
            Container container2 = parent;
            if (container2 != null) {
                container2.doLayout();
            }
            Container container3 = parent;
            if (container3 != null) {
                container3.revalidate();
            }
            Container container4 = parent;
            if (container4 == null) break block3;
            container4.repaint();
        }
    }

    @NotNull
    public final InlineBanner setGearAction(@NotNull String tooltip, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (this.myGearButton != null) {
            this.remove(this.myGearButton);
        }
        Icon icon = AllIcons.General.GearPlain;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GearPlain");
        this.myGearButton = this.createInplaceButton(tooltip, icon, arg_0 -> InlineBanner.setGearAction$lambda$0(action, arg_0));
        this.add(this.myGearButton);
        this.updateButtonsSize();
        return this;
    }

    private final void updateButtonsSize() {
        int buttons = 0;
        if (this.myCloseButton.isVisible()) {
            ++buttons;
        }
        if (this.myGearButton != null) {
            ++buttons;
        }
        this.myButtonPanel.setPreferredSize((Dimension)new JBDimension(buttons * 22, 16));
    }

    @JvmOverloads
    public InlineBanner(@NotNull String messageText) {
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        this(messageText, null, 2, null);
    }

    @JvmOverloads
    public InlineBanner() {
        this(null, null, 3, null);
    }

    private static final void _init_$lambda$0(InlineBanner this$0, ActionEvent it) {
        this$0.close();
    }

    private static final void addAction$lambda$0(LinkLabel linkLabel, Runnable action) {
        action.run();
    }

    private static final void setGearAction$lambda$0(Runnable $action, ActionEvent it) {
        $action.run();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ui/InlineBanner$DropDownAction;", "Lcom/intellij/ui/components/labels/LinkLabel;", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/ui/InlineBanner;)V", "intellij.platform.ide"})
    private final class DropDownAction
    extends LinkLabel<Runnable> {
        public DropDownAction() {
            this.setHorizontalTextPosition(10);
            this.setIconTextGap(JBUI.scale((int)1));
            this.setIcon(new Icon(){
                private final Icon icon;
                {
                    Icon icon = AllIcons.General.LinkDropTriangle;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LinkDropTriangle");
                    this.icon = icon;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    this.icon.paintIcon(c, g, x, y + 1);
                }

                @Override
                public int getIconWidth() {
                    return this.icon.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return this.icon.getIconHeight();
                }
            });
            this.setListener(DropDownAction::_init_$lambda$0, null);
            this.setText(IdeCoreBundle.message((String)"notifications.action.more", (Object[])new Object[0]));
            this.setVisible(false);
        }

        private static final void _init_$lambda$0(LinkLabel link, Runnable runnable) {
            if (link.isShowing()) {
                DefaultActionGroup group = new DefaultActionGroup();
                LayoutManager layoutManager = link.getParent().getLayout();
                Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.intellij.ui.InlineBanner.DropDownActionLayout");
                DropDownActionLayout layout = (DropDownActionLayout)((Object)layoutManager);
                Iterator<LinkLabel<Runnable>> iterator = layout.getActions().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<LinkLabel<Runnable>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    LinkLabel<Runnable> action;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                    if (action.isVisible()) continue;
                    String string = action.getText();
                    group.add((AnAction)new DumbAwareAction(action, string){
                        final /* synthetic */ LinkLabel<Runnable> $action;
                        {
                            this.$action = $action;
                            super($super_call_param$1);
                        }

                        public void actionPerformed(AnActionEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            this.$action.getLinkData().run();
                        }
                    });
                }
                ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("InlineBanner", (ActionGroup)group);
                Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
                ActionPopupMenu menu = actionPopupMenu;
                menu.getComponent().show(link, JBUIScale.scale((int)-10), link.getHeight() + JBUIScale.scale((int)2));
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R-\u0010\u0006\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00060\u000eR\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ui/InlineBanner$DropDownActionLayout;", "Lcom/intellij/util/ui/FinalLayoutWrapper;", "layout", "Ljava/awt/LayoutManager2;", "<init>", "(Ljava/awt/LayoutManager2;)V", "actions", "Ljava/util/ArrayList;", "Lcom/intellij/ui/components/labels/LinkLabel;", "Ljava/lang/Runnable;", "Lkotlin/collections/ArrayList;", "getActions", "()Ljava/util/ArrayList;", "myDropDownAction", "Lcom/intellij/ui/InlineBanner$DropDownAction;", "Lcom/intellij/ui/InlineBanner;", "addLayoutComponent", "", "comp", "Ljava/awt/Component;", "constraints", "", "name", "", "add", "component", "layoutContainer", "parent", "Ljava/awt/Container;", "intellij.platform.ide"})
    private static final class DropDownActionLayout
    extends FinalLayoutWrapper {
        @NotNull
        private final ArrayList<LinkLabel<Runnable>> actions;
        private DropDownAction myDropDownAction;

        public DropDownActionLayout(@NotNull LayoutManager2 layout) {
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            super(layout);
            this.actions = new ArrayList();
        }

        @NotNull
        public final ArrayList<LinkLabel<Runnable>> getActions() {
            return this.actions;
        }

        public void addLayoutComponent(@NotNull Component comp, @Nullable Object constraints) {
            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
            super.addLayoutComponent(comp, constraints);
            this.add(comp);
        }

        public void addLayoutComponent(@Nullable String name, @NotNull Component comp) {
            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
            super.addLayoutComponent(name, comp);
            this.add(comp);
        }

        private final void add(Component component) {
            if (component instanceof DropDownAction) {
                this.myDropDownAction = (DropDownAction)component;
            } else if (component instanceof LinkLabel) {
                this.actions.add((LinkLabel)component);
                LayoutManager2 layoutManager2 = this.getLayout();
                DropDownAction dropDownAction = this.myDropDownAction;
                if (dropDownAction == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myDropDownAction");
                    dropDownAction = null;
                }
                layoutManager2.removeLayoutComponent(dropDownAction);
                LayoutManager2 layoutManager22 = this.getLayout();
                DropDownAction dropDownAction2 = this.myDropDownAction;
                if (dropDownAction2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myDropDownAction");
                    dropDownAction2 = null;
                }
                layoutManager22.addLayoutComponent(dropDownAction2, null);
            }
        }

        public void layoutContainer(@NotNull Container parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            int width = parent.getWidth();
            int size = this.actions.size();
            int collapseIndex = size - 1;
            if (size < 4) {
                DropDownAction dropDownAction = this.myDropDownAction;
                if (dropDownAction == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myDropDownAction");
                    dropDownAction = null;
                }
                dropDownAction.setVisible(false);
                Iterator<LinkLabel<Runnable>> iterator = this.actions.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<LinkLabel<Runnable>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    LinkLabel<Runnable> action;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                    action.setVisible(true);
                }
            } else {
                this.actions.get(0).setVisible(true);
                this.actions.get(1).setVisible(true);
                collapseIndex = 1;
                DropDownAction dropDownAction = this.myDropDownAction;
                if (dropDownAction == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myDropDownAction");
                    dropDownAction = null;
                }
                dropDownAction.setVisible(true);
                for (int i = 2; i < size; ++i) {
                    this.actions.get(i).setVisible(false);
                }
            }
            this.getLayout().layoutContainer(parent);
            if (parent.getPreferredSize().width > width) {
                DropDownAction dropDownAction = this.myDropDownAction;
                if (dropDownAction == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myDropDownAction");
                    dropDownAction = null;
                }
                dropDownAction.setVisible(true);
                this.actions.get(collapseIndex).setVisible(false);
                --collapseIndex;
                this.getLayout().layoutContainer(parent);
                while (parent.getPreferredSize().width > width && collapseIndex >= 0 && collapseIndex < size) {
                    this.actions.get(collapseIndex).setVisible(false);
                    --collapseIndex;
                    this.getLayout().layoutContainer(parent);
                }
            }
        }
    }
}

