/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.ui.accessibility.AccessibleContextDelegateWithContextMenu;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendableTextField
extends JBTextField
implements ExtendableTextComponent {
    private List<ExtendableTextComponent.Extension> extensions = Collections.emptyList();

    public ExtendableTextField() {
        this(null);
    }

    public ExtendableTextField(int columns) {
        this(null, columns);
    }

    public ExtendableTextField(@Nls String text) {
        this(text, 20);
    }

    public ExtendableTextField(@Nls String text, int columns) {
        super(text, columns);
    }

    @Override
    public List<ExtendableTextComponent.Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(ExtendableTextComponent.Extension ... extensions) {
        this.setExtensions(Arrays.asList(extensions));
    }

    @Override
    public void setExtensions(Collection<? extends ExtendableTextComponent.Extension> extensions) {
        this.setExtensions((List<? extends ExtendableTextComponent.Extension>)new ArrayList<ExtendableTextComponent.Extension>(extensions));
    }

    private void setExtensions(List<? extends ExtendableTextComponent.Extension> extensions) {
        this.putClientProperty("JTextField.variant", null);
        this.extensions = Collections.unmodifiableList(extensions);
        this.putClientProperty("JTextField.variant", "extendable");
    }

    @Override
    public void addExtension(@NotNull ExtendableTextComponent.Extension extension) {
        if (extension == null) {
            ExtendableTextField.$$$reportNull$$$0(0);
        }
        if (!this.getExtensions().contains(extension)) {
            ArrayList<ExtendableTextComponent.Extension> extensions = new ArrayList<ExtendableTextComponent.Extension>(this.getExtensions());
            extensions.add(extension);
            this.setExtensions((List<? extends ExtendableTextComponent.Extension>)extensions);
        }
    }

    @Override
    public void removeExtension(@NotNull ExtendableTextComponent.Extension extension) {
        ArrayList<ExtendableTextComponent.Extension> extensions;
        if (extension == null) {
            ExtendableTextField.$$$reportNull$$$0(1);
        }
        if ((extensions = new ArrayList<ExtendableTextComponent.Extension>(this.getExtensions())).remove(extension)) {
            this.setExtensions((List<? extends ExtendableTextComponent.Extension>)extensions);
        }
    }

    @Override
    @Deprecated
    public void setUI(TextUI ui) {
        TextUI suggested = ui;
        try {
            if (ui == null || !Class.forName("com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI").isAssignableFrom(ui.getClass())) {
                ui = (TextUI)Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI").getDeclaredMethod("createUI", JComponent.class).invoke(null, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setUI(ui);
        if (ui != suggested) {
            try {
                this.setBorder((Border)Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder").newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ApiStatus.Experimental
    public ExtendableTextField addBrowseExtension(@NotNull Runnable action, @Nullable Disposable parentDisposable) {
        if (action == null) {
            ExtendableTextField.$$$reportNull$$$0(2);
        }
        return this.addBrowseExtension(action, parentDisposable, true);
    }

    @ApiStatus.Experimental
    public ExtendableTextField addBrowseExtension(final @NotNull Runnable action, @Nullable Disposable parentDisposable, boolean focusable) {
        if (action == null) {
            ExtendableTextField.$$$reportNull$$$0(3);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 64);
        String tooltip = UIBundle.message("component.with.browse.button.browse.button.tooltip.text", new Object[0]) + " (" + KeymapUtil.getKeystrokeText(keyStroke) + ")";
        ExtendableTextComponent.Extension browseExtension = ExtendableTextComponent.Extension.create(AllIcons.General.OpenDisk, AllIcons.General.OpenDiskHover, tooltip, focusable, action);
        new DumbAwareAction(this){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                action.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/components/fields/ExtendableTextField$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), (JComponent)this, parentDisposable);
        this.addExtension(browseExtension);
        return this;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleContextDelegateWithContextMenu(this.getOriginalAccessibleContext()){

                protected void doShowContextMenu() {
                    ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("ShowPopupMenu"), null, null, null, true);
                }

                protected Container getDelegateParent() {
                    return ExtendableTextField.this.getParent();
                }
            };
        }
        return this.accessibleContext;
    }

    protected AccessibleContext getOriginalAccessibleContext() {
        return super.getAccessibleContext();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/fields/ExtendableTextField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeExtension";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addBrowseExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

