/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsX;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsY;
import com.intellij.ui.dsl.gridLayout.impl.Cell;
import com.intellij.ui.dsl.gridLayout.impl.GridImplKt;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0005H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\bH\u00c6\u0003J\t\u00102\u001a\u00020\nH\u00c6\u0003J;\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0014\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u00107\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u00108\u001a\u000209H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001fR\u0011\u0010$\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001fR\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010)\"\u0004\b,\u0010-\u00a8\u0006:"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "", "cell", "Lcom/intellij/ui/dsl/gridLayout/impl/Cell;", "minimumSize", "Ljava/awt/Dimension;", "preferredSize", "unscaledColumnGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsX;", "unscaledRowGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "<init>", "(Lcom/intellij/ui/dsl/gridLayout/impl/Cell;Ljava/awt/Dimension;Ljava/awt/Dimension;Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsX;Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;)V", "getCell", "()Lcom/intellij/ui/dsl/gridLayout/impl/Cell;", "getMinimumSize", "()Ljava/awt/Dimension;", "getPreferredSize", "getUnscaledColumnGaps", "()Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsX;", "getUnscaledRowGaps", "()Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "baseline", "", "getBaseline", "()Ljava/lang/Integer;", "setBaseline", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "gapWidth", "getGapWidth", "()I", "gapHeight", "getGapHeight", "cellPaddedMinimumWidth", "getCellPaddedMinimumWidth", "cellPaddedPreferredWidth", "getCellPaddedPreferredWidth", "scaledGaps", "Lcom/intellij/ui/dsl/gridLayout/Gaps;", "getScaledGaps", "()Lcom/intellij/ui/dsl/gridLayout/Gaps;", "scaledVisualPaddings", "getScaledVisualPaddings", "setScaledVisualPaddings", "(Lcom/intellij/ui/dsl/gridLayout/Gaps;)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide"})
final class LayoutCellData {
    @NotNull
    private final Cell cell;
    @NotNull
    private final Dimension minimumSize;
    @NotNull
    private final Dimension preferredSize;
    @NotNull
    private final UnscaledGapsX unscaledColumnGaps;
    @NotNull
    private final UnscaledGapsY unscaledRowGaps;
    @Nullable
    private Integer baseline;
    @NotNull
    private final Gaps scaledGaps;
    @NotNull
    private Gaps scaledVisualPaddings;

    public LayoutCellData(@NotNull Cell cell, @NotNull Dimension minimumSize, @NotNull Dimension preferredSize, @NotNull UnscaledGapsX unscaledColumnGaps, @NotNull UnscaledGapsY unscaledRowGaps) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)minimumSize, (String)"minimumSize");
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)unscaledColumnGaps, (String)"unscaledColumnGaps");
        Intrinsics.checkNotNullParameter((Object)unscaledRowGaps, (String)"unscaledRowGaps");
        this.cell = cell;
        this.minimumSize = minimumSize;
        this.preferredSize = preferredSize;
        this.unscaledColumnGaps = unscaledColumnGaps;
        this.unscaledRowGaps = unscaledRowGaps;
        this.scaledGaps = GridImplKt.access$scale(this.cell.getConstraints().getGaps());
        this.scaledVisualPaddings = GridImplKt.access$scale(this.cell.getConstraints().getVisualPaddings());
    }

    @NotNull
    public final Cell getCell() {
        return this.cell;
    }

    @NotNull
    public final Dimension getMinimumSize() {
        return this.minimumSize;
    }

    @NotNull
    public final Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @NotNull
    public final UnscaledGapsX getUnscaledColumnGaps() {
        return this.unscaledColumnGaps;
    }

    @NotNull
    public final UnscaledGapsY getUnscaledRowGaps() {
        return this.unscaledRowGaps;
    }

    @Nullable
    public final Integer getBaseline() {
        return this.baseline;
    }

    public final void setBaseline(@Nullable Integer n) {
        this.baseline = n;
    }

    public final int getGapWidth() {
        return this.scaledGaps.getWidth() + JBUIScale.scale((int)this.unscaledColumnGaps.getLeft()) + JBUIScale.scale((int)this.unscaledColumnGaps.getRight());
    }

    public final int getGapHeight() {
        return this.scaledGaps.getHeight() + JBUIScale.scale((int)this.unscaledRowGaps.getTop()) + JBUIScale.scale((int)this.unscaledRowGaps.getBottom());
    }

    public final int getCellPaddedMinimumWidth() {
        return this.minimumSize.width + this.getGapWidth() - this.scaledVisualPaddings.getWidth();
    }

    public final int getCellPaddedPreferredWidth() {
        return this.preferredSize.width + this.getGapWidth() - this.scaledVisualPaddings.getWidth();
    }

    @NotNull
    public final Gaps getScaledGaps() {
        return this.scaledGaps;
    }

    @NotNull
    public final Gaps getScaledVisualPaddings() {
        return this.scaledVisualPaddings;
    }

    public final void setScaledVisualPaddings(@NotNull Gaps gaps) {
        Intrinsics.checkNotNullParameter((Object)gaps, (String)"<set-?>");
        this.scaledVisualPaddings = gaps;
    }

    @NotNull
    public final Cell component1() {
        return this.cell;
    }

    @NotNull
    public final Dimension component2() {
        return this.minimumSize;
    }

    @NotNull
    public final Dimension component3() {
        return this.preferredSize;
    }

    @NotNull
    public final UnscaledGapsX component4() {
        return this.unscaledColumnGaps;
    }

    @NotNull
    public final UnscaledGapsY component5() {
        return this.unscaledRowGaps;
    }

    @NotNull
    public final LayoutCellData copy(@NotNull Cell cell, @NotNull Dimension minimumSize, @NotNull Dimension preferredSize, @NotNull UnscaledGapsX unscaledColumnGaps, @NotNull UnscaledGapsY unscaledRowGaps) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)minimumSize, (String)"minimumSize");
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)unscaledColumnGaps, (String)"unscaledColumnGaps");
        Intrinsics.checkNotNullParameter((Object)unscaledRowGaps, (String)"unscaledRowGaps");
        return new LayoutCellData(cell, minimumSize, preferredSize, unscaledColumnGaps, unscaledRowGaps);
    }

    public static /* synthetic */ LayoutCellData copy$default(LayoutCellData layoutCellData, Cell cell, Dimension dimension, Dimension dimension2, UnscaledGapsX unscaledGapsX, UnscaledGapsY unscaledGapsY, int n, Object object) {
        if ((n & 1) != 0) {
            cell = layoutCellData.cell;
        }
        if ((n & 2) != 0) {
            dimension = layoutCellData.minimumSize;
        }
        if ((n & 4) != 0) {
            dimension2 = layoutCellData.preferredSize;
        }
        if ((n & 8) != 0) {
            unscaledGapsX = layoutCellData.unscaledColumnGaps;
        }
        if ((n & 0x10) != 0) {
            unscaledGapsY = layoutCellData.unscaledRowGaps;
        }
        return layoutCellData.copy(cell, dimension, dimension2, unscaledGapsX, unscaledGapsY);
    }

    @NotNull
    public String toString() {
        return "LayoutCellData(cell=" + this.cell + ", minimumSize=" + this.minimumSize + ", preferredSize=" + this.preferredSize + ", unscaledColumnGaps=" + this.unscaledColumnGaps + ", unscaledRowGaps=" + this.unscaledRowGaps + ")";
    }

    public int hashCode() {
        int result2 = this.cell.hashCode();
        result2 = result2 * 31 + this.minimumSize.hashCode();
        result2 = result2 * 31 + this.preferredSize.hashCode();
        result2 = result2 * 31 + this.unscaledColumnGaps.hashCode();
        result2 = result2 * 31 + this.unscaledRowGaps.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayoutCellData)) {
            return false;
        }
        LayoutCellData layoutCellData = (LayoutCellData)other;
        if (!Intrinsics.areEqual((Object)this.cell, (Object)layoutCellData.cell)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.minimumSize, (Object)layoutCellData.minimumSize)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.preferredSize, (Object)layoutCellData.preferredSize)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.unscaledColumnGaps, (Object)layoutCellData.unscaledColumnGaps)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.unscaledRowGaps, (Object)layoutCellData.unscaledRowGaps);
    }
}

