/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.multiRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.multiRow.CompressibleTabsRow;
import com.intellij.ui.tabs.impl.multiRow.MultiRowLayout;
import com.intellij.ui.tabs.impl.multiRow.MultiRowPassInfo;
import com.intellij.ui.tabs.impl.multiRow.SimpleTabsRow;
import com.intellij.ui.tabs.impl.multiRow.TabsRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJO\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t2!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u001a\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/WrapMultiRowLayout;", "Lcom/intellij/ui/tabs/impl/multiRow/MultiRowLayout;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "showPinnedTabsSeparately", "", "<init>", "(Lcom/intellij/ui/tabs/impl/JBTabsImpl;Z)V", "splitToRows", "", "Lcom/intellij/ui/tabs/impl/multiRow/TabsRow;", "data", "Lcom/intellij/ui/tabs/impl/multiRow/MultiRowPassInfo;", "splitToRows$intellij_platform_ide", "doSplitToRows", "", "rows", "", "infosToSplit", "Lcom/intellij/ui/tabs/TabInfo;", "getRowMaxLen", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "index", "createRow", "infos", "isFirst", "intellij.platform.ide"})
@ApiStatus.Internal
public final class WrapMultiRowLayout
extends MultiRowLayout {
    public WrapMultiRowLayout(@NotNull JBTabsImpl tabs, boolean showPinnedTabsSeparately) {
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        super(tabs, showPinnedTabsSeparately, null);
    }

    @Override
    @NotNull
    public List<TabsRow> splitToRows$intellij_platform_ide(@NotNull MultiRowPassInfo data) {
        int n;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int leftmostX = data.toFitRec.x + this.getTabs().getTitleWrapper().getPreferredSize().width;
        Object object = this.getTabs().entryPointToolbar;
        if (object != null && (object = object.getComponent()) != null) {
            Object toolbar = object;
            boolean bl = false;
            n = this.getTabs().getActionsInsets().left + ((JComponent)toolbar).getPreferredSize().width + this.getTabs().getActionsInsets().right;
        } else {
            n = 0;
        }
        int entryToolbarWidth = n;
        int rightmostX = data.toFitRec.x + data.toFitRec.width - entryToolbarWidth;
        int firstRowWidth = rightmostX - leftmostX;
        Function1 getRowMaxLen = arg_0 -> WrapMultiRowLayout.splitToRows$lambda$1(firstRowWidth, data, arg_0);
        List infos = data.visibleInfos;
        List rows = new ArrayList();
        if (this.getShowPinnedTabsSeparately()) {
            Intrinsics.checkNotNull((Object)infos);
            Pair<List<TabInfo>, List<TabInfo>> pair = this.splitToPinnedUnpinned(infos);
            List pinned = (List)pair.component1();
            List unpinned = (List)pair.component2();
            if (!((Collection)pinned).isEmpty()) {
                rows.add(new CompressibleTabsRow(pinned, this.getTabs().getTitleWrapper().getPreferredSize().width > 0, this.getTabs().getEntryPointPreferredSize().width > 0));
            }
            this.doSplitToRows(data, rows, unpinned, (Function1<? super Integer, Integer>)getRowMaxLen);
        } else {
            Intrinsics.checkNotNull((Object)infos);
            this.doSplitToRows(data, rows, infos, (Function1<? super Integer, Integer>)getRowMaxLen);
        }
        return rows;
    }

    private final void doSplitToRows(MultiRowPassInfo data, List<TabsRow> rows, List<TabInfo> infosToSplit, Function1<? super Integer, Integer> getRowMaxLen) {
        List curRowInfos = new ArrayList();
        int curLen = 0;
        for (TabInfo info : infosToSplit) {
            TabLabel tabLabel = this.getTabs().getTabLabel(info);
            Intrinsics.checkNotNull((Object)tabLabel);
            int len = tabLabel.getPreferredSize().width;
            data.getLengths().put(info, len);
            if (curLen + len <= ((Number)getRowMaxLen.invoke((Object)rows.size())).intValue()) {
                curRowInfos.add(info);
            } else {
                rows.add(this.createRow(curRowInfos, rows.size() == 0));
                Object[] objectArray = new TabInfo[]{info};
                curRowInfos = CollectionsKt.mutableListOf((Object[])objectArray);
                curLen = 0;
            }
            curLen += len + this.getTabs().getTabHGap();
        }
        if (!((Collection)curRowInfos).isEmpty()) {
            rows.add(this.createRow(curRowInfos, rows.size() == 0));
        }
    }

    private final TabsRow createRow(List<TabInfo> infos, boolean isFirst) {
        return new SimpleTabsRow(infos, isFirst && this.getTabs().getTitleWrapper().getPreferredSize().width > 0, isFirst && this.getTabs().getEntryPointPreferredSize().width > 0);
    }

    private static final int splitToRows$lambda$1(int $firstRowWidth, MultiRowPassInfo $data, int index) {
        return index == 0 ? $firstRowWidth : $data.toFitRec.width;
    }
}

