/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilerPaths {
    private static final Logger LOG = Logger.getInstance(CompilerPaths.class);

    @NotNull
    public static File getGeneratedDataDirectory(@NotNull Project project) {
        if (project == null) {
            CompilerPaths.$$$reportNull$$$0(0);
        }
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".generated");
    }

    @NotNull
    public static File getCacheStoreDirectory(@NotNull Project project) {
        if (project == null) {
            CompilerPaths.$$$reportNull$$$0(1);
        }
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".caches");
    }

    @NotNull
    public static File getCompilerSystemDirectory(@NotNull Project project) {
        if (project == null) {
            CompilerPaths.$$$reportNull$$$0(2);
        }
        File file = ProjectUtil.getProjectCachePath((Project)project, (String)"compiler").toFile();
        if (file == null) {
            CompilerPaths.$$$reportNull$$$0(3);
        }
        return file;
    }

    @Nullable
    public static VirtualFile getModuleOutputDirectory(@NotNull Module module, boolean forTestClasses) {
        VirtualFile path;
        CompilerModuleExtension compilerModuleExtension;
        if (module == null) {
            CompilerPaths.$$$reportNull$$$0(4);
        }
        if ((compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module)) == null) {
            return null;
        }
        VirtualFile outPath = forTestClasses ? ((path = compilerModuleExtension.getCompilerOutputPathForTests()) != null ? path : compilerModuleExtension.getCompilerOutputPath()) : compilerModuleExtension.getCompilerOutputPath();
        if (outPath == null) {
            return null;
        }
        if (!outPath.isValid()) {
            LOG.info("Requested output path for module " + module.getName() + " is not valid");
            return null;
        }
        return outPath;
    }

    @Nullable
    public static String getModuleOutputPath(@Nullable Module module, boolean forTestClasses) {
        String url;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        String outPathUrl = forTestClasses ? (application.isDispatchThread() ? ((url = extension.getCompilerOutputUrlForTests()) != null ? url : extension.getCompilerOutputUrl()) : (String)ReadAction.compute(() -> {
            String url = extension.getCompilerOutputUrlForTests();
            return url != null ? url : extension.getCompilerOutputUrl();
        })) : (application.isDispatchThread() ? extension.getCompilerOutputUrl() : (String)ReadAction.compute(() -> extension.getCompilerOutputUrl()));
        return outPathUrl != null ? VirtualFileManager.extractPath((String)outPathUrl) : null;
    }

    @Nullable
    public static String getAnnotationProcessorsGenerationPath(@NotNull Module module, boolean forTests) {
        if (module == null) {
            CompilerPaths.$$$reportNull$$$0(5);
        }
        AnnotationProcessingConfiguration config = CompilerConfiguration.getInstance(module.getProject()).getAnnotationProcessingConfiguration(module);
        String sourceDirName = config.getGeneratedSourcesDirectoryName(forTests);
        if (config.isOutputRelativeToContentRoot()) {
            Object[] roots = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            if (roots.length == 0) {
                return null;
            }
            if (roots.length > 1) {
                Arrays.sort(roots);
            }
            return StringUtil.isEmpty((String)sourceDirName) ? VirtualFileManager.extractPath((String)roots[0]) : VirtualFileManager.extractPath((String)roots[0]) + "/" + sourceDirName;
        }
        String path = CompilerPaths.getModuleOutputPath(module, forTests);
        if (path == null) {
            return null;
        }
        return StringUtil.isEmpty((String)sourceDirName) ? path : path + "/" + sourceDirName;
    }

    @NotNull
    public static @NotNull String @NotNull [] getOutputPaths(@NotNull @NotNull Module @NotNull [] modules) {
        if (modules == null) {
            CompilerPaths.$$$reportNull$$$0(6);
        }
        OrderedSet outputPaths = new OrderedSet();
        for (Module module : modules) {
            CompilerModuleExtension compilerModuleExtension;
            CompilerModuleExtension compilerModuleExtension2 = compilerModuleExtension = !module.isDisposed() ? CompilerModuleExtension.getInstance((Module)module) : null;
            if (compilerModuleExtension == null) continue;
            for (String outputRootUrl : compilerModuleExtension.getOutputRootUrls(true)) {
                outputPaths.add(VirtualFileManager.extractPath((String)outputRootUrl).replace('/', File.separatorChar));
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEnumerationHandler.Factory handlerFactory : OrderEnumerationHandler.EP_NAME.getExtensionList()) {
                if (!handlerFactory.isApplicable(module)) continue;
                OrderEnumerationHandler handler = handlerFactory.createHandler(module);
                SmartList outputUrls = new SmartList();
                handler.addCustomModuleRoots(OrderRootType.CLASSES, (ModuleRootModel)moduleRootManager, (Collection)outputUrls, true, true);
                for (String outputUrl : outputUrls) {
                    outputPaths.add(VirtualFileManager.extractPath((String)outputUrl).replace('/', File.separatorChar));
                }
            }
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)outputPaths);
        if (stringArray == null) {
            CompilerPaths.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/CompilerPaths";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/CompilerPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerSystemDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedDataDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCacheStoreDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerSystemDirectory";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleOutputDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationProcessorsGenerationPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOutputPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

