/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmBackendErrors;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.overrides.IrVisibilityUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J*\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J:\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/PrivateTypeFromNonPrivateInlineUsageChecker;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "result", "", "Lorg/jetbrains/kotlin/name/ClassId;", "findPrivateClassUsages", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "visitLdcInsn", "", "value", "", "visitTypeInsn", "opcode", "", "type", "", "visitMethodInsn", "owner", "name", "descriptor", "isInterface", "", "visitFieldInsn", "visitTryCatchBlock", "start", "Lorg/jetbrains/org/objectweb/asm/Label;", "end", "handler", "visitLocalVariable", "signature", "index", "checkType", "Lorg/jetbrains/org/objectweb/asm/Type;", "Companion", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nPrivateTypeFromNonPrivateInlineUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivateTypeFromNonPrivateInlineUsageChecker.kt\norg/jetbrains/kotlin/backend/jvm/codegen/PrivateTypeFromNonPrivateInlineUsageChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class PrivateTypeFromNonPrivateInlineUsageChecker
extends MethodVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Set<ClassId> result;

    public PrivateTypeFromNonPrivateInlineUsageChecker(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(589824);
        this.context = context;
        this.result = new LinkedHashSet();
    }

    private final Collection<ClassId> findPrivateClassUsages(MethodNode node) {
        Set<ClassId> set;
        Set<ClassId> it = set = this.result;
        boolean bl = false;
        node.accept((MethodVisitor)this);
        return set;
    }

    public void visitLdcInsn(@Nullable Object value) {
        if (value instanceof Type) {
            this.checkType((Type)value);
        }
    }

    public void visitTypeInsn(int opcode, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Type type2 = Type.getObjectType((String)type);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getObjectType(...)");
        this.checkType(type2);
    }

    public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Type type = Type.getObjectType((String)owner);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getObjectType(...)");
        this.checkType(type);
        Type type2 = Type.getReturnType((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getReturnType(...)");
        this.checkType(type2);
        Type[] typeArray = Type.getArgumentTypes((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getArgumentTypes(...)");
        for (Type type3 : typeArray) {
            Intrinsics.checkNotNull((Object)type3);
            this.checkType(type3);
        }
    }

    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Type type = Type.getObjectType((String)owner);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getObjectType(...)");
        this.checkType(type);
        Type type2 = Type.getType((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        this.checkType(type2);
    }

    public void visitTryCatchBlock(@NotNull Label start, @NotNull Label end, @NotNull Label handler2, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        if (type != null) {
            Type type2 = Type.getObjectType((String)type);
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getObjectType(...)");
            this.checkType(type2);
        }
    }

    public void visitLocalVariable(@NotNull String name, @NotNull String descriptor, @Nullable String signature, @NotNull Label start, @NotNull Label end, int index) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Type type = Type.getType((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
        this.checkType(type);
    }

    private final void checkType(Type type) {
        for (ClassDescriptor classDescriptor : this.context.getState().getJvmBackendClassResolver().resolveToClassDescriptors(type)) {
            if (!DescriptorVisibilities.isPrivate(classDescriptor.getVisibility())) continue;
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor);
            if (classId == null) {
                classId = new ClassId(FqName.ROOT, SpecialNames.NO_NAME_PROVIDED);
            }
            this.result.add(classId);
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/PrivateTypeFromNonPrivateInlineUsageChecker$Companion;", "", "<init>", "()V", "check", "", "caller", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "callee", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend.jvm.codegen"})
    public static final class Companion {
        private Companion() {
        }

        public final void check(@NotNull IrFunction caller, @NotNull IrExpression call, @NotNull IrFunction callee, @NotNull MethodNode node, @NotNull JvmBackendContext context) {
            Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (caller.isInline() && !IrVisibilityUtilKt.isEffectivelyPrivate((IrDeclarationWithVisibility)((IrDeclarationWithVisibility)caller)) && IrVisibilityUtilKt.isEffectivelyPrivate((IrDeclarationWithVisibility)((IrDeclarationWithVisibility)callee))) {
                Collection privateClassIds = new PrivateTypeFromNonPrivateInlineUsageChecker(context).findPrivateClassUsages(node);
                for (ClassId classId : privateClassIds) {
                    context.getKtDiagnosticReporter().at((IrElement)call, JvmIrUtilsKt.getFileParent((IrDeclaration)caller)).report(JvmBackendErrors.INSTANCE.getPRIVATE_TYPE_USED_IN_NON_PRIVATE_INLINE_FUNCTION(), (Object)classId);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

