/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhasePrerequisites;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.PropertyReferenceDelegationLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhasePrerequisites(value={PropertyReferenceDelegationLowering.class, JvmLocalDeclarationsLowering.class})
@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00ca\u0001\u0016\b\u0018\u0012\u0012\b\u0019\u0012\u000e\b\fJ\u0004\b\t0\u001aJ\u0004\b\t0\u001b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/MakePropertyDelegateMethodsStaticLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isSyntheticDelegateMethod", "", "backend.jvm.lower", "Lorg/jetbrains/kotlin/backend/common/phaser/PhasePrerequisites;", "value", "Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceDelegationLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLocalDeclarationsLowering;"})
public final class MakePropertyDelegateMethodsStaticLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public MakePropertyDelegateMethodsStaticLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transform((IrTransformer)this, null);
    }

    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (!this.isSyntheticDelegateMethod(declaration)) break block1;
            IrValueParameter irValueParameter = declaration.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                irValueParameter.setKind(IrParameterKind.Regular);
            }
        }
        return super.visitSimpleFunction(declaration);
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isSyntheticDelegateMethod((IrSimpleFunction)expression2.getSymbol().getOwner())) {
            throw new IllegalStateException(("`$delegate` method should not be called. Please either remove the call, or support remapping of dispatch receiver in MakePropertyDelegateMethodsStaticLowering: " + RenderIrElementKt.render$default((IrElement)((IrElement)expression2.getSymbol().getOwner()), null, (int)1, null)).toString());
        }
        return super.visitCall(expression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSyntheticDelegateMethod(IrSimpleFunction $this$isSyntheticDelegateMethod) {
        if (!Intrinsics.areEqual((Object)$this$isSyntheticDelegateMethod.getOrigin(), (Object)IrDeclarationOrigin.Companion.getPROPERTY_DELEGATE())) return false;
        String string = $this$isSyntheticDelegateMethod.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"$delegate", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

