/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhasePrerequisites;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.ExportUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.PrepareCollectionsToExportLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.PrepareCollectionsToExportLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.PrepareExportedDefaultImplementationsLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.transformers.ConvertMemberToStaticKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrPropertySymbolImpl;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@PhasePrerequisites(value={PrepareCollectionsToExportLowering.class})
@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\rH\u0002J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00ca\u0001\u0010\b\u0017\u0012\f\b\u0018\u0012\b\b\fJ\u0004\b\t0\u0019\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PrepareExportedDefaultImplementationsLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "allowImplementingInterfaces", "", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "shouldExtractAsExportedDefaultImplementation", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "createCorrespondingStaticImplementationAndModifyCurrent", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "copyAsExportedDefaultImplementationProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "backend.js", "Lorg/jetbrains/kotlin/backend/common/phaser/PhasePrerequisites;", "value", "Lorg/jetbrains/kotlin/ir/backend/js/lower/PrepareCollectionsToExportLowering;"})
@SourceDebugExtension(value={"SMAP\nPrepareExportedDefaultImplementationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrepareExportedDefaultImplementationsLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PrepareExportedDefaultImplementationsLowering\n+ 2 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n34#2:128\n245#3:129\n245#3:130\n1#4:131\n98#5:132\n247#6,5:133\n76#7:138\n77#7:145\n1924#8,3:139\n1924#8,3:142\n*S KotlinDebug\n*F\n+ 1 PrepareExportedDefaultImplementationsLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PrepareExportedDefaultImplementationsLowering\n*L\n54#1:128\n60#1:129\n65#1:130\n88#1:132\n88#1:133,5\n88#1:138\n88#1:145\n91#1:139,3\n94#1:142,3\n*E\n"})
public final class PrepareExportedDefaultImplementationsLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean allowImplementingInterfaces;

    public PrepareExportedDefaultImplementationsLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.allowImplementingInterfaces = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)this.context.getConfiguration()).supportsFeature(LanguageFeature.JsExportInterfacesInImplementableWay);
    }

    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        if (!this.allowImplementingInterfaces) {
            return;
        }
        super.lower(irModule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldExtractAsExportedDefaultImplementation(IrOverridableDeclaration<?> $this$shouldExtractAsExportedDefaultImplementation) {
        if (Intrinsics.areEqual((Object)$this$shouldExtractAsExportedDefaultImplementation.getOrigin(), (Object)PrepareCollectionsToExportLoweringKt.getCONVERTERS_TO_JS_COLLECTIONS())) return false;
        if ($this$shouldExtractAsExportedDefaultImplementation.getModality() == Modality.ABSTRACT) return false;
        if (!IrFakeOverrideUtilsKt.isReal((IrDeclaration)((IrDeclaration)$this$shouldExtractAsExportedDefaultImplementation))) return false;
        if (!ExportUtilsKt.isExported((IrDeclaration)$this$shouldExtractAsExportedDefaultImplementation, this.context)) return false;
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)$this$shouldExtractAsExportedDefaultImplementation));
        IrClass irClass2 = irClass;
        if (irClass == null) return false;
        ClassKind classKind = irClass2.getKind();
        irClass2 = classKind;
        if (classKind == null) return false;
        IrClass $this$isInterface$iv = irClass2;
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv != ClassKind.INTERFACE) return false;
        boolean bl = true;
        if (!bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (!($this$shouldExtractAsExportedDefaultImplementation instanceof IrSimpleFunction)) return true;
        if (((IrSimpleFunction)$this$shouldExtractAsExportedDefaultImplementation).getDispatchReceiverParameter() == null) return false;
        if (((IrSimpleFunction)$this$shouldExtractAsExportedDefaultImplementation).getCorrespondingPropertySymbol() != null) return false;
        return true;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        List list;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrDeclaration irDeclaration = declaration;
        if (irDeclaration instanceof IrSimpleFunction) {
            boolean condition$iv = this.shouldExtractAsExportedDefaultImplementation((IrOverridableDeclaration)declaration);
            boolean $i$f$runIf = false;
            if (condition$iv) {
                boolean bl = false;
                Object[] objectArray = new IrSimpleFunction[]{declaration, this.createCorrespondingStaticImplementationAndModifyCurrent((IrSimpleFunction)declaration)};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = null;
            }
        } else if (irDeclaration instanceof IrProperty) {
            boolean condition$iv = this.shouldExtractAsExportedDefaultImplementation((IrOverridableDeclaration)declaration);
            boolean $i$f$runIf = false;
            if (condition$iv) {
                IrSimpleFunction irSimpleFunction;
                IrSimpleFunction irSimpleFunction2;
                IrSimpleFunction it;
                IrProperty irProperty;
                IrSimpleFunction irSimpleFunction3;
                IrSimpleFunction irSimpleFunction4;
                IrProperty correspondingDefaultImplementationProperty;
                boolean bl = false;
                IrProperty irProperty2 = correspondingDefaultImplementationProperty = this.copyAsExportedDefaultImplementationProperty((IrProperty)declaration);
                Object[] objectArray = ((IrProperty)declaration).getGetter();
                if (objectArray != null && (irSimpleFunction4 = this.createCorrespondingStaticImplementationAndModifyCurrent((IrSimpleFunction)objectArray)) != null) {
                    IrSimpleFunction irSimpleFunction5 = irSimpleFunction3 = irSimpleFunction4;
                    irProperty = irProperty2;
                    boolean bl2 = false;
                    it.setCorrespondingPropertySymbol(correspondingDefaultImplementationProperty.getSymbol());
                    irProperty2 = irProperty;
                    irSimpleFunction2 = irSimpleFunction3;
                } else {
                    irSimpleFunction2 = null;
                }
                irProperty2.setGetter(irSimpleFunction2);
                IrProperty irProperty3 = correspondingDefaultImplementationProperty;
                objectArray = ((IrProperty)declaration).getSetter();
                if (objectArray != null && (irSimpleFunction4 = this.createCorrespondingStaticImplementationAndModifyCurrent((IrSimpleFunction)objectArray)) != null) {
                    it = irSimpleFunction3 = irSimpleFunction4;
                    irProperty = irProperty3;
                    boolean bl3 = false;
                    it.setCorrespondingPropertySymbol(correspondingDefaultImplementationProperty.getSymbol());
                    irProperty3 = irProperty;
                    irSimpleFunction = irSimpleFunction3;
                } else {
                    irSimpleFunction = null;
                }
                irProperty3.setSetter(irSimpleFunction);
                objectArray = new IrProperty[]{declaration, correspondingDefaultImplementationProperty};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = null;
            }
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createCorrespondingStaticImplementationAndModifyCurrent(IrSimpleFunction $this$createCorrespondingStaticImplementationAndModifyCurrent) {
        IrTypeParameter irValueParameter;
        void $this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240_u240_u240_u240;
        int index;
        int n;
        void $this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240_u240_u240;
        IrCall irCall;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        IrSimpleFunction irSimpleFunction;
        JsIrBackendContext $this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240 = this.context;
        boolean bl = false;
        IrSimpleFunction it = irSimpleFunction = ConvertMemberToStaticKt.transformMemberToStaticFunction($this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240, $this$createCorrespondingStaticImplementationAndModifyCurrent, PrepareExportedDefaultImplementationsLoweringKt.getEXPORTED_DEFAULT_IMPLEMENTATIONS());
        boolean bl2 = false;
        IrGeneratorWithScope irGeneratorWithScope = (IrGeneratorWithScope)LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.context), (IrSymbol)((IrSymbol)$this$createCorrespondingStaticImplementationAndModifyCurrent.getSymbol()), (int)0, (int)0, (int)6, null);
        IrElement irElement$iv = (IrElement)$this$createCorrespondingStaticImplementationAndModifyCurrent;
        boolean $i$f$irBlockBody = false;
        void var10_10 = $this$irBlockBody$iv;
        int n2 = irElement$iv.getStartOffset();
        int endOffset$iv$iv = irElement$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void var16_16 = this_$iv$iv$iv;
        IrSimpleFunction irSimpleFunction2 = $this$createCorrespondingStaticImplementationAndModifyCurrent;
        boolean bl3 = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240_u240_u240), (IrSimpleFunctionSymbol)it.getSymbol());
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240_u240_u240;
        void var22_22 = $this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240_u240_u240;
        boolean bl4 = false;
        Iterable $this$forEachIndexed$iv = $this$createCorrespondingStaticImplementationAndModifyCurrent.getParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv;
            index = n;
            boolean bl5 = false;
            $this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240_u240_u240_u240.getArguments().set(index, (Object)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240_u240_u240), (IrValueDeclaration)((IrValueDeclaration)irValueParameter)));
        }
        $this$forEachIndexed$iv = CollectionsKt.plus((Collection)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$createCorrespondingStaticImplementationAndModifyCurrent)).getTypeParameters(), (Iterable)$this$createCorrespondingStaticImplementationAndModifyCurrent.getTypeParameters());
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void irTypeParameter;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            irValueParameter = (IrTypeParameter)item$iv;
            index = n;
            boolean bl6 = false;
            $this$createCorrespondingStaticImplementationAndModifyCurrent_u24lambda_u240_u240_u240_u240.getTypeArguments().set(index, IrTypesKt.getDefaultType((IrTypeParameter)irTypeParameter));
        }
        Unit unit = Unit.INSTANCE;
        var22_22.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irCall)));
        irSimpleFunction2.setBody((IrBody)this_$iv$iv$iv.doBuild());
        return irSimpleFunction;
    }

    private final IrProperty copyAsExportedDefaultImplementationProperty(IrProperty $this$copyAsExportedDefaultImplementationProperty) {
        IrProperty irProperty;
        IrProperty originalProperty = $this$copyAsExportedDefaultImplementationProperty;
        IrProperty $this$copyAsExportedDefaultImplementationProperty_u24lambda_u240 = irProperty = this.context.getIrFactory().createProperty(originalProperty.getStartOffset(), originalProperty.getEndOffset(), PrepareExportedDefaultImplementationsLoweringKt.getEXPORTED_DEFAULT_IMPLEMENTATIONS(), originalProperty.getName(), originalProperty.getVisibility(), Modality.FINAL, (IrPropertySymbol)new IrPropertySymbolImpl(null, null, 3, null), originalProperty.isVar(), originalProperty.isConst(), originalProperty.isLateinit(), originalProperty.isDelegated(), originalProperty.isExternal(), originalProperty.getContainerSource(), originalProperty.isExpect(), originalProperty.isFakeOverride());
        boolean bl = false;
        IrDeclarationsKt.copyAttributes$default((IrElement)((IrElement)$this$copyAsExportedDefaultImplementationProperty_u24lambda_u240), (IrElement)((IrElement)originalProperty), (boolean)false, (int)2, null);
        $this$copyAsExportedDefaultImplementationProperty_u24lambda_u240.setAnnotations(originalProperty.getAnnotations());
        $this$copyAsExportedDefaultImplementationProperty_u24lambda_u240.setParent(originalProperty.getParent());
        return irProperty;
    }
}

