/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.database.datagrid.nested.NestedTablesAware;
import com.intellij.database.run.ui.table.LocalFilterState;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/run/ui/table/FilterStateControllerForNestedTables;", "Lcom/intellij/database/datagrid/nested/NestedTablesAware;", "Lcom/intellij/database/run/ui/table/LocalFilterState;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "activeFilterState", "getActiveFilterState", "()Lcom/intellij/database/run/ui/table/LocalFilterState;", "filterStateStack", "Lcom/intellij/database/datagrid/nested/NestedTablesAware$NonEmptyStack;", "enterNestedTable", "coordinate", "Lcom/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate;", "nestedTable", "Lcom/intellij/database/datagrid/NestedTable;", "(Lcom/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate;Lcom/intellij/database/datagrid/NestedTable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "exitNestedTable", "steps", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.grid.impl"})
public final class FilterStateControllerForNestedTables
implements NestedTablesAware<LocalFilterState> {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final NestedTablesAware.NonEmptyStack<LocalFilterState> filterStateStack;

    public FilterStateControllerForNestedTables(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        this.filterStateStack = new NestedTablesAware.NonEmptyStack((Object)new LocalFilterState(this.grid, false, 2, null));
    }

    @NotNull
    public final LocalFilterState getActiveFilterState() {
        return (LocalFilterState)this.filterStateStack.last();
    }

    @Nullable
    public Object enterNestedTable(@NotNull NestedTablesDataGridModel.NestedTableCellCoordinate coordinate, @NotNull NestedTable nestedTable, @NotNull Continuation<? super LocalFilterState> $completion) {
        this.filterStateStack.push((Object)new LocalFilterState(this.grid, this.getActiveFilterState().isEnabled()));
        this.grid.getResultView().onLocalFilterStateChanged();
        return this.filterStateStack.last();
    }

    @Nullable
    public Object exitNestedTable(int steps, @NotNull Continuation<? super LocalFilterState> $completion) {
        this.filterStateStack.pop(steps);
        this.grid.getResultView().onLocalFilterStateChanged();
        return this.filterStateStack.last();
    }
}

