/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.BaseExtractorConfig;
import com.intellij.database.extractors.BaseExtractorsHelper;
import com.intellij.database.extractors.BaseObjectFormatter;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.extractors.FormatExtractorFactory;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.XlsxExtractorFactory;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.text.TextResultView;
import com.intellij.database.util.Out;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.LabeledComponentNoThrow;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpDataForm {
    private static final List<DataConsumer.Column> PREVIEW_COLUMNS = Arrays.asList(new DataConsumer.Column(0, "id", 4, "int", "java.lang.Integer"), new DataConsumer.Column(1, "first_name", 12, "varchar", "java.lang.String"), new DataConsumer.Column(2, "last_name", 12, "varchar", "java.lang.String"), new DataConsumer.Column(3, "birth", 12, "varchar", "java.lang.String"));
    private static final List<DataConsumer.Row> PREVIEW_ROWS = Arrays.asList(DataConsumer.Row.create((int)0, (Object[])new Object[]{10001, "Georgi", "Facello", "M", "1953-09-02"}), DataConsumer.Row.create((int)1, (Object[])new Object[]{10002, "Bezalel", "Simmel", "F", "1964-06-02"}), DataConsumer.Row.create((int)2, (Object[])new Object[]{10003, "Parto", "Bamford", "M", "1959-12-03"}), DataConsumer.Row.create((int)3, (Object[])new Object[]{10004, "Chirstian", "Koblick", "M", "1954-05-01"}), DataConsumer.Row.create((int)4, (Object[])new Object[]{10005, "Kyoichi", "Maliniak", "M", "1955-01-21"}), DataConsumer.Row.create((int)5, (Object[])new Object[]{10006, "Anneke", "Preusig", "F", "1953-04-20"}), DataConsumer.Row.create((int)6, (Object[])new Object[]{10007, "Tzvetan", "Zielinski", "F", "1957-05-23"}), DataConsumer.Row.create((int)7, (Object[])new Object[]{10008, "Saniya", "Kalloufi", "M", "1958-02-19"}), DataConsumer.Row.create((int)8, (Object[])new Object[]{10009, "Sumant", "Peac", "F", "1952-04-19"}), DataConsumer.Row.create((int)9, (Object[])new Object[]{10010, "Duangkaew", "Piveteau", "F", "1963-06-01"}));
    private static final int MAX_ROWS_FOR_PREVIEW = 10;
    private static final int MAX_SOURCE_HEIGHT = 100;
    private static final Logger LOG = Logger.getInstance(DumpDataForm.class);
    private static final Set<String> EXTRACTORS_NO_TRANSPOSE = Set.of("SQL-Insert-Statements.sql.groovy", "JSON-Groovy.json.groovy", "Python-DataFrame.py.groovy");
    private final Project myProject;
    private final DumpSource<?> mySource;
    @NotNull
    private final Supplier<? extends Window> myWindowSupplier;
    private final boolean mySupportsAddQuery;
    private final EditorEx myViewer;
    private final JBPanelWithEmptyText emptyTextPanel;
    public JPanel myPanel;
    private JBCheckBox myAddComputed;
    private JBCheckBox myAddGenerated;
    private JBCheckBox myAddTableDefinition;
    private LabeledComponent<JComponent> myPreviewLabeledComponent;
    private JBCheckBox myTranspose;
    private JBLabel myAddColumnsLabel;
    private LabeledComponentNoThrow<TextFieldWithBrowseButton> myOutputFileOrDirectory;
    private final OutputPathManager myOutputPathManager;
    private LabeledComponentNoThrow<ComboBox<DataExtractorFactory>> myExtractorCombobox;
    private LabeledComponentNoThrow<JBScrollPane> mySourceLabeledComponent;
    private JBCheckBox myAddColumnHeader;
    private JBCheckBox myAddRowHeader;
    private JBCheckBox myAddQuery;
    protected Disposable myDisposable;

    public DumpDataForm(@NotNull Project project, @NotNull DumpSource<?> source, @NotNull Supplier<? extends Window> windowSupplier, @Nullable CsvFormatsSettings csvFormatsSettings, @NotNull Disposable disposable, boolean supportsAddQuery) {
        if (project == null) {
            DumpDataForm.$$$reportNull$$$0(0);
        }
        if (source == null) {
            DumpDataForm.$$$reportNull$$$0(1);
        }
        if (windowSupplier == null) {
            DumpDataForm.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            DumpDataForm.$$$reportNull$$$0(3);
        }
        this.$$$setupUI$$$();
        this.emptyTextPanel = new JBPanelWithEmptyText().withEmptyText(DataGridBundle.message((String)"settings.database.DumpDialog.Preview.NoPreview", (Object[])new Object[0]));
        this.myProject = project;
        this.mySource = source;
        this.myWindowSupplier = windowSupplier;
        this.mySupportsAddQuery = supportsAddQuery;
        String sourceText = this.getSourceText(this.mySource);
        if (sourceText == null) {
            this.mySourceLabeledComponent.setVisible(false);
        } else {
            JEditorPane pane = new JEditorPane();
            pane.setMargin((Insets)JBUI.insets((int)5));
            pane.setEditable(false);
            pane.setText(sourceText);
            pane.setBackground(UIUtil.getPanelBackground());
            JBScrollPane scrollPane = (JBScrollPane)this.mySourceLabeledComponent.getComponent();
            scrollPane.setViewportView((Component)pane);
            if (scrollPane.getPreferredSize().height > 100) {
                scrollPane.setPreferredSize(new Dimension(-1, 100));
            }
        }
        ArrayList factories = new ArrayList();
        DataGrid grid = source instanceof DumpSource.DataGridSource ? ((DumpSource.DataGridSource)source).getGrid() : null;
        factories.addAll(DataExtractorFactories.getBuiltInFactories((CoreGrid)grid));
        factories.addAll(DataExtractorFactories.getCsvFormats((CsvFormatsSettings)csvFormatsSettings));
        List allScripts = DataExtractorFactories.getExtractorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)grid), GridUtil::suggestPlugin);
        List scripts = ContainerUtil.sorted((Collection)allScripts, Comparator.comparing(s -> StringUtil.toLowerCase((String)s.getName())));
        factories.addAll(scripts);
        String currentFactoryId = DataExtractorProperties.getCurrentExportExtractorFactory((Project)this.myProject, GridUtil::suggestPlugin, (CsvFormatsSettings)csvFormatsSettings).getId();
        ComboBox comboBox = (ComboBox)this.myExtractorCombobox.getComponent();
        comboBox.setSwingPopup(false);
        comboBox.setModel(new DefaultComboBoxModel<DataExtractorFactory>(factories.toArray(new DataExtractorFactory[0])));
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", f -> DataExtractorFactories.getDisplayName((DataExtractorFactory)f, (List)scripts)));
        DataExtractorFactory currentFactory = (DataExtractorFactory)ContainerUtil.find(factories, factory -> currentFactoryId.equals(factory.getId()));
        comboBox.setSelectedItem((Object)currentFactory);
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateCheckboxes();
                this.updateFileExtension();
            }
        });
        this.updateCheckboxes();
        this.myAddComputed.setSelected(!DataExtractorProperties.isSkipComputed());
        this.myAddComputed.addItemListener(e -> this.settingsChanged());
        this.myAddGenerated.setSelected(!DataExtractorProperties.isSkipGeneratedColumns());
        this.myAddGenerated.addItemListener(e -> this.settingsChanged());
        this.myAddTableDefinition.setSelected(DataExtractorProperties.isIncludeCreateTable());
        this.myAddTableDefinition.addItemListener(e -> this.settingsChanged());
        this.myTranspose.setSelected(this.mySource instanceof DumpSource.DataGridSource && ((DumpSource.DataGridSource)this.mySource).getGrid().getResultView().isTransposed());
        this.myTranspose.addItemListener(e -> this.settingsChanged());
        this.myAddColumnHeader.addItemListener(e -> this.settingsChanged());
        this.myAddRowHeader.addItemListener(e -> this.settingsChanged());
        this.myAddQuery.setSelected(DataExtractorProperties.isIncludeQuery());
        this.myAddQuery.addItemListener(e -> this.settingsChanged());
        this.myOutputPathManager = DumpSource.getSize(source) == 1 ? new OutputFilePathManager() : new OutputDirectoryPathManager();
        this.myOutputFileOrDirectory.setText(this.myOutputPathManager.getFieldName());
        final String defaultFileName = GridExtractorsUtilCore.prepareFileName((String)DumpDataForm.getName(this.mySource));
        ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).setText(this.getDefaultPath(defaultFileName, currentFactory));
        ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DumpDataForm.this.myOutputPathManager.focusGained((TextFieldWithBrowseButton)DumpDataForm.this.myOutputFileOrDirectory.getComponent());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        descriptor.setTitle(DataGridBundle.message((String)"settings.database.DumpDialog.FileChooser.Title", (Object[])new Object[0]));
        ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).addBrowseFolderListener(new TextBrowseFolderListener(descriptor, project){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                DataExtractorFactory factory;
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((factory = DumpDataForm.this.getFactory()) == null) {
                    String string = super.chosenFileToResultingText(chosenFile);
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = DumpDataForm.this.myOutputPathManager.adjustChosenFile(chosenFile.toNioPath(), defaultFileName, factory.getFileExtension()).toString();
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
        this.myViewer = TextResultView.createEditor(this.myProject, "dumpDataPreview");
        Disposer.register((Disposable)disposable, () -> EditorFactory.getInstance().releaseEditor((Editor)this.myViewer));
        this.myDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)disposable, (Disposable)this.myDisposable);
        JBLayeredPane myPane = new JBLayeredPane();
        myPane.add((Component)this.myViewer.getComponent(), (Object)JLayeredPane.DEFAULT_LAYER);
        myPane.setFullOverlayLayout(true);
        myPane.add((Component)this.emptyTextPanel, (Object)JLayeredPane.PALETTE_LAYER);
        this.myPreviewLabeledComponent.setComponent((JComponent)myPane);
        this.emptyTextPanel.setVisible(false);
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.settingsChanged();
            }
        });
    }

    @NotNull
    private String getDefaultPath(String defaultFileName, DataExtractorFactory currentFactory) {
        String string;
        try {
            Path path = Path.of(DataExtractorProperties.getOutputDir(), new String[0]);
            Path filePath = this.myOutputPathManager.getFilePath(path, defaultFileName, currentFactory.getFileExtension());
            string = filePath.toString();
        }
        catch (InvalidPathException e) {
            LOG.warn((Throwable)e);
            return "";
        }
        if (string == null) {
            DumpDataForm.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static <T> String getName(DumpSource<T> source) {
        JBIterable<T> sources = source.getSources();
        Object first = sources.first();
        String name = first == null ? null : source.getNameProvider().getName(first);
        String string = name == null ? "" : name;
        if (string == null) {
            DumpDataForm.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public OutputPathManager getOutputPathManager() {
        OutputPathManager outputPathManager = this.myOutputPathManager;
        if (outputPathManager == null) {
            DumpDataForm.$$$reportNull$$$0(6);
        }
        return outputPathManager;
    }

    @NlsSafe
    @Nullable
    protected String getSourceText(@Nullable DumpSource<?> source) {
        return null;
    }

    @NotNull
    public JTextField getOutputFileOrDirectoryField() {
        JTextField jTextField = ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).getTextField();
        if (jTextField == null) {
            DumpDataForm.$$$reportNull$$$0(7);
        }
        return jTextField;
    }

    @NotNull
    public ComboBox<DataExtractorFactory> getExtractorComboBox() {
        ComboBox comboBox = (ComboBox)this.myExtractorCombobox.getComponent();
        if (comboBox == null) {
            DumpDataForm.$$$reportNull$$$0(8);
        }
        return comboBox;
    }

    private void updateFileExtension() {
        DataExtractorFactory factory = this.getFactory();
        if (factory != null) {
            try {
                Path newPath = this.myOutputPathManager.updateFileExtension(this.getFilePath(), factory.getFileExtension());
                ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).setText(newPath.toString());
            }
            catch (InvalidPathException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @NotNull
    private Path getFilePath() {
        Path path = Path.of(((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).getText(), new String[0]);
        if (path == null) {
            DumpDataForm.$$$reportNull$$$0(9);
        }
        return path;
    }

    private void updateCheckboxes() {
        DataExtractorFactory factory = this.getFactory();
        if (factory == null) {
            return;
        }
        this.myTranspose.setVisible(this.supportsTranspose(factory));
        this.myAddTableDefinition.setVisible(this.supportsAddTableDefinition(factory));
        boolean supportsComputedOrGenerated = this.supportsAddComputedOrGeneratedColumns(factory);
        this.myAddColumnsLabel.setVisible(supportsComputedOrGenerated);
        this.myAddComputed.setVisible(supportsComputedOrGenerated);
        this.myAddGenerated.setVisible(supportsComputedOrGenerated);
        this.myAddColumnHeader.setVisible(factory instanceof FormatExtractorFactory);
        this.myAddRowHeader.setVisible(factory instanceof FormatExtractorFactory);
        this.myAddQuery.setVisible(this.mySupportsAddQuery && factory instanceof XlsxExtractorFactory);
        if (factory instanceof FormatExtractorFactory) {
            CsvFormat format = ((FormatExtractorFactory)factory).getFormat();
            this.myAddColumnHeader.setSelected(format.headerRecord != null);
            this.myAddRowHeader.setSelected(format.rowNumbers);
        }
    }

    @Nullable
    public DataExtractorFactory getFactory() {
        return (DataExtractorFactory)ObjectUtils.tryCast((Object)((ComboBox)this.myExtractorCombobox.getComponent()).getSelectedItem(), DataExtractorFactory.class);
    }

    protected boolean supportsAddComputedOrGeneratedColumns(DataExtractorFactory factory) {
        return false;
    }

    protected boolean supportsTranspose(DataExtractorFactory factory) {
        return !(factory instanceof BaseExtractorsHelper.Script) || !EXTRACTORS_NO_TRANSPOSE.contains(factory.getName());
    }

    protected boolean supportsAddTableDefinition(DataExtractorFactory factory) {
        return false;
    }

    private void settingsChanged() {
        this.saveState();
        ApplicationManager.getApplication().invokeLater(() -> this.updatePreview(), ModalityState.stateForComponent((Component)this.myWindowSupplier.get()));
    }

    public void updatePreview() {
        DataExtractor extractor;
        List columns;
        List rows;
        DataGrid grid;
        DataGrid dataGrid = grid = this.mySource instanceof DumpSource.DataGridSource ? ((DumpSource.DataGridSource)this.mySource).getGrid() : null;
        if (grid != null) {
            GridModel model2 = grid.getDataModel(DataAccessType.DATABASE_DATA);
            rows = model2.getRows(ModelIndexSet.forRows((CoreGrid)grid, (int[])IntStream.range(0, Math.min(10, model2.getRowCount())).toArray()));
            columns = model2.getAllColumnsForExtraction(new int[0]);
        } else {
            rows = this.getRows(this.mySource);
            columns = this.getColumns(this.mySource);
        }
        DataExtractorFactory extractorFactory = this.getFactory();
        DataExtractor dataExtractor = extractor = extractorFactory == null ? null : extractorFactory.createExtractor(this.createConfig(this.myProject, this.mySource));
        if (extractor == null) {
            LOG.error("Cannot create data extractor. DataExtractorFactory: " + (extractorFactory == null ? "unknown" : extractorFactory.getName()));
            TextResultView.updateEditorText(this.myViewer, this.myProject, "", (Language)PlainTextLanguage.INSTANCE);
            this.emptyTextPanel.setVisible(false);
            return;
        }
        if (!extractor.supportsText()) {
            this.emptyTextPanel.setVisible(true);
            TextResultView.updateEditorText(this.myViewer, this.myProject, "Extractor is binary. Preview is not available", (Language)PlainTextLanguage.INSTANCE);
            return;
        }
        Out.Readable out = new Out.Readable();
        GridExtractorsUtilCore.extract((Out)out, (ExtractionConfig)this.getExtractorConfig(), (List)columns, (DataExtractor)extractor, (List)rows, (int[])(grid != null ? grid.getVisibleColumns().asArray() : new int[]{}));
        this.emptyTextPanel.setVisible(false);
        TextResultView.updateEditorText(this.myViewer, this.myProject, out.getString(), this.guessLanguage());
    }

    protected List<? extends GridColumn> getColumns(@NotNull DumpSource<?> source) {
        if (source == null) {
            DumpDataForm.$$$reportNull$$$0(10);
        }
        return PREVIEW_COLUMNS;
    }

    protected List<? extends GridRow> getRows(@NotNull DumpSource<?> source) {
        if (source == null) {
            DumpDataForm.$$$reportNull$$$0(11);
        }
        return PREVIEW_ROWS;
    }

    @NotNull
    protected ExtractorConfig createConfig(@NotNull Project project, @NotNull DumpSource<?> source) {
        if (project == null) {
            DumpDataForm.$$$reportNull$$$0(12);
        }
        if (source == null) {
            DumpDataForm.$$$reportNull$$$0(13);
        }
        DataGrid grid = this.mySource instanceof DumpSource.DataGridSource ? ((DumpSource.DataGridSource)this.mySource).getGrid() : null;
        return new BaseExtractorConfig((ObjectFormatter)(grid != null ? grid.getObjectFormatter() : new BaseObjectFormatter()), project);
    }

    @NotNull
    private Language guessLanguage() {
        DataExtractorFactory selectedFactory = this.getFactory();
        return DumpDataForm.guessLanguage(selectedFactory == null ? null : selectedFactory.getFileExtension());
    }

    @NotNull
    private static Language guessLanguage(@Nullable String extension) {
        if (extension == null) {
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            if (plainTextLanguage == null) {
                DumpDataForm.$$$reportNull$$$0(14);
            }
            return plainTextLanguage;
        }
        Language language = (Language)ObjectUtils.notNull((Object)LanguageUtil.getFileTypeLanguage((FileType)FileTypeRegistry.getInstance().getFileTypeByExtension(extension)), (Object)PlainTextLanguage.INSTANCE);
        if (language == null) {
            DumpDataForm.$$$reportNull$$$0(15);
        }
        return language;
    }

    public ExtractionConfig getExtractorConfig() {
        return new ExtractionConfig(DumpDataForm.get(this.myAddTableDefinition), DumpDataForm.get(this.myTranspose), DumpDataForm.get(this.myAddComputed), DumpDataForm.get(this.myAddGenerated), Boolean.valueOf(DumpDataForm.get(this.myAddColumnHeader)), Boolean.valueOf(DumpDataForm.get(this.myAddRowHeader)), DumpDataForm.get(this.myAddQuery), false);
    }

    private static boolean get(@NotNull JBCheckBox checkBox) {
        if (checkBox == null) {
            DumpDataForm.$$$reportNull$$$0(16);
        }
        return checkBox.isVisible() && checkBox.isEnabled() && checkBox.isSelected();
    }

    public void saveState() {
        if (DumpDataForm.enabled(this.myAddComputed)) {
            DataExtractorProperties.setSkipComputed((!this.myAddComputed.isSelected() ? 1 : 0) != 0);
        }
        if (DumpDataForm.enabled(this.myAddGenerated)) {
            DataExtractorProperties.setSkipGeneratedColumns((!this.myAddGenerated.isSelected() ? 1 : 0) != 0);
        }
        if (DumpDataForm.enabled(this.myAddTableDefinition)) {
            DataExtractorProperties.setIncludeCreateTable((boolean)this.myAddTableDefinition.isSelected());
        }
        if (DumpDataForm.enabled(this.myAddQuery)) {
            DataExtractorProperties.setIncludeQuery((boolean)this.myAddQuery.isSelected());
        }
        String filePath = ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).getText();
        DataExtractorProperties.setOutputDir((String)DumpDataForm.getDir(filePath));
        DataExtractorFactory factory = this.getFactory();
        if (factory != null) {
            DataExtractorProperties.setCurrentExportExtractorFactory((Project)this.myProject, (DataExtractorFactory)factory);
        }
    }

    private static boolean enabled(JBCheckBox checkbox) {
        return checkbox.isVisible() && checkbox.isEnabled();
    }

    private static String getDir(String filePath) {
        int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        return lastSlash == -1 ? (StringUtil.containsChar((String)filePath, (char)'.') ? "" : filePath) : (filePath.length() - 1 == lastSlash ? filePath.substring(0, filePath.length() - 1) : (filePath.indexOf(46, lastSlash) == -1 ? filePath : filePath.substring(0, lastSlash)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowSupplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputPathManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFileOrDirectoryField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractorComboBox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createConfig";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 14, 15 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        LabeledComponentNoThrow labeledComponentNoThrow;
        LabeledComponentNoThrow labeledComponentNoThrow2;
        LabeledComponentNoThrow labeledComponentNoThrow3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox7;
        LabeledComponentNoThrow labeledComponentNoThrow4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 3, 1, 0, 3, 3, 3, null, new Dimension(400, 500), null));
        this.myPreviewLabeledComponent = labeledComponentNoThrow4 = new LabeledComponentNoThrow();
        labeledComponentNoThrow4.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponentNoThrow4.setText(DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Preview"));
        jPanel2.add((Component)labeledComponentNoThrow4, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(12, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 2, 1, 8, 2, 1, 3, new Dimension(400, -1), new Dimension(400, -1), new Dimension(400, -1)));
        this.myAddComputed = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.ComputedColumns"));
        jPanel3.add((Component)jBCheckBox7, new GridConstraints(3, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myAddColumnsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddColumns"));
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddGenerated = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.GeneratedColumns"));
        jPanel3.add((Component)jBCheckBox6, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 3, 1, 1, 0, 1, 2, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(9, 2, 1, 2, 0, 2, 1, 2, null, new Dimension(-1, 10), null));
        this.myTranspose = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Transpose"));
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(4, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myAddTableDefinition = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddTableDefinition"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(7, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myOutputFileOrDirectory = labeledComponentNoThrow3 = new LabeledComponentNoThrow();
        labeledComponentNoThrow3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponentNoThrow3.setText(DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.SaveTo.File"));
        jPanel3.add((Component)labeledComponentNoThrow3, new GridConstraints(10, 0, 1, 4, 0, 1, 3, 3, null, null, null));
        this.myExtractorCombobox = labeledComponentNoThrow2 = new LabeledComponentNoThrow();
        labeledComponentNoThrow2.setComponentClass("com.intellij.openapi.ui.ComboBox");
        labeledComponentNoThrow2.setText(DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Extractor"));
        jPanel3.add((Component)labeledComponentNoThrow2, new GridConstraints(2, 0, 1, 4, 8, 0, 3, 3, null, new Dimension(295, -1), new Dimension(295, -1)));
        this.mySourceLabeledComponent = labeledComponentNoThrow = new LabeledComponentNoThrow();
        labeledComponentNoThrow.setComponentClass("com.intellij.ui.components.JBScrollPane");
        labeledComponentNoThrow.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponentNoThrow.setText(DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Source"));
        jPanel3.add((Component)labeledComponentNoThrow, new GridConstraints(0, 0, 1, 4, 1, 1, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 2, null, new Dimension(-1, 10), null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(11, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myAddColumnHeader = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddColumnHeader"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(5, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myAddRowHeader = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddRowHeader"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(6, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myAddQuery = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DataGridBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Excel.AddQuery"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(8, 0, 1, 4, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class OutputFilePathManager
    implements OutputPathManager {
        private OutputFilePathManager() {
        }

        @Override
        @NotNull
        public Path getFilePath(@NotNull Path dirPath, @NotNull String defaultName, @NotNull String extension) {
            if (dirPath == null) {
                OutputFilePathManager.$$$reportNull$$$0(0);
            }
            if (defaultName == null) {
                OutputFilePathManager.$$$reportNull$$$0(1);
            }
            if (extension == null) {
                OutputFilePathManager.$$$reportNull$$$0(2);
            }
            Path path = dirPath.resolve(defaultName + "." + extension);
            if (path == null) {
                OutputFilePathManager.$$$reportNull$$$0(3);
            }
            return path;
        }

        @Override
        @NotNull
        public String getFieldName() {
            String string = DataGridBundle.message((String)"settings.database.DumpDialog.SaveTo.File", (Object[])new Object[0]);
            if (string == null) {
                OutputFilePathManager.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void focusGained(@NotNull TextFieldWithBrowseButton field2) {
            String filePath;
            int start;
            if (field2 == null) {
                OutputFilePathManager.$$$reportNull$$$0(5);
            }
            if ((start = Math.max((filePath = field2.getText()).lastIndexOf(47), filePath.lastIndexOf(92)) + 1) >= filePath.length()) {
                return;
            }
            int end = StringUtilRt.lastIndexOf((CharSequence)filePath, (char)'.', (int)start, (int)filePath.length());
            if (end != -1) {
                field2.getTextField().select(start, end);
            }
        }

        @Override
        @NotNull
        public Path updateFileExtension(@NotNull Path filePath, @NotNull String extension) {
            if (filePath == null) {
                OutputFilePathManager.$$$reportNull$$$0(6);
            }
            if (extension == null) {
                OutputFilePathManager.$$$reportNull$$$0(7);
            }
            if (Files.isDirectory(filePath, new LinkOption[0]) || FileUtilRt.extensionEquals((String)filePath.getFileName().toString(), (String)extension)) {
                Path path = filePath;
                if (path == null) {
                    OutputFilePathManager.$$$reportNull$$$0(8);
                }
                return path;
            }
            String name = FileUtilRt.getNameWithoutExtension((String)filePath.getFileName().toString());
            Path path = filePath.resolveSibling(name + "." + extension);
            if (path == null) {
                OutputFilePathManager.$$$reportNull$$$0(9);
            }
            return path;
        }

        @Override
        @NotNull
        public Path adjustChosenFile(@NotNull Path path, @NotNull String defaultName, @NotNull String extension) {
            if (path == null) {
                OutputFilePathManager.$$$reportNull$$$0(10);
            }
            if (defaultName == null) {
                OutputFilePathManager.$$$reportNull$$$0(11);
            }
            if (extension == null) {
                OutputFilePathManager.$$$reportNull$$$0(12);
            }
            Path path2 = Files.isDirectory(path, new LinkOption[0]) ? this.getFilePath(path, defaultName, extension) : path;
            if (path2 == null) {
                OutputFilePathManager.$$$reportNull$$$0(13);
            }
            return path2;
        }

        @Override
        public String validatePath(String path) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null) {
                return virtualFile.isDirectory() ? DataGridBundle.message((String)"settings.database.DumpDialog.Errors.NotFile", (Object[])new Object[0]) : null;
            }
            VirtualFile parentFile = LocalFileSystem.getInstance().findFileByPath(PathUtil.getParentPath((String)path));
            return parentFile == null || !parentFile.isDirectory() ? DataGridBundle.message((String)"settings.database.DumpDialog.Errors.ParentDirNotExist", (Object[])new Object[0]) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 8, 9, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirPath";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 2: 
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm$OutputFilePathManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm$OutputFilePathManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateFileExtension";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustChosenFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilePath";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 13: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "focusGained";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFileExtension";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustChosenFile";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 8, 9, 13 -> new IllegalStateException(string);
            };
        }
    }

    private static class OutputDirectoryPathManager
    implements OutputPathManager {
        private OutputDirectoryPathManager() {
        }

        @Override
        @NotNull
        public Path getFilePath(@NotNull Path dirPath, @NotNull String defaultName, @NotNull String extension) {
            if (dirPath == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(0);
            }
            if (defaultName == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(1);
            }
            if (extension == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(2);
            }
            Path path = dirPath;
            if (path == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(3);
            }
            return path;
        }

        @Override
        @NotNull
        public String getFieldName() {
            String string = DataGridBundle.message((String)"settings.database.DumpDialog.SaveTo.Directory", (Object[])new Object[0]);
            if (string == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public Path updateFileExtension(@NotNull Path filePath, @NotNull String extension) {
            if (filePath == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(5);
            }
            if (extension == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(6);
            }
            Path path = filePath;
            if (path == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(7);
            }
            return path;
        }

        @Override
        @NotNull
        public Path adjustChosenFile(@NotNull Path path, @NotNull String defaultName, @NotNull String extension) {
            if (path == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(8);
            }
            if (defaultName == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(9);
            }
            if (extension == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(10);
            }
            Path path2 = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
            if (path2 == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(11);
            }
            return path2;
        }

        @Override
        public String validatePath(String path) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            return virtualFile == null ? DataGridBundle.message((String)"settings.database.DumpDialog.Errors.DirNotExist", (Object[])new Object[0]) : (!virtualFile.isDirectory() ? DataGridBundle.message((String)"settings.database.DumpDialog.Errors.NotDir", (Object[])new Object[0]) : null);
        }

        @Override
        public void focusGained(@NotNull TextFieldWithBrowseButton field2) {
            if (field2 == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(12);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 7, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirPath";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 2: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm$OutputDirectoryPathManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm$OutputDirectoryPathManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateFileExtension";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustChosenFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilePath";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFileExtension";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustChosenFile";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "focusGained";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 7, 11 -> new IllegalStateException(string);
            };
        }
    }

    public static interface OutputPathManager {
        @NotNull
        public Path getFilePath(@NotNull Path var1, @NotNull String var2, @NotNull String var3);

        @NlsContexts.Label
        @NotNull
        public String getFieldName();

        @NotNull
        public Path updateFileExtension(@NotNull Path var1, @NotNull String var2);

        @NotNull
        public Path adjustChosenFile(@NotNull Path var1, @NotNull String var2, @NotNull String var3);

        @NlsContexts.DialogMessage
        @Nullable
        public String validatePath(String var1);

        public void focusGained(@NotNull TextFieldWithBrowseButton var1);
    }
}

