/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.yaml.datasource.detector;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.SpringDataSourceInfoProvider;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/boot/yaml/datasource/detector/SpringBootYamlConfigDataSourceInfoProvider;", "Lcom/intellij/spring/model/SpringDataSourceInfoProvider;", "<init>", "()V", "getModuleDataSourceUrls", "", "", "module", "Lcom/intellij/openapi/module/Module;", "getUrlFromFile", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "intellij.spring.boot.yaml.datasource"})
@SourceDebugExtension(value={"SMAP\nSpringBootYamlConfigDataSourceInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootYamlConfigDataSourceInfoProvider.kt\ncom/intellij/spring/boot/yaml/datasource/detector/SpringBootYamlConfigDataSourceInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class SpringBootYamlConfigDataSourceInfoProvider
implements SpringDataSourceInfoProvider {
    @NotNull
    public List<String> getModuleDataSourceUrls(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List result = new ArrayList();
        for (VirtualFile file : SpringBootConfigurationFileService.getInstance().findConfigFiles(module, false)) {
            String it;
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
            YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
            if (yAMLFile == null) continue;
            YAMLFile yamlFile = yAMLFile;
            if (this.getUrlFromFile(yamlFile) == null) continue;
            boolean bl = false;
            result.add(it);
        }
        return result;
    }

    private final String getUrlFromFile(YAMLFile yamlFile) {
        return (String)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)yamlFile), () -> SpringBootYamlConfigDataSourceInfoProvider.getUrlFromFile$lambda$0(yamlFile));
    }

    private static final CachedValueProvider.Result getUrlFromFile$lambda$0(YAMLFile $yamlFile) {
        YAMLValue value;
        YAMLKeyValue keyValue;
        String url = null;
        char[] cArray = new char[]{'.'};
        List keyPath = StringsKt.split$default((CharSequence)"spring.datasource.url", (char[])cArray, (boolean)false, (int)0, (int)6, null);
        YAMLKeyValue yAMLKeyValue = keyValue = YAMLUtil.getQualifiedKeyInFile((YAMLFile)$yamlFile, (List)keyPath);
        Object object = value = yAMLKeyValue != null ? yAMLKeyValue.getValue() : null;
        if (value instanceof YAMLScalar) {
            String string = ((YAMLScalar)value).getTextValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
            String text = string;
            if (!StringsKt.isBlank((CharSequence)text)) {
                url = text;
            }
        }
        Object[] objectArray = new Object[]{$yamlFile};
        return CachedValueProvider.Result.create(url, (Object[])objectArray);
    }
}

