/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.logger;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/stats/completion/logger/LineStorage;", "", "<init>", "()V", "lines", "", "", "value", "", "size", "getSize", "()I", "appendLine", "", "line", "", "dump", "dest", "Ljava/io/File;", "Companion", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nLineStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStorage.kt\ncom/intellij/stats/completion/logger/LineStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1915#2,2:68\n*S KotlinDebug\n*F\n+ 1 LineStorage.kt\ncom/intellij/stats/completion/logger/LineStorage\n*L\n38#1:68,2\n*E\n"})
public final class LineStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<byte[]> lines = new ArrayList();
    private int size;

    public final int getSize() {
        return this.size;
    }

    public final void appendLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        byte[] gzippedLine = LineStorage.Companion.gzip(line);
        this.size += gzippedLine.length;
        this.lines.add(gzippedLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(@NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Closeable closeable = new GZIPOutputStream(new FileOutputStream(dest));
        Object object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = null;
        try {
            BufferedWriter out = (BufferedWriter)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = this.lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                byte[] it = (byte[])element$iv;
                boolean bl2 = false;
                ((Appendable)out).append(LineStorage.Companion.ungzip(it)).append('\n');
            }
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\u000b\u001a\u00020\u0005*\u00020\nH\u0002J\f\u0010\f\u001a\u00020\n*\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/stats/completion/logger/LineStorage$Companion;", "", "<init>", "()V", "readAsZipArray", "", "file", "Ljava/io/File;", "readAsLines", "", "", "gzip", "ungzip", "intellij.statsCollector"})
    @SourceDebugExtension(value={"SMAP\nLineStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStorage.kt\ncom/intellij/stats/completion/logger/LineStorage$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n777#2:68\n873#2,2:69\n1#3:71\n*S KotlinDebug\n*F\n+ 1 LineStorage.kt\ncom/intellij/stats/completion/logger/LineStorage$Companion\n*L\n53#1:68\n53#1:69,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] readAsZipArray(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)".gz", (boolean)false, (int)2, null)) {
                return FilesKt.readBytes((File)file);
            }
            return this.gzip(FilesKt.readText$default((File)file, null, (int)1, null));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> readAsLines(@NotNull File file) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$filter$iv = StringsKt.lines((CharSequence)this.ungzip(this.readAsZipArray(file)));
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final byte[] gzip(String $this$gzip) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Closeable closeable = new GZIPOutputStream(outputStream);
            Throwable throwable = null;
            try {
                GZIPOutputStream it = (GZIPOutputStream)closeable;
                boolean bl = false;
                byte[] byArray = $this$gzip.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] byArray = outputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return byArray;
        }

        private final String ungzip(byte[] $this$ungzip) {
            InputStream inputStream = new GZIPInputStream(new ByteArrayInputStream($this$ungzip));
            Charset charset = Charsets.UTF_8;
            return TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

