/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.ui.presentation;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0002\b\tH\u0002J*\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ2\u0010\u0010\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J2\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0012J)\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u0016*\u00020\u00062\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00160\b\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/GraphicsUtils;", "", "<init>", "()V", "clearShapeOverEditor", "", "Ljava/awt/Graphics2D;", "drawShape", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "clearOvalOverEditor", "x", "", "y", "width", "height", "clearHalfOvalOverEditor", "upper", "", "fillHalfOval", "upperHalf", "useCopy", "T", "block", "(Ljava/awt/Graphics2D;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.markdown"})
public final class GraphicsUtils {
    @NotNull
    public static final GraphicsUtils INSTANCE = new GraphicsUtils();

    private GraphicsUtils() {
    }

    private final void clearShapeOverEditor(Graphics2D $this$clearShapeOverEditor, Function1<? super Graphics2D, Unit> drawShape) {
        Composite originalComposite = $this$clearShapeOverEditor.getComposite();
        Paint originalPaint = $this$clearShapeOverEditor.getPaint();
        $this$clearShapeOverEditor.setComposite(AlphaComposite.Src);
        $this$clearShapeOverEditor.setColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        drawShape.invoke((Object)$this$clearShapeOverEditor);
        $this$clearShapeOverEditor.setPaint(originalPaint);
        $this$clearShapeOverEditor.setComposite(originalComposite);
    }

    public final void clearOvalOverEditor(@NotNull Graphics2D $this$clearOvalOverEditor, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$clearOvalOverEditor, (String)"<this>");
        this.clearShapeOverEditor($this$clearOvalOverEditor, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> GraphicsUtils.clearOvalOverEditor$lambda$0(x, y, width, height, arg_0)));
    }

    public final void clearHalfOvalOverEditor(@NotNull Graphics2D $this$clearHalfOvalOverEditor, int x, int y, int width, int height, boolean upper) {
        Intrinsics.checkNotNullParameter((Object)$this$clearHalfOvalOverEditor, (String)"<this>");
        this.clearShapeOverEditor($this$clearHalfOvalOverEditor, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> GraphicsUtils.clearHalfOvalOverEditor$lambda$0(x, y, width, height, upper, arg_0)));
    }

    public final void fillHalfOval(@NotNull Graphics2D $this$fillHalfOval, int x, int y, int width, int height, boolean upperHalf) {
        Intrinsics.checkNotNullParameter((Object)$this$fillHalfOval, (String)"<this>");
        double start = upperHalf ? 180.0 : 0.0;
        Arc2D.Double arc = new Arc2D.Double(x, y, width, height, start, 180.0, 2);
        $this$fillHalfOval.fill(arc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T useCopy(@NotNull Graphics2D $this$useCopy, @NotNull Function1<? super Graphics2D, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)$this$useCopy, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Graphics graphics = $this$useCopy.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D local = (Graphics2D)graphics;
        try {
            Object object = block.invoke((Object)local);
            return (T)object;
        }
        finally {
            local.dispose();
        }
    }

    private static final Unit clearOvalOverEditor$lambda$0(int $x, int $y, int $width, int $height, Graphics2D $this$clearShapeOverEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$clearShapeOverEditor, (String)"$this$clearShapeOverEditor");
        $this$clearShapeOverEditor.fillOval($x, $y, $width, $height);
        return Unit.INSTANCE;
    }

    private static final Unit clearHalfOvalOverEditor$lambda$0(int $x, int $y, int $width, int $height, boolean $upper, Graphics2D $this$clearShapeOverEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$clearShapeOverEditor, (String)"$this$clearShapeOverEditor");
        INSTANCE.fillHalfOval($this$clearShapeOverEditor, $x, $y, $width, $height, $upper);
        return Unit.INSTANCE;
    }
}

