/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks.special;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownBlocks;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.EmphasisFormattingBlockKt;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownWrappingFormattingBlock;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/special/EmphasisFormattingBlock;", "Lorg/intellij/plugins/markdown/lang/formatter/blocks/special/MarkdownWrappingFormattingBlock;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "node", "Lcom/intellij/lang/ASTNode;", "alignment", "Lcom/intellij/formatting/Alignment;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/formatting/SpacingBuilder;Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/Alignment;)V", "buildChildren", "", "Lcom/intellij/formatting/Block;", "intellij.markdown"})
public final class EmphasisFormattingBlock
extends MarkdownWrappingFormattingBlock {
    public EmphasisFormattingBlock(@NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull ASTNode node, @Nullable Alignment alignment) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(settings, spacing, node, alignment, Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true));
    }

    @Override
    @NotNull
    protected List<Block> buildChildren() {
        List list2;
        Wrap noneWrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        Sequence<ASTNode> filtered = MarkdownBlocks.INSTANCE.filterFromWhitespaces(AstUtilsKt.children(aSTNode));
        List $this$buildChildren_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (ASTNode node : filtered) {
            IElementType iElementType = MarkdownTokenTypes.TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TEXT");
            if (AstUtilsKt.hasType(node, iElementType)) {
                this.processTextElement($this$buildChildren_u24lambda_u240, node, this.getWrap(), !EmphasisFormattingBlockKt.access$isFirstContentElement(node));
                continue;
            }
            IElementType iElementType2 = MarkdownTokenTypes.EMPH;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"EMPH");
            if (AstUtilsKt.hasType(node, iElementType2)) {
                boolean bl2 = EmphasisFormattingBlockKt.access$isLast(node) ? $this$buildChildren_u24lambda_u240.add(new MarkdownWrappingFormattingBlock(this.getSettings(), this.getSpacing(), node, this.getAlignment(), noneWrap)) : $this$buildChildren_u24lambda_u240.add(new MarkdownWrappingFormattingBlock(this.getSettings(), this.getSpacing(), node, this.getAlignment(), this.getWrap()));
                continue;
            }
            $this$buildChildren_u24lambda_u240.add(MarkdownBlocks.INSTANCE.create(node, this.getSettings(), this.getSpacing(), (Function1<? super ASTNode, ? extends Alignment>)((Function1)arg_0 -> EmphasisFormattingBlock.buildChildren$lambda$0$0(this, arg_0))));
        }
        return CollectionsKt.build((List)list2);
    }

    private static final Alignment buildChildren$lambda$0$0(EmphasisFormattingBlock this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getAlignment();
    }
}

