/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references.paths;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000fH$J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/FileWithoutExtensionReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "fileReference", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "soft", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;Z)V", "path", "", "getPath", "()Ljava/lang/String;", "containingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContainingFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "resolve", "findReferencedFile", "handleElementRename", "newElementName", "Companion", "intellij.markdown"})
@ApiStatus.Internal
public abstract class FileWithoutExtensionReference
extends PsiReferenceBase<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileReference fileReference;

    public FileWithoutExtensionReference(@NotNull PsiElement element2, @NotNull FileReference fileReference, boolean soft) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)fileReference, (String)"fileReference");
        super(element2, fileReference.getRangeInElement(), soft);
        this.fileReference = fileReference;
    }

    @NotNull
    protected final String getPath() {
        return this.fileReference.getFileReferenceSet().getPathString() + "." + MarkdownFileType.INSTANCE.getDefaultExtension();
    }

    @Nullable
    protected final VirtualFile getContainingFile() {
        PsiFile psiFile = this.getElement().getContainingFile();
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    @Nullable
    public PsiElement resolve() {
        VirtualFile virtualFile = this.findReferencedFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile referencedFile = virtualFile;
        VirtualFile virtualFile2 = referencedFile.getParent();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile directory = virtualFile2;
        if (directory.findChild(referencedFile.getNameWithoutExtension()) == null) {
            return (PsiElement)PsiUtilCore.getPsiFile((Project)this.getElement().getProject(), (VirtualFile)referencedFile);
        }
        return null;
    }

    @Nullable
    protected abstract VirtualFile findReferencedFile();

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        String string = FileWithoutExtensionReference.Companion.hasMarkdownExtensions(newElementName) ? FileUtilRt.getNameWithoutExtension((String)newElementName) : newElementName;
        Intrinsics.checkNotNull((Object)string);
        String newText = string;
        PsiElement psiElement = super.handleElementRename(newText);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"handleElementRename(...)");
        return psiElement;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/FileWithoutExtensionReference$Companion;", "", "<init>", "()V", "hasMarkdownExtensions", "", "name", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasMarkdownExtensions(String name) {
            FileType fileType2 = FileTypeRegistry.getInstance().getFileTypeByFileName(name);
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileTypeByFileName(...)");
            FileType type = fileType2;
            return MarkdownLanguageUtilsKt.isMarkdownType(type);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

