/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JamAnnotationArchetype {
    @Nullable
    private final JamAnnotationArchetype myArchetype;
    private final List<JamAttributeMeta<?>> myAttributes = new SmartList();

    public JamAnnotationArchetype() {
        this(null);
    }

    public JamAnnotationArchetype(@Nullable JamAnnotationArchetype archetype) {
        this.myArchetype = archetype;
    }

    public JamAnnotationArchetype addAttribute(JamAttributeMeta<?> attributeMeta) {
        this.myAttributes.add(attributeMeta);
        return this;
    }

    public List<JamAttributeMeta<?>> getAttributes() {
        return this.myAttributes;
    }

    @Nullable
    public JamAnnotationArchetype getArchetype() {
        return this.myArchetype;
    }

    @Nullable
    public JamAttributeMeta<?> findAttribute(@Nullable @NonNls String name) {
        if (name == null) {
            name = "value";
        }
        for (JamAttributeMeta<?> attribute : this.myAttributes) {
            if (!attribute.getAttributeLink().getAttributeName().equals(name)) continue;
            return attribute;
        }
        if (this.myArchetype != null) {
            return this.myArchetype.findAttribute(name);
        }
        return null;
    }
}

