/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.ConfigurationWithAlternativeJre;
import com.intellij.execution.configurations.ModuleBasedConfigurationOptions;
import com.intellij.execution.impl.statistics.FusAwareRunConfiguration;
import com.intellij.execution.impl.statistics.RunConfigurationUsageTriggerCollector;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface CommonJavaRunConfigurationParameters
extends CommonProgramRunConfigurationParameters,
ConfigurationWithAlternativeJre,
FusAwareRunConfiguration {
    public void setVMParameters(@Nullable String var1);

    public String getVMParameters();

    public boolean isAlternativeJrePathEnabled();

    public void setAlternativeJrePathEnabled(boolean var1);

    @Nullable
    public String getAlternativeJrePath();

    public void setAlternativeJrePath(@Nullable String var1);

    @Nullable
    public String getRunClass();

    @Nullable
    public String getPackage();

    default public List<ModuleBasedConfigurationOptions.ClasspathModification> getClasspathModifications() {
        return Collections.emptyList();
    }

    default public void setClasspathModifications(List<ModuleBasedConfigurationOptions.ClasspathModification> modifications) {
    }

    default public @Unmodifiable @NotNull List<EventPair<?>> getAdditionalUsageData() {
        EventPair<Integer> data = CommonJavaRunConfigurationParameters.getAlternativeJreUserData(this.getAlternativeJrePath());
        List list = ContainerUtil.createMaybeSingletonList(data);
        if (list == null) {
            CommonJavaRunConfigurationParameters.$$$reportNull$$$0(0);
        }
        return list;
    }

    public static EventPair<Integer> getAlternativeJreUserData(String jrePath) {
        JavaVersion version;
        if (jrePath != null && (version = JavaParametersUtil.getJavaVersion(jrePath)) != null) {
            return RunConfigurationUsageTriggerCollector.ALTERNATIVE_JRE_VERSION.with((Object)version.feature);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommonJavaRunConfigurationParameters", "getAdditionalUsageData"));
    }
}

