/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.IndexingBundle;
import java.awt.Component;
import java.awt.Window;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchForTestsTask
extends Task.Backgroundable {
    public static final Key<Boolean> CONNECT_IN_UNIT_TEST_MODE_PROPERTY_KEY = Key.create((String)"SearchForTestsTask.connect.in.unit.test.mode");
    private static final Logger LOG = Logger.getInstance(SearchForTestsTask.class);
    protected Socket mySocket;
    private final ServerSocket myServerSocket;
    private ProgressIndicator myProcessIndicator;
    private boolean myAllowIndexInDumbMode;
    @NotNull
    private Runnable myIncompleteIndexUsageCallback = EmptyRunnable.getInstance();

    public SearchForTestsTask(@Nullable Project project, ServerSocket socket) {
        super(project, ExecutionBundle.message((String)"searching.test.progress.title", (Object[])new Object[0]), true);
        this.myServerSocket = socket;
    }

    protected abstract void search() throws ExecutionException;

    protected abstract void onFound() throws ExecutionException;

    public void ensureFinished() {
        if (this.myProcessIndicator != null && !this.myProcessIndicator.isCanceled()) {
            this.finish();
        }
    }

    public void startSearch() {
        if (ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(CONNECT_IN_UNIT_TEST_MODE_PROPERTY_KEY)) {
            try {
                this.search();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            try {
                this.onFound();
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        } else {
            this.myProcessIndicator = new BackgroundableProcessIndicator((Task.Backgroundable)this);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, this.myProcessIndicator);
        }
    }

    public void attachTaskToProcess(final OSProcessHandler handler) {
        handler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                handler.removeProcessListener((ProcessListener)this);
                SearchForTestsTask.this.ensureFinished();
            }

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                SearchForTestsTask.this.startSearch();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/testframework/SearchForTestsTask$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected boolean requiresSmartMode() {
        return true;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SearchForTestsTask.$$$reportNull$$$0(0);
        }
        try {
            LOG.debug("Waiting for connection on port " + this.myServerSocket.getLocalPort());
            this.mySocket = this.myServerSocket.accept();
            ExecutionException[] ex = new ExecutionException[1];
            NonBlockingReadAction readAction = ReadAction.nonBlocking(() -> this.performWithIncompleteIndex((ThrowableRunnable<ExecutionException>)((ThrowableRunnable)this::search), ex));
            if (this.requiresSmartMode() && !this.myAllowIndexInDumbMode) {
                readAction = readAction.inSmartMode(this.myProject);
            }
            readAction.executeSynchronously();
            if (ex[0] != null) {
                this.logCantRunException(ex[0]);
            }
            ExecutionException[] onFoundEx = new ExecutionException[1];
            Runnable runnable = () -> this.performWithIncompleteIndex((ThrowableRunnable<ExecutionException>)((ThrowableRunnable)this::onFound), onFoundEx);
            if (this.requiresSmartMode() && !this.myAllowIndexInDumbMode) {
                DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(runnable);
            } else {
                ReadAction.run(runnable::run);
            }
            if (onFoundEx[0] != null) {
                throw onFoundEx[0];
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    protected void logCantRunException(ExecutionException e) throws ExecutionException {
        throw e;
    }

    public void onCancel() {
        this.finish();
    }

    public void onSuccess() {
        Runnable runnable = this::finish;
        if (this.requiresSmartMode() && !this.myAllowIndexInDumbMode) {
            DumbService.getInstance((Project)this.getProject()).runWhenSmart(runnable);
        } else {
            runnable.run();
        }
    }

    private void performWithIncompleteIndex(ThrowableRunnable<ExecutionException> action, ExecutionException[] ex) {
        try {
            if (this.myAllowIndexInDumbMode && DumbService.isDumb((Project)this.myProject)) {
                this.myIncompleteIndexUsageCallback.run();
                DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
                    action.run();
                    return null;
                });
            } else {
                action.run();
            }
        }
        catch (ExecutionException e) {
            ex[0] = e;
        }
    }

    public void finish() {
        FilterOutputStream os = null;
        try {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return;
            }
            os = new DataOutputStream(this.mySocket.getOutputStream());
            ((DataOutputStream)os).writeBoolean(true);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            try {
                if (!this.myServerSocket.isClosed()) {
                    this.myServerSocket.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    public void setIncompleteIndexUsageCallback(@NotNull Runnable incompleteIndexUsageCallback) {
        if (incompleteIndexUsageCallback == null) {
            SearchForTestsTask.$$$reportNull$$$0(1);
        }
        this.myIncompleteIndexUsageCallback = incompleteIndexUsageCallback;
    }

    @ApiStatus.Internal
    public void arrangeForIndexAccess() {
        if (!this.requiresSmartMode() || !DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        final AtomicBoolean canProceedWithTests = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            final JLabel component = new JLabel(new HtmlBuilder().appendRaw(ExecutionBundle.message((String)"tests.wait.or.use.partial.index", (Object[])new Object[0])).wrapWithHtmlBody().toString());
            DialogWrapper dialog = new DialogWrapper(this, this.myProject){
                {
                    super(arg0);
                    this.setTitle(IndexingBundle.message((String)"progress.indexing.updating.title", (Object[])new Object[0]));
                    this.setOKButtonText(ExecutionBundle.message((String)"test.button.run.with.partial.index", (Object[])new Object[0]));
                    this.init();
                    LaterInvocator.markTransparent((ModalityState)ModalityState.stateForComponent((Component)component));
                }

                protected JComponent createCenterPanel() {
                    return component;
                }
            };
            this.myProject.getMessageBus().connect(dialog.getDisposable()).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void exitDumbMode() {
                    canProceedWithTests.set(true);
                    Window window = ComponentUtil.getWindow((Component)component);
                    if (window != null) {
                        window.setVisible(false);
                    }
                }
            });
            if (dialog.showAndGet()) {
                this.myAllowIndexInDumbMode = true;
                canProceedWithTests.set(true);
            }
        });
        if (canProceedWithTests.get()) {
            return;
        }
        throw new ProcessCanceledException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompleteIndexUsageCallback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/SearchForTestsTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setIncompleteIndexUsageCallback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

