/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.ui.BeforeRunComponent;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.RunConfigurationEditorFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.VmOptionsEditor;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.EditCustomVmOptionsAction;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonJavaFragments {
    public static final String JRE_PATH = "jrePath";

    private static boolean hasTask(@NotNull RunnerAndConfigurationSettingsImpl s) {
        if (s == null) {
            CommonJavaFragments.$$$reportNull$$$0(0);
        }
        return ContainerUtil.exists((Iterable)s.getManager().getBeforeRunTasks(s.getConfiguration()), t -> CompileStepBeforeRun.ID == t.getProviderId());
    }

    public static <S extends RunConfigurationBase<?>> SettingsEditorFragment<S, JLabel> createBuildBeforeRun(final BeforeRunComponent beforeRunComponent, SettingsEditor<S> settingsEditor) {
        final String buildAndRun = ExecutionBundle.message((String)"application.configuration.title.build.and.run", (Object[])new Object[0]);
        final String run = ExecutionBundle.message((String)"application.configuration.title.run", (Object[])new Object[0]);
        final JLabel jLabel = new JLabel(buildAndRun);
        jLabel.setFont(JBUI.Fonts.label().deriveFont(1));
        RunConfigurationEditorFragment fragment = new RunConfigurationEditorFragment<S, JLabel>("doNotBuildBeforeRun", ExecutionBundle.message((String)"do.not.build.before.run", (Object[])new Object[0]), ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), jLabel, -1, settings -> !CommonJavaFragments.hasTask(settings)){

            public void doReset(@NotNull RunnerAndConfigurationSettingsImpl s) {
                if (s == null) {
                    1.$$$reportNull$$$0(0);
                }
                jLabel.setText(CommonJavaFragments.hasTask(s) ? buildAndRun : run);
            }

            public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
                if (s == null) {
                    1.$$$reportNull$$$0(1);
                }
                ArrayList<BeforeRunTask> tasks = new ArrayList<BeforeRunTask>(s.getManager().getBeforeRunTasks(s.getConfiguration()));
                if (!this.isSelected()) {
                    if (!CommonJavaFragments.hasTask(s)) {
                        CompileStepBeforeRun.MakeBeforeRunTask task = new CompileStepBeforeRun.MakeBeforeRunTask();
                        task.setEnabled(true);
                        tasks.add(task);
                    }
                } else {
                    tasks.removeIf(t -> CompileStepBeforeRun.ID == t.getProviderId());
                }
                s.getManager().setBeforeRunTasks(s.getConfiguration(), tasks);
            }

            public void setSelected(boolean selected) {
                jLabel.setText(selected ? run : buildAndRun);
                beforeRunComponent.addOrRemove(CompileStepBeforeRun.ID, !selected);
                this.fireEditorStateChanged();
            }

            public boolean isSelected() {
                return run.equals(jLabel.getText());
            }

            @NotNull
            protected JComponent createEditor() {
                JComponent jComponent = this.myComponent;
                if (jComponent == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/ui/CommonJavaFragments$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/ui/CommonJavaFragments$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEditor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doReset";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "applyEditorTo";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        settingsEditor.addSettingsEditorListener(editor -> jLabel.setText(beforeRunComponent.hasEnabledTask(CompileStepBeforeRun.ID) ? buildAndRun : run));
        fragment.setActionHint(ExecutionBundle.message((String)"run.the.application.without.launching.the.build.process", (Object[])new Object[0]));
        return fragment;
    }

    public static <S extends ModuleBasedConfiguration<?, ?>> SettingsEditorFragment<S, ModuleClasspathCombo> moduleClasspath() {
        ModuleClasspathCombo comboBox = new ModuleClasspathCombo(new ModuleClasspathCombo.Item[0]);
        String name = ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module", (Object[])new Object[0]);
        comboBox.getAccessibleContext().setAccessibleName(name);
        CommandLinePanel.setMinimumWidth((Component)((Object)comboBox), (int)400);
        CommonParameterFragments.setMonospaced((Component)((Object)comboBox));
        SettingsEditorFragment fragment = new SettingsEditorFragment("module.classpath", name, ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), (JComponent)((Object)comboBox), 10, (s, c) -> comboBox.reset((ModuleBasedConfiguration<?, ?>)s), (s, c) -> {
            if (comboBox.isVisible()) {
                comboBox.applyTo((ModuleBasedConfiguration<?, ?>)s);
            } else {
                s.setModule(s.getDefaultModule());
            }
        }, s -> ModuleManager.getInstance((Project)s.getProject()).getModules().length > 1);
        fragment.setHint(ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module.hint", (Object[])new Object[0]));
        fragment.setActionHint(ExecutionBundle.message((String)"the.module.whose.classpath.will.be.used.the.classpath.specified.in.the.vm.options.takes.precedence.over.this.one", (Object[])new Object[0]));
        return fragment;
    }

    @NotNull
    public static <T extends CommonJavaRunConfigurationParameters> SettingsEditorFragment<T, JrePathEditor> createJrePath(DefaultJreSelector defaultJreSelector) {
        JrePathEditor jrePathEditor = new JrePathEditor(false);
        jrePathEditor.setDefaultJreSelector(defaultJreSelector);
        ComboBox comboBox = (ComboBox)jrePathEditor.getComponent();
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JrePathEditor.JreComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JrePathEditor.JreComboBoxItem> list, JrePathEditor.JreComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    return;
                }
                if ("Bundled".equals(value.getPresentableText())) {
                    if (index == -1) {
                        this.append("java ");
                    }
                    this.append(ExecutionBundle.message((String)"bundled.jre.name", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    return;
                }
                if (value.getPathOrName() == null && value.getVersion() == null) {
                    this.append(StringUtil.notNullize((String)value.getDescription()));
                    return;
                }
                if (index == -1) {
                    this.append("java ");
                    String shortVersion = this.appendShortVersion(value);
                    if (value.getPathOrName() != null && !value.getPathOrName().equals(shortVersion)) {
                        this.append(value.getPathOrName() + " ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else if (value.getDescription() != null) {
                        this.append(value.getDescription() + " ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                } else {
                    if (value.getPathOrName() != null) {
                        this.append(value.getPathOrName() + " ");
                    } else {
                        this.appendShortVersion(value);
                    }
                    if (value.getDescription() != null) {
                        this.append(value.getDescription() + " ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }

            @Nullable
            @NlsSafe
            private String appendShortVersion(JrePathEditor.JreComboBoxItem value) {
                JavaSdkVersion version;
                if (value.getVersion() != null && (version = JavaSdkVersion.fromVersionString((String)value.getVersion())) != null) {
                    this.append(version.getDescription() + " ");
                    return version.getDescription();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/CommonJavaFragments$2", "customizeCellRenderer"));
            }
        });
        CommonParameterFragments.setMonospaced((Component)comboBox);
        Dimension minimumSize = CommandLinePanel.setMinimumWidth((Component)((Object)jrePathEditor), (int)200);
        jrePathEditor.setPreferredSize(minimumSize);
        jrePathEditor.getLabel().setVisible(false);
        ((ComboBox)jrePathEditor.getComponent()).getAccessibleContext().setAccessibleName(jrePathEditor.getLabel().getText());
        return CommonJavaFragments.createJrePathEditorFragment(jrePathEditor, (ComboBox<JrePathEditor.JreComboBoxItem>)comboBox);
    }

    @NotNull
    private static <T extends CommonJavaRunConfigurationParameters> SettingsEditorFragment<T, JrePathEditor> createJrePathEditorFragment(@NotNull JrePathEditor jrePathEditor, @NotNull ComboBox<JrePathEditor.JreComboBoxItem> comboBox) {
        if (jrePathEditor == null) {
            CommonJavaFragments.$$$reportNull$$$0(1);
        }
        if (comboBox == null) {
            CommonJavaFragments.$$$reportNull$$$0(2);
        }
        SettingsEditorFragment jrePath = new SettingsEditorFragment(JRE_PATH, ExecutionBundle.message((String)"run.configuration.jre.name", (Object[])new Object[0]), null, (JComponent)((Object)jrePathEditor), 5, (configuration, editor) -> editor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled()), (configuration, editor) -> {
            configuration.setAlternativeJrePath(editor.getJrePathOrName());
            configuration.setAlternativeJrePathEnabled(editor.isAlternativeJreSelected());
        }, Predicates.alwaysTrue());
        jrePath.setRemovable(false);
        jrePath.setHint(ExecutionBundle.message((String)"run.configuration.jre.hint", (Object[])new Object[0]));
        jrePath.setValidation(configuration -> new SmartList((Object)RuntimeConfigurationException.validate((JComponent)comboBox, () -> {
            if (!(configuration instanceof TargetEnvironmentAwareRunProfile) || TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)((TargetEnvironmentAwareRunProfile)configuration), (Project)configuration.getProject()) == null) {
                JavaParametersUtil.checkAlternativeJRE(configuration);
            }
        })));
        SettingsEditorFragment settingsEditorFragment = jrePath;
        if (settingsEditorFragment == null) {
            CommonJavaFragments.$$$reportNull$$$0(3);
        }
        return settingsEditorFragment;
    }

    @NotNull
    public static <T extends JavaRunConfigurationBase> SettingsEditorFragment<T, RawCommandLineEditor> vmOptions(Computable<Boolean> hasModule) {
        String group = ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]);
        RawCommandLineEditor vmOptions = new RawCommandLineEditor();
        CommandLinePanel.setMinimumWidth((Component)vmOptions, (int)400);
        CommonParameterFragments.setMonospaced((Component)vmOptions.getTextField());
        String message = ExecutionBundle.message((String)"run.configuration.java.vm.parameters.empty.text", (Object[])new Object[0]);
        vmOptions.getEditorField().getAccessibleContext().setAccessibleName(message);
        vmOptions.getEditorField().getEmptyText().setText(message);
        MacrosDialog.addMacroSupport((ExtendableTextField)vmOptions.getEditorField(), (Predicate)MacrosDialog.Filters.ALL, hasModule);
        TextComponentEmptyText.setupPlaceholderVisibility((JTextComponent)vmOptions.getEditorField());
        return CommonJavaFragments.createVmOptionsFragment(group, vmOptions, RawCommandLineEditor::getEditorField);
    }

    @NotNull
    public static <T extends JavaRunConfigurationBase> SettingsEditorFragment<T, VmOptionsEditor> vmOptionsEx(JavaRunConfigurationBase settings, final Computable<Boolean> hasModule, final @Nullable JrePathEditor pathEditor) {
        String group = ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]);
        VmOptionsEditor vmOptions = new VmOptionsEditor(settings){

            @Override
            void setupEditor(final LanguageTextField editor, JavaRunConfigurationBase settings) {
                super.setupEditor(editor, settings);
                editor.addSettingsProvider(e -> {
                    ExtendableTextComponent.Extension extension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineVariables, (Icon)AllIcons.General.InlineVariablesHover, (String)ExecutionBundle.message((String)"insert.macros", (Object[])new Object[0]), (boolean)true, () -> MacrosDialog.show((EditorTextField)editor, (Predicate)MacrosDialog.Filters.ALL, (Map)MacrosDialog.getPathMacros((boolean)((Boolean)hasModule.compute()))));
                    ExtendableEditorSupport.setupExtension((EditorEx)e, (Color)editor.getBackground(), (ExtendableTextComponent.Extension)extension);
                });
                if (pathEditor != null) {
                    pathEditor.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Sdk sdk;
                            String jrePath = pathEditor.getJrePathOrName();
                            Sdk sdk2 = sdk = jrePath == null ? null : ProjectJdkTable.getInstance().findJdk(jrePath);
                            if (sdk != null) {
                                jrePath = sdk.getHomePath();
                            }
                            editor.getDocument().putUserData(EditCustomVmOptionsAction.JRE_PATH_KEY, (Object)jrePath);
                        }
                    });
                }
            }
        };
        return CommonJavaFragments.createVmOptionsFragment(group, vmOptions, VmOptionsEditor::getTextField);
    }

    @NotNull
    private static <T extends JavaRunConfigurationBase, E extends JComponent, C extends JComponent> SettingsEditorFragment<T, E> createVmOptionsFragment(@NotNull @Nls String group, @NotNull E vmOptions, @NotNull Function<E, C> textAccessorGetter) {
        if (group == null) {
            CommonJavaFragments.$$$reportNull$$$0(4);
        }
        if (vmOptions == null) {
            CommonJavaFragments.$$$reportNull$$$0(5);
        }
        if (textAccessorGetter == null) {
            CommonJavaFragments.$$$reportNull$$$0(6);
        }
        SettingsEditorFragment vmParameters = new SettingsEditorFragment("vmParameters", ExecutionBundle.message((String)"run.configuration.java.vm.parameters.name", (Object[])new Object[0]), group, vmOptions, 15, (configuration, c) -> ((TextAccessor)((JComponent)textAccessorGetter.apply(c))).setText(configuration.getVMParameters()), (configuration, c) -> configuration.setVMParameters(c.isVisible() ? ((TextAccessor)((JComponent)textAccessorGetter.apply(c))).getText() : null), configuration -> StringUtil.isNotEmpty((String)configuration.getVMParameters()));
        vmParameters.setHint(ExecutionBundle.message((String)"run.configuration.java.vm.parameters.hint", (Object[])new Object[0]));
        vmParameters.setActionHint(ExecutionBundle.message((String)"specify.vm.options.for.running.the.application", (Object[])new Object[0]));
        vmParameters.setEditorGetter(textAccessorGetter);
        SettingsEditorFragment settingsEditorFragment = vmParameters;
        if (settingsEditorFragment == null) {
            CommonJavaFragments.$$$reportNull$$$0(7);
        }
        return settingsEditorFragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jrePathEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/CommonJavaFragments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAccessorGetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/CommonJavaFragments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createJrePathEditorFragment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createVmOptionsFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasTask";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createJrePathEditorFragment";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createVmOptionsFragment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

