/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModulesCombo;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleClasspathCombo
extends ComboBox<Item>
implements ModulesCombo {
    private final Item[] myOptionItems;
    private boolean myPreventPopupClosing;
    @Nullable
    @Nls
    private String myNoModule;
    private static final Item mySeparator = new Item((String)null);

    public ModuleClasspathCombo(Item ... optionItems) {
        this.myOptionItems = optionItems;
        this.setRenderer((ListCellRenderer)((Object)new ListRenderer()));
        this.setSwingPopup(false);
        ComboboxSpeedSearch.installSpeedSearch((JComboBox)((Object)this), item -> item.myModule == null ? "" : item.myModule.getName());
    }

    public void setPopupVisible(boolean visible) {
        if (visible || !this.myPreventPopupClosing) {
            super.setPopupVisible(visible);
        }
        this.myPreventPopupClosing = false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void buildModel(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            ModuleClasspathCombo.$$$reportNull$$$0(0);
        }
        @NotNull List items = ContainerUtil.sorted((Collection)ContainerUtil.map(modules, Item::new), Comparator.comparing(o -> o.myModule.getName()));
        ModelWithOptions model = new ModelWithOptions();
        model.add(items);
        if (this.myNoModule != null) {
            model.add(null);
        }
        if (this.myOptionItems.length > 0) {
            model.add(mySeparator);
        }
        model.add(Arrays.asList(this.myOptionItems));
        this.setModel((ComboBoxModel)((Object)model));
    }

    private static boolean isModuleAccepted(Module module) {
        return ModuleTypeManager.getInstance().isClasspathProvider(ModuleType.get((Module)module));
    }

    public void reset(ModuleBasedConfiguration<?, ?> configuration) {
        Object[] all = ModuleManager.getInstance((Project)configuration.getProject()).getModules();
        this.buildModel(ContainerUtil.filter((Object[])all, ModuleClasspathCombo::isModuleAccepted));
        this.setSelectedModule(configuration.getConfigurationModule().getModule());
    }

    public void applyTo(ModuleBasedConfiguration<?, ?> configuration) {
        configuration.setModule(this.getSelectedModule());
    }

    @Nullable
    public Module getSelectedModule() {
        Item item = (Item)this.getSelectedItem();
        return item != null ? item.myModule : null;
    }

    public void setSelectedModule(Module module) {
        List items = ((CollectionComboBoxModel)super.getModel()).getItems();
        this.setSelectedItem(ContainerUtil.find((Iterable)items, item -> item != null && module == item.myModule));
    }

    public void setModules(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            ModuleClasspathCombo.$$$reportNull$$$0(1);
        }
        this.buildModel(modules);
    }

    public void allowEmptySelection(@NotNull String noModuleText) {
        if (noModuleText == null) {
            ModuleClasspathCombo.$$$reportNull$$$0(2);
        }
        this.myNoModule = noModuleText;
    }

    public String getSelectedModuleName() {
        Module module = this.getSelectedModule();
        return module == null ? null : module.getName();
    }

    public void setSelectedModule(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            ModuleClasspathCombo.$$$reportNull$$$0(3);
        }
        if (name == null) {
            ModuleClasspathCombo.$$$reportNull$$$0(4);
        }
        List items = ((CollectionComboBoxModel)super.getModel()).getItems();
        Item selectedItem = (Item)ContainerUtil.find((Iterable)items, item -> item.myModule != null && item.myModule.getName().equals(name));
        this.setSelectedItem(selectedItem);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noModuleText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/ModuleClasspathCombo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "allowEmptySelection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Item {
        private Module myModule;
        @NlsSafe
        private String myOptionName;
        public boolean myOptionValue;

        public Item(Module module) {
            this.myModule = module;
        }

        public Item(String optionName) {
            this.myOptionName = optionName;
        }
    }

    private class ListRenderer
    extends ColoredListCellRenderer<Item> {
        private final JCheckBox myCheckBox = new JBCheckBox();

        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends Item> list, Item value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == mySeparator) {
                JPanel pane = new JPanel(new GridBagLayout());
                pane.setOpaque(false);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                pane.add((Component)new JSeparator(), gbc);
                return pane;
            }
            if (value != null && value.myOptionName != null) {
                this.myCheckBox.setOpaque(false);
                this.myCheckBox.setText(value.myOptionName);
                this.myCheckBox.setSelected(value.myOptionValue);
                return this.myCheckBox;
            }
            return super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Item> list, Item value, int index, boolean selected, boolean hasFocus) {
            String name;
            if (list == null) {
                ListRenderer.$$$reportNull$$$0(0);
            }
            String string = name = value == null || value.myModule == null ? ModuleClasspathCombo.this.myNoModule : value.myModule.getName();
            if (index == -1 && name != null) {
                this.append("-cp ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            this.append(StringUtil.notNullize((String)name));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/ModuleClasspathCombo$ListRenderer", "customizeCellRenderer"));
        }
    }

    private class ModelWithOptions
    extends CollectionComboBoxModel<Item> {
        private ModelWithOptions() {
        }

        public void setSelectedItem(@Nullable Object o) {
            Item item = (Item)o;
            if (item == null || item.myModule != null) {
                ModuleClasspathCombo.this.myPreventPopupClosing = false;
                super.setSelectedItem((Object)item);
            } else {
                item.myOptionValue = !item.myOptionValue;
                ModuleClasspathCombo.this.myPreventPopupClosing = true;
                this.update();
            }
        }
    }
}

