/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SuiteEntry;
import com.intellij.testIntegration.TestEntryVisitor;
import com.intellij.testIntegration.TestLocator;
import org.jetbrains.annotations.NotNull;

class RecentTestRunnerImpl
implements RecentTestRunner {
    private static final AnAction RUN = ActionManager.getInstance().getAction("RunClass");
    private static final AnAction DEBUG = ActionManager.getInstance().getAction("DebugClass");
    private final TestLocator myTestLocator;
    protected AnAction myCurrentAction = RUN;

    @Override
    public void setMode(RecentTestRunner.Mode mode) {
        this.myCurrentAction = switch (mode) {
            default -> throw new MatchException(null, null);
            case RecentTestRunner.Mode.RUN -> RUN;
            case RecentTestRunner.Mode.DEBUG -> DEBUG;
        };
    }

    RecentTestRunnerImpl(TestLocator testLocator) {
        this.myTestLocator = testLocator;
    }

    @Override
    public void run(RecentTestsPopupEntry entry) {
        entry.accept(new TestEntryVisitor(){

            @Override
            public void visitTest(@NotNull SingleTestEntry test) {
                if (test == null) {
                    1.$$$reportNull$$$0(0);
                }
                RecentTestRunnerImpl.this.run(test.getUrl());
            }

            @Override
            public void visitSuite(@NotNull SuiteEntry suite) {
                if (suite == null) {
                    1.$$$reportNull$$$0(1);
                }
                RecentTestRunnerImpl.this.run(suite.getSuiteUrl());
            }

            @Override
            public void visitRunConfiguration(@NotNull RunConfigurationEntry configuration) {
                if (configuration == null) {
                    1.$$$reportNull$$$0(2);
                }
                RecentTestRunnerImpl.this.run(configuration.getRunSettings());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "test";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suite";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configuration";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testIntegration/RecentTestRunnerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTest";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSuite";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRunConfiguration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void run(RunnerAndConfigurationSettings configuration) {
        Executor executor = this.myCurrentAction == RUN ? DefaultRunExecutor.getRunExecutorInstance() : DefaultDebugExecutor.getDebugExecutorInstance();
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
    }

    private void run(@NotNull String url) {
        Location location;
        if (url == null) {
            RecentTestRunnerImpl.$$$reportNull$$$0(0);
        }
        if ((location = this.myTestLocator.getLocation(url)) == null) {
            return;
        }
        DataContext context = SimpleDataContext.getSimpleContext((DataKey)Location.DATA_KEY, (Object)location);
        this.myCurrentAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)this.myCurrentAction, null, (String)"", (DataContext)context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/testIntegration/RecentTestRunnerImpl", "run"));
    }
}

