/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.TestStateStorage;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.testIntegration.DeadTestsCleaner;
import com.intellij.testIntegration.RecentTestRunnerImpl;
import com.intellij.testIntegration.RecentTestsListPopup;
import com.intellij.testIntegration.RecentTestsListProvider;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationByRecordProvider;
import com.intellij.testIntegration.SelectTestStep;
import com.intellij.testIntegration.TestLocator;
import com.intellij.testIntegration.UrlsCollector;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ShowRecentTests
extends AnAction {
    private static final int TEST_LIMIT = Integer.MAX_VALUE;
    private static final String ID = "show.recent.tests.action";

    private static Date getSinceDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowRecentTests.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowRecentTests.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowRecentTests.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        TestStateStorage testStorage = TestStateStorage.getInstance((Project)project);
        TestLocator testLocator = new TestLocator(project);
        RecentTestRunnerImpl testRunner = new RecentTestRunnerImpl(testLocator);
        Map records = testStorage.getRecentTests(Integer.MAX_VALUE, ShowRecentTests.getSinceDate());
        RunConfigurationByRecordProvider configurationProvider = new RunConfigurationByRecordProvider(project);
        RecentTestsListProvider listProvider = new RecentTestsListProvider(configurationProvider, records);
        List<RecentTestsPopupEntry> entries = listProvider.getTestsToShow();
        SelectTestStep selectStepTest = new SelectTestStep(JavaBundle.message((String)"popup.title.debug.recent.tests", (Object[])new Object[0]), entries, testRunner);
        RecentTestsListPopup popup = new RecentTestsListPopup(project, (ListPopupStep<RecentTestsPopupEntry>)selectStepTest, testRunner, testLocator);
        popup.showCenteredInCurrentWindow(project);
        ShowRecentTests.cleanDeadTests(entries, testLocator, testStorage);
    }

    private static void cleanDeadTests(List<RecentTestsPopupEntry> entries, TestLocator testLocator, TestStateStorage testStorage) {
        UrlsCollector collector = new UrlsCollector();
        entries.forEach(e -> e.accept(collector));
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new DeadTestsCleaner(testStorage, collector.getUrls(), testLocator));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/ShowRecentTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/ShowRecentTests";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

