/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;
import org.jetbrains.lang.manifest.psi.Section;

public final class MissingFinalNewlineInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String text;
        if (file == null) {
            MissingFinalNewlineInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MissingFinalNewlineInspection.$$$reportNull$$$0(1);
        }
        if (file instanceof ManifestFile && (text = file.getText()) != null && !text.isEmpty() && !StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
            List<Section> sections = ((ManifestFile)file).getSections();
            assert (!sections.isEmpty()) : text;
            Section section = sections.getLast();
            AddNewlineQuickFix action = new AddNewlineQuickFix(section);
            ProblemDescriptor descriptor = manager.createProblemDescriptor(section.getLastChild(), ManifestBundle.message("inspection.newline.message", new Object[0]), LocalQuickFix.from((ModCommandAction)action), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AddNewlineQuickFix
    extends PsiUpdateModCommandAction<Section> {
        private AddNewlineQuickFix(Section section) {
            super((PsiElement)section);
        }

        @NotNull
        public String getFamilyName() {
            String string = ManifestBundle.message("inspection.newline.fix", new Object[0]);
            if (string == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Section section, @NotNull ModPsiUpdater updater) {
            PsiElement lastChild;
            if (context == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(1);
            }
            if (section == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(3);
            }
            if ((lastChild = section.getLastChild()) instanceof Header) {
                lastChild.getNode().addLeaf((IElementType)ManifestTokenType.NEWLINE, (CharSequence)"\n", null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "section";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

