/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.JavaDuplicatesPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.JavaDuplicatesExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ParametrizedDuplicates;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.ExtractedParameter;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDuplicatesMatcher {
    private static final Logger LOG = Logger.getInstance(JavaDuplicatesMatcher.class);
    private final PsiElement[] myPattern;
    private final List<PsiElement[]> myCandidates;
    private List<Match> myMatches;

    public JavaDuplicatesMatcher(PsiElement[] pattern, List<PsiElement[]> candidates) {
        this.myPattern = pattern;
        this.myCandidates = candidates;
    }

    public boolean compare() {
        if (this.myPattern.length == 0 || !(this.myPattern[0] instanceof PsiStatement)) {
            return false;
        }
        JavaDuplicatesExtractMethodProcessor processor = new JavaDuplicatesExtractMethodProcessor(this.myPattern, JavaDuplicatesPresentation.getRefactoringName());
        if (!processor.prepare(false)) {
            return false;
        }
        Set codeFragments = ((StreamEx)StreamEx.of(this.myCandidates).filter(elements -> ((PsiElement[])elements).length != 0)).map(elements -> ControlFlowUtil.findCodeFragment((PsiElement)elements[0])).toSet();
        DuplicatesFinder duplicatesFinder = processor.createDuplicatesFinder();
        this.myMatches = new ArrayList<Match>();
        for (PsiElement codeFragment : codeFragments) {
            List matches = duplicatesFinder.findDuplicates(codeFragment);
            this.myMatches.addAll(matches);
        }
        PsiFile patternFile = this.myPattern[0].getContainingFile();
        Module patternModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)patternFile);
        this.myMatches.removeIf(match -> {
            PsiFile matchFile = match.getMatchStart().getContainingFile();
            if (matchFile == patternFile) {
                return false;
            }
            if (patternModule != ModuleUtilCore.findModuleForPsiElement((PsiElement)matchFile)) {
                return true;
            }
            return !processor.isCanBeStatic();
        });
        JavaDuplicatesMatcher.mergeDuplicateExtractedParameters(this.myMatches);
        this.myMatches = ExtractedParameter.getCompatibleMatches(this.myMatches, (PsiElement[])this.myPattern, this.myCandidates);
        return !this.myMatches.isEmpty();
    }

    public void extract() {
        Project project = this.myPattern[0].getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement[] elementsInCopy = IntroduceParameterHandler.getElementsInCopy((Project)project, (PsiFile)this.myPattern[0].getContainingFile(), (PsiElement[])this.myPattern);
        PsiCodeBlock blockInCopy = JavaDuplicatesMatcher.wrapWithCodeBlock(elementsInCopy, factory);
        LOG.assertTrue((elementsInCopy = blockInCopy.getChildren()).length > 2, (Object)"block length is too small");
        elementsInCopy = Arrays.copyOfRange(elementsInCopy, 1, elementsInCopy.length - 1);
        Map<PsiVariable, PsiVariable> copyToPatternVariablesMapping = JavaDuplicatesMatcher.collectVariablesMapping(this.myPattern, elementsInCopy);
        JavaDuplicatesExtractMethodProcessor patternProcessor = new JavaDuplicatesExtractMethodProcessor(this.myPattern, JavaDuplicatesPresentation.getRefactoringName());
        if (!patternProcessor.prepare(true)) {
            return;
        }
        Map<PsiLocalVariable, ExtractedParameter> parameterDeclarations = this.createParameterDeclarations(elementsInCopy, blockInCopy, patternProcessor, project);
        parameterDeclarations.keySet().forEach(freshlyDeclaredParameter -> copyToPatternVariablesMapping.put((PsiVariable)freshlyDeclaredParameter, (PsiVariable)freshlyDeclaredParameter));
        JavaDuplicatesExtractMethodProcessor copyProcessor = new JavaDuplicatesExtractMethodProcessor(elementsInCopy, JavaDuplicatesPresentation.getRefactoringName());
        if (!copyProcessor.prepare(true)) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            copyProcessor.applyDefaults("newMethod", "private");
        } else if (!copyProcessor.showDialog()) {
            return;
        }
        patternProcessor.applyFrom((ExtractMethodProcessor)copyProcessor, copyToPatternVariablesMapping);
        patternProcessor.putExtractedParameters(parameterDeclarations);
        WriteAction.run(() -> {
            for (Map.Entry entry : parameterDeclarations.entrySet()) {
                PsiLocalVariable localVariable = (PsiLocalVariable)entry.getKey();
                String name = localVariable.getName();
                Set usages = ((ExtractedParameter)entry.getValue()).myPatternUsages;
                for (PsiExpression usage : usages) {
                    usage.replace((PsiElement)factory.createExpressionFromText(name, (PsiElement)usage));
                }
            }
            patternProcessor.doExtract();
            patternProcessor.updateStaticModifier(this.myMatches);
            HashMap<PsiExpression, PsiLocalVariable> patternToParameter = new HashMap<PsiExpression, PsiLocalVariable>();
            for (Map.Entry entry : parameterDeclarations.entrySet()) {
                patternToParameter.put(((ExtractedParameter)entry.getValue()).myPattern.getUsage(), (PsiLocalVariable)entry.getKey());
            }
            for (Match match : this.myMatches) {
                List matchedParameters = match.getExtractedParameters();
                for (ExtractedParameter matchedParameter : matchedParameters) {
                    PsiLocalVariable localVariable = (PsiLocalVariable)patternToParameter.get(matchedParameter.myPattern.getUsage());
                    LOG.assertTrue(localVariable != null, (Object)"match local variable");
                    DuplicatesFinder.Parameter parameter = new DuplicatesFinder.Parameter((PsiVariable)localVariable, matchedParameter.myType);
                    boolean ok = match.putParameter(parameter, (PsiElement)matchedParameter.myCandidate.getUsage());
                    LOG.assertTrue(ok, (Object)"put matched parameter");
                }
                patternProcessor.processMatch(match);
            }
        });
    }

    @Nullable
    public String createCall(@NotNull PsiMethod method, @Nullable PsiLocalVariable variable) {
        if (method == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(0);
        }
        if (this.myMatches.size() != 1) {
            throw new IllegalStateException("Must be one candidate");
        }
        Match match = this.myMatches.get(0);
        if (!match.getExtractedParameters().isEmpty()) {
            return null;
        }
        PsiParameter[] methodParameters = method.getParameterList().getParameters();
        HashMap mapping = new HashMap();
        ParametrizedDuplicates.collectCopyMapping((PsiElement[])this.myPattern, (PsiElement[])match.getMatchElements(), unused -> false, (unused1, unused2) -> {}, (patternVar, copyVar) -> mapping.put(patternVar, copyVar));
        if (ContainerUtil.exists(mapping.keySet(), k -> !PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)k, (boolean)true))) {
            return null;
        }
        String className = Objects.requireNonNull(Objects.requireNonNull(method.getContainingClass()).getQualifiedName());
        ArrayList<String> arguments = new ArrayList<String>();
        for (PsiParameter parameter : methodParameters) {
            String arg;
            PsiVariable target = (PsiVariable)mapping.get(parameter);
            PsiType parameterType = parameter.getType();
            if (target == null) {
                arg = PsiTypesUtil.getDefaultValueOfType((PsiType)parameterType, (boolean)true);
            } else {
                PsiType targetType = target.getType();
                if (!parameterType.isAssignableFrom(targetType)) {
                    return null;
                }
                if (parameterType instanceof PsiPrimitiveType && parameterType.equals(PsiPrimitiveType.getUnboxedType((PsiType)targetType))) {
                    return null;
                }
                arg = target.getName();
            }
            arguments.add(arg);
        }
        String call = className + "." + method.getName() + "(" + String.join((CharSequence)",", arguments) + ")";
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)method.getProject()).createExpressionFromText(call, match.getMatchStart());
        if (!method.isEquivalentTo((PsiElement)callExpression.resolveMethod())) {
            return null;
        }
        if (variable != null) {
            PsiVariable targetVariable = (PsiVariable)mapping.get(variable);
            if (targetVariable == null) {
                return null;
            }
            PsiTypeElement typeElement = targetVariable.getTypeElement();
            if (typeElement == null) {
                return null;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null || !typeElement.getType().isAssignableFrom(returnType)) {
                return null;
            }
            return typeElement.getText() + " " + targetVariable.getName() + "=" + call + ";";
        }
        return (match.getReturnValue() != null ? "return " : "") + call + ";";
    }

    private static Map<PsiVariable, PsiVariable> collectVariablesMapping(PsiElement @NotNull [] pattern, PsiElement @NotNull [] copy) {
        if (pattern == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(1);
        }
        if (copy == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(2);
        }
        HashMap<PsiVariable, PsiVariable> mapping = new HashMap<PsiVariable, PsiVariable>();
        ParametrizedDuplicates.collectCopyMapping((PsiElement[])pattern, (PsiElement[])copy, unused -> false, (unused1, unused2) -> {}, (patternVar, copyVar) -> mapping.put((PsiVariable)copyVar, (PsiVariable)patternVar));
        return mapping;
    }

    @NotNull
    private Map<PsiLocalVariable, ExtractedParameter> createParameterDeclarations(PsiElement[] elementsInCopy, PsiCodeBlock blockInCopy, JavaDuplicatesExtractMethodProcessor processor, Project project) {
        List parameters = this.myMatches.get(0).getExtractedParameters();
        HashMap<PsiLocalVariable, ExtractedParameter> parameterDeclarations = new HashMap<PsiLocalVariable, ExtractedParameter>();
        if (!parameters.isEmpty()) {
            UniqueNameGenerator generator = processor.getParameterNameGenerator(elementsInCopy[0]);
            HashMap<PsiExpression, String> patternUsageReplacements = new HashMap<PsiExpression, String>();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            for (ExtractedParameter parameter : parameters) {
                PsiExpression patternUsage = parameter.myPattern.getUsage();
                String usageText = patternUsage.getText();
                PsiExpression exprInCopy = factory.createExpressionFromText(usageText, (PsiElement)blockInCopy);
                SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.PARAMETER, null, exprInCopy, null);
                String parameterName = generator.generateUniqueName(info.names.length > 0 ? info.names[0] : "p");
                String declarationText = parameter.myType.getCanonicalText() + " " + parameterName + " = " + usageText + ";";
                PsiDeclarationStatement paramDeclaration = (PsiDeclarationStatement)factory.createStatementFromText(declarationText, (PsiElement)blockInCopy);
                paramDeclaration = (PsiDeclarationStatement)blockInCopy.addBefore((PsiElement)paramDeclaration, elementsInCopy[0]);
                PsiLocalVariable localVariable = (PsiLocalVariable)paramDeclaration.getDeclaredElements()[0];
                parameterDeclarations.put(localVariable, parameter);
                for (PsiExpression expression : parameter.myPatternUsages) {
                    patternUsageReplacements.put(expression, parameterName);
                }
            }
            this.replaceUsages(elementsInCopy, patternUsageReplacements, factory);
        }
        HashMap<PsiLocalVariable, ExtractedParameter> hashMap = parameterDeclarations;
        if (hashMap == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    private static PsiCodeBlock wrapWithCodeBlock(PsiElement[] elements, PsiElementFactory factory) {
        PsiElement parent = elements[0].getParent();
        PsiBlockStatement statement = (PsiBlockStatement)factory.createStatementFromText("{}", parent);
        statement.getCodeBlock().addRange(elements[0], elements[elements.length - 1]);
        statement = (PsiBlockStatement)parent.addBefore((PsiElement)statement, elements[0]);
        parent.deleteChildRange(elements[0], elements[elements.length - 1]);
        PsiCodeBlock psiCodeBlock = statement.getCodeBlock();
        if (psiCodeBlock == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(4);
        }
        return psiCodeBlock;
    }

    private void replaceUsages(PsiElement[] elements, Map<PsiExpression, String> patternUsageReplacements, PsiElementFactory factory) {
        HashMap<PsiExpression, String> usagesToReplace = new HashMap<PsiExpression, String>();
        JavaDuplicatesMatcher.collectUsages(elements, this.myPattern, patternUsageReplacements, usagesToReplace);
        for (Map.Entry entry : usagesToReplace.entrySet()) {
            PsiExpression expression = (PsiExpression)entry.getKey();
            String name = (String)entry.getValue();
            PsiExpression replacement = factory.createExpressionFromText(name, (PsiElement)expression);
            expression.replace((PsiElement)replacement);
        }
    }

    private static void collectUsages(PsiElement[] elements, PsiElement[] pattern, Map<PsiExpression, String> patternUsageReplacements, Map<PsiExpression, String> usagesToReplace) {
        LOG.assertTrue((elements = JavaDuplicatesMatcher.skipWhitespacesAndComments(elements)).length == (pattern = JavaDuplicatesMatcher.skipWhitespacesAndComments(pattern)).length, (Object)"length in collectUsages");
        for (int i = 0; i < elements.length; ++i) {
            JavaDuplicatesMatcher.collectUsages(elements[i], pattern[i], patternUsageReplacements, usagesToReplace);
        }
    }

    private static void collectUsages(PsiElement element, PsiElement pattern, Map<PsiExpression, String> patternUsageReplacements, Map<PsiExpression, String> usagesToReplace) {
        String replacementName;
        if (element instanceof PsiExpression && pattern instanceof PsiExpression && (replacementName = patternUsageReplacements.get(pattern)) != null) {
            usagesToReplace.put((PsiExpression)element, replacementName);
            return;
        }
        JavaDuplicatesMatcher.collectUsages(element.getChildren(), pattern.getChildren(), patternUsageReplacements, usagesToReplace);
    }

    private static PsiElement @NotNull [] skipWhitespacesAndComments(PsiElement @NotNull [] pattern) {
        if (pattern == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(5);
        }
        PsiElement[] psiElementArray = DuplicatesFinder.getDeeplyFilteredElements((PsiElement[])pattern);
        if (psiElementArray == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    private static void mergeDuplicateExtractedParameters(@NotNull List<Match> matches) {
        if (matches == null) {
            JavaDuplicatesMatcher.$$$reportNull$$$0(7);
        }
        for (Match match : matches) {
            List extractedParameters = match.getExtractedParameters();
            HashSet<ExtractedParameter> duplicateParameters = new HashSet<ExtractedParameter>();
            for (int i = 0; i < extractedParameters.size(); ++i) {
                ExtractedParameter parameter = (ExtractedParameter)extractedParameters.get(i);
                if (duplicateParameters.contains(parameter)) continue;
                for (int j = i + 1; j < extractedParameters.size(); ++j) {
                    ExtractedParameter otherParameter = (ExtractedParameter)extractedParameters.get(j);
                    if (!parameter.myPattern.isEquivalent(otherParameter.myPattern) || !parameter.myCandidate.isEquivalent(otherParameter.myCandidate)) continue;
                    duplicateParameters.add(otherParameter);
                    parameter.addUsages(otherParameter.myPattern);
                }
            }
            extractedParameters.removeAll(duplicateParameters);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/JavaDuplicatesMatcher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/JavaDuplicatesMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterDeclarations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithCodeBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "skipWhitespacesAndComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCall";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectVariablesMapping";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespacesAndComments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeDuplicateExtractedParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

