/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.extension;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LombokReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public LombokReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor consumer) {
        PsiElement refElement;
        if (queryParameters == null) {
            LombokReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            LombokReferenceSearcher.$$$reportNull$$$0(1);
        }
        if ((refElement = queryParameters.getElementToSearch()) instanceof PsiField) {
            DumbService.getInstance((Project)queryParameters.getProject()).runReadActionInSmartMode(() -> LombokReferenceSearcher.processPsiField((PsiField)refElement, queryParameters.getOptimizer()));
        }
    }

    private static void processPsiField(PsiField refPsiField, SearchRequestCollector collector) {
        PsiClass containingClass = refPsiField.getContainingClass();
        if (null != containingClass) {
            LombokReferenceSearcher.processClassMethods(refPsiField, collector, containingClass);
            PsiClass[] innerClasses = containingClass.getInnerClasses();
            Arrays.stream(innerClasses).forEach(psiClass -> LombokReferenceSearcher.processClassMethods(refPsiField, collector, psiClass));
            Arrays.stream(innerClasses).forEach(psiClass -> LombokReferenceSearcher.processClassFields(refPsiField, collector, psiClass));
        }
    }

    private static void processClassMethods(PsiField refPsiField, SearchRequestCollector collector, PsiClass containingClass) {
        Arrays.stream(containingClass.getMethods()).filter(LombokLightMethodBuilder.class::isInstance).filter(psiMethod -> psiMethod.getNavigationElement() == refPsiField).forEach(psiMethod -> collector.searchWord(psiMethod.getName(), psiMethod.getUseScope(), (short)1, true, (PsiElement)psiMethod));
    }

    private static void processClassFields(PsiField refPsiField, SearchRequestCollector collector, PsiClass containingClass) {
        Arrays.stream(containingClass.getFields()).filter(LombokLightFieldBuilder.class::isInstance).filter(psiField -> psiField.getNavigationElement() == refPsiField).forEach(psiField -> collector.searchWord(psiField.getName(), psiField.getUseScope(), (short)1, true, (PsiElement)psiField));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "de/plushnikov/intellij/plugin/extension/LombokReferenceSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

