/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogGraphData;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.IndexSpeedSearch;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.Component;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class VcsLogMainGraphTable
extends VcsLogGraphTable {
    @NotNull
    private final Runnable myRefresh;
    @NotNull
    private final VcsLogFilterUiEx myFilterUi;

    VcsLogMainGraphTable(@NotNull String logId, @NotNull GraphTableModel graphTableModel, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @NotNull Runnable refresh, @NotNull VcsLogFilterUiEx filterUi, @NotNull @NotNull Consumer<@NotNull String> commitByHashNavigator, @NotNull Disposable disposable2) {
        if (logId == null) {
            VcsLogMainGraphTable.$$$reportNull$$$0(0);
        }
        if (graphTableModel == null) {
            VcsLogMainGraphTable.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogMainGraphTable.$$$reportNull$$$0(2);
        }
        if (colorManager == null) {
            VcsLogMainGraphTable.$$$reportNull$$$0(3);
        }
        if (refresh == null) {
            VcsLogMainGraphTable.$$$reportNull$$$0(4);
        }
        if (filterUi == null) {
            VcsLogMainGraphTable.$$$reportNull$$$0(5);
        }
        if (commitByHashNavigator == null) {
            VcsLogMainGraphTable.$$$reportNull$$$0(6);
        }
        if (disposable2 == null) {
            VcsLogMainGraphTable.$$$reportNull$$$0(7);
        }
        super(logId, graphTableModel, uiProperties, colorManager, commitByHashNavigator, disposable2);
        this.myRefresh = refresh;
        this.myFilterUi = filterUi;
        IndexSpeedSearch speedSearch = new IndexSpeedSearch(this, this.getLogData().getProject(), this.getLogData().getIndex(), this.getLogData().getStorage(), this){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return Registry.is((String)"vcs.log.speedsearch") && super.isSpeedSearchEnabled();
            }
        };
        speedSearch.setupListeners();
    }

    @Override
    protected void updateEmptyText() {
        StatusText statusText2 = this.getEmptyText();
        VisiblePack visiblePack = this.getModel().getVisiblePack();
        VcsLogGraphData dataPack = visiblePack.getDataPack();
        if (dataPack instanceof VcsLogGraphData.Error) {
            VcsLogGraphData.Error error = (VcsLogGraphData.Error)dataPack;
            this.setErrorEmptyText(error.getError(), VcsLogBundle.message("vcs.log.error.loading.commits.status", new Object[0]));
            this.appendActionToEmptyText(VcsLogBundle.message("vcs.log.refresh.status.action", new Object[0]), () -> this.getLogData().refresh(this.getLogData().getLogProviders().keySet()));
        } else if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
            this.setErrorEmptyText(((VisiblePack.ErrorVisiblePack)visiblePack).getError(), VcsLogBundle.message("vcs.log.error.filtering.status", new Object[0]));
            if (visiblePack.getFilters().isEmpty()) {
                this.appendActionToEmptyText(VcsLogBundle.message("vcs.log.refresh.status.action", new Object[0]), this.myRefresh);
            } else {
                VcsLogUiUtil.appendResetFiltersActionToEmptyText(this.myFilterUi, this.getEmptyText());
            }
        } else if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
            if (visiblePack.getFilters().isEmpty()) {
                statusText2.setText(VcsLogBundle.message("vcs.log.no.commits.status", new Object[0])).appendSecondaryText(VcsLogBundle.message("vcs.log.commit.status.action", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, ActionUtil.createActionListener((String)"CheckinProject", (Component)((Object)this), (String)"unknown"));
                String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"CheckinProject");
                if (!shortcutText.isEmpty()) {
                    statusText2.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
                }
            } else {
                this.myFilterUi.setCustomEmptyText(this.getEmptyText());
            }
        } else {
            statusText2.setText(VcsLogBundle.message("vcs.log.default.status", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "logId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "graphTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "colorManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "refresh";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "filterUi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "commitByHashNavigator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/ui/frame/VcsLogMainGraphTable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

