/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambdaConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaPredicatesUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuavaPredicateConversionRule
extends GuavaLambdaConversionRule {
    private static final String GUAVA_PREDICATES_UTILITY = "com.google.common.base.Predicates";

    private GuavaPredicateConversionRule() {
        super(GuavaLambda.PREDICATE);
    }

    @Override
    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        Set<String> set = Collections.singleton(GUAVA_PREDICATES_UTILITY);
        if (set == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        TypeConversionDescriptorBase descriptor;
        if (method == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(2);
        }
        if (!(context instanceof PsiMethodCallExpression)) {
            return null;
        }
        if (GuavaPredicateConversionRule.isPredicates((PsiMethodCallExpression)context) && (descriptor = GuavaPredicatesUtil.tryConvertIfPredicates(method, context)) != null) {
            return descriptor;
        }
        return new TypeConversionDescriptorBase(this){

            public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                if (evaluator == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiExpression methodReference = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::test", (PsiElement)expression);
                return (PsiExpression)expression.replace((PsiElement)methodReference);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule$1", "replace"));
            }
        };
    }

    public static boolean isPredicates(PsiMethodCallExpression expression) {
        String methodName = expression.getMethodExpression().getReferenceName();
        if (GuavaPredicatesUtil.PREDICATES_METHOD_NAMES.contains(methodName)) {
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass != null && GUAVA_PREDICATES_UTILITY.equals(aClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEnclosingCallAPredicate(@NotNull PsiMethodCallExpression enclosingMethodCallExpression) {
        if (enclosingMethodCallExpression == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(3);
        }
        return GuavaPredicateConversionRule.isPredicates(enclosingMethodCallExpression);
    }

    private static int getExpressionPosition(@NotNull PsiExpressionList expressionList, @NotNull PsiExpression expression) {
        if (expressionList == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(5);
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            if (!expressions[i].equals((Object)expression)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isPredicateConvertibleInsideEnclosingMethod(@NotNull PsiMethodCallExpression innerMethodCallExpression, @NotNull PsiMethodCallExpression enclosingMethodCallExpression) {
        PsiExpressionList expressionList;
        if (innerMethodCallExpression == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(6);
        }
        if (enclosingMethodCallExpression == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(7);
        }
        if ((expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)innerMethodCallExpression, PsiExpressionList.class)) == null) {
            return false;
        }
        PsiMethod enclosingMethod = enclosingMethodCallExpression.resolveMethod();
        if (enclosingMethod == null) {
            return false;
        }
        PsiClass aClass = enclosingMethod.getContainingClass();
        if (aClass == null) {
            return false;
        }
        int position = GuavaPredicateConversionRule.getExpressionPosition(expressionList, (PsiExpression)innerMethodCallExpression);
        return Arrays.stream(aClass.findMethodsByName(enclosingMethod.getName(), true)).filter(method -> PsiUtil.isMemberAccessibleAt((PsiMember)method, (PsiElement)innerMethodCallExpression)).anyMatch(method -> GuavaPredicateConversionRule.areExpressionsConvertibleToMethodParameters(expressionList.getExpressionTypes(), method.getParameterList().getParameters(), position));
    }

    private static boolean areExpressionsConvertibleToMethodParameters(PsiType[] expressionTypes, PsiParameter[] parameters, int predicateExpressionPosition) {
        if (parameters.length == 0 || parameters.length > expressionTypes.length && !parameters[expressionTypes.length].isVarArgs()) {
            return false;
        }
        boolean isJavaPredicatePresented = false;
        int parametersLastIndex = parameters.length - 1;
        for (int expressionTypeIndex = 0; expressionTypeIndex < expressionTypes.length; ++expressionTypeIndex) {
            String qualifiedClassName;
            PsiType parameterType;
            if (expressionTypeIndex < parameters.length) {
                parameterType = parameters[expressionTypeIndex].isVarArgs() ? ((PsiArrayType)parameters[expressionTypeIndex].getType()).getComponentType() : parameters[expressionTypeIndex].getType();
            } else {
                if (!parameters[parametersLastIndex].isVarArgs()) {
                    return false;
                }
                parameterType = ((PsiArrayType)parameters[parametersLastIndex].getType()).getComponentType();
            }
            if (!parameterType.isConvertibleFrom(expressionTypes[expressionTypeIndex])) {
                return false;
            }
            PsiClass parameterClass = PsiTypesUtil.getPsiClass((PsiType)parameterType);
            if (parameterClass == null || (qualifiedClassName = parameterClass.getQualifiedName()) == null || expressionTypeIndex != predicateExpressionPosition || !qualifiedClassName.equals("java.util.function.Predicate")) continue;
            isJavaPredicatePresented = true;
        }
        return isJavaPredicatePresented;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingMethodCallExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerMethodCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUtilityClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findConversionForMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnclosingCallAPredicate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionPosition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPredicateConvertibleInsideEnclosingMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

