/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;
import org.jetbrains.ide.RestServiceKt;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "<init>", "()V", "FILE_HANDLER_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "process", "", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectName", "authHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "isCustomHost", "checkAccess", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Ljava/nio/file/Path;", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultWebServerPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultWebServerPathHandler.kt\norg/jetbrains/builtInWebServer/DefaultWebServerPathHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n1#2:124\n82#3,3:125\n*S KotlinDebug\n*F\n+ 1 DefaultWebServerPathHandler.kt\norg/jetbrains/builtInWebServer/DefaultWebServerPathHandler\n*L\n97#1:125,3\n*E\n"})
public final class DefaultWebServerPathHandler
implements WebServerPathHandler {
    @NotNull
    private final ExtensionPointName<WebServerFileHandler> FILE_HANDLER_EP_NAME = new ExtensionPointName("org.jetbrains.webServerFileHandler");

    @Override
    public boolean process(@NotNull String path, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @NotNull String projectName, @NotNull HttpHeaders authHeaders, boolean isCustomHost) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)authHeaders, (String)"authHeaders");
        Channel channel = context.channel();
        String decodedRawPath = new QueryStringDecoder(request.uri()).path();
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        Object pathInfo = null;
        pathInfo = pathToFileManager.getPathToInfoCache$intellij_platform_builtInServer_impl().getIfPresent((Object)path);
        if (pathInfo == null || !((PathInfo)pathInfo).isValid()) {
            pathInfo = pathToFileManager.doFindByRelativePath$intellij_platform_builtInServer_impl(path, WebServerPathToFileManagerKt.getDefaultPathQuery());
            if (pathInfo == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                Intrinsics.checkNotNull((Object)channel);
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)authHeaders, (int)4, null);
                return true;
            }
            pathToFileManager.getPathToInfoCache$intellij_platform_builtInServer_impl().put((Object)path, pathInfo);
        }
        boolean indexUsed = false;
        if (((PathInfo)pathInfo).isDirectory()) {
            VirtualFile indexVirtualFile = null;
            Path indexFile = null;
            if (((PathInfo)pathInfo).getFile() == null) {
                Path path2 = ((PathInfo)pathInfo).getIoFile();
                Intrinsics.checkNotNull((Object)path2);
                indexFile = BuiltInWebServerKt.findIndexFile(path2);
            } else {
                VirtualFile virtualFile = ((PathInfo)pathInfo).getFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                indexVirtualFile = BuiltInWebServerKt.findIndexFile(virtualFile);
            }
            if (indexFile == null && indexVirtualFile == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                Intrinsics.checkNotNull((Object)channel);
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)authHeaders, (int)4, null);
                return true;
            }
            Intrinsics.checkNotNull((Object)decodedRawPath);
            if (!StringsKt.endsWith$default((CharSequence)decodedRawPath, (char)'/', (boolean)false, (int)2, null)) {
                HttpRequest httpRequest = (HttpRequest)request;
                Intrinsics.checkNotNull((Object)channel);
                BuiltInWebServerKt.redirectToDirectory(httpRequest, channel, authHeaders);
                return true;
            }
            indexUsed = true;
            pathInfo = new PathInfo(indexFile, indexVirtualFile, ((PathInfo)pathInfo).getRoot(), ((PathInfo)pathInfo).getModuleName(), ((PathInfo)pathInfo).isLibrary(), false, 32, null);
            pathToFileManager.getPathToInfoCache$intellij_platform_builtInServer_impl().put((Object)path, pathInfo);
        }
        if (!indexUsed && !FileUtilKt.endsWithName((String)path, (String)((PathInfo)pathInfo).getName())) {
            Intrinsics.checkNotNull((Object)decodedRawPath);
            if (StringsKt.endsWith$default((CharSequence)decodedRawPath, (char)'/', (boolean)false, (int)2, null)) {
                indexUsed = true;
            } else {
                Object parentPath;
                Object object;
                Object it = object = PathUtilRt.getParentPath((String)((PathInfo)pathInfo).getPath());
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Object object2 = parentPath = ((CharSequence)it).length() > 0 ? object : null;
                if (parentPath != null) {
                    String string = PathUtilRt.getFileName((String)parentPath);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                    if (FileUtilKt.endsWithName((String)path, (String)string)) {
                        HttpRequest httpRequest = (HttpRequest)request;
                        Intrinsics.checkNotNull((Object)channel);
                        BuiltInWebServerKt.redirectToDirectory(httpRequest, channel, authHeaders);
                        return true;
                    }
                }
            }
        }
        if (!this.checkAccess((PathInfo)pathInfo, project)) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.FORBIDDEN;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"FORBIDDEN");
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus2, (String)"NOT_FOUND");
            HttpResponseStatus httpResponseStatus3 = RestServiceKt.orInSafeMode(httpResponseStatus, httpResponseStatus2);
            Intrinsics.checkNotNull((Object)channel);
            Responses.send$default((HttpResponseStatus)httpResponseStatus3, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)authHeaders, (int)4, null);
            return true;
        }
        String canonicalPath = indexUsed ? path + "/" + ((PathInfo)pathInfo).getName() : path;
        for (WebServerFileHandler fileHandler : this.FILE_HANDLER_EP_NAME.getExtensionList()) {
            Object object;
            Logger $this$runAndLogException$iv = BuiltInWebServerKt.getLOG();
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl2 = false;
                PathInfo pathInfo2 = (PathInfo)pathInfo;
                CharSequence charSequence = canonicalPath;
                Intrinsics.checkNotNull((Object)channel);
                if (fileHandler.process(pathInfo2, charSequence, project, request, channel, isCustomHost ? null : projectName, authHeaders)) {
                    return true;
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
        return false;
    }

    private final boolean checkAccess(PathInfo pathInfo, Project project) {
        boolean bl;
        if (pathInfo.getIoFile() != null) {
            Path path = pathInfo.getIoFile();
            Intrinsics.checkNotNull((Object)path);
            bl = this.checkAccess(path, project);
        } else {
            VirtualFile virtualFile = pathInfo.getFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            if (virtualFile.isInLocalFileSystem()) {
                VirtualFile virtualFile2 = pathInfo.getFile();
                Intrinsics.checkNotNull((Object)virtualFile2);
                Path path = virtualFile2.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                bl = this.checkAccess(path, project);
            } else {
                VirtualFile virtualFile3 = pathInfo.getFile();
                Intrinsics.checkNotNull((Object)virtualFile3);
                bl = !virtualFile3.is(VFileProperty.HIDDEN);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkAccess(Path file, Project project) {
        Object object;
        if (DefaultWebServerPathHandlerKt.hasAccess(file)) {
            if (TrustedProjects.isProjectTrusted((Project)project)) return true;
        }
        Object object2 = this;
        try {
            DefaultWebServerPathHandler $this$checkAccess_u24lambda_u240 = object2;
            boolean bl = false;
            Path path = file.toRealPath(new LinkOption[0]);
            String string = project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            object = Result.constructor-impl((Object)path.startsWith(string));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        if ((Boolean)(Result.isFailure-impl((Object)object2) ? object : object2) == false) return false;
        return true;
    }
}

