/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandLineState
implements RunProfileState {
    private TextConsoleBuilder myConsoleBuilder;
    private final ExecutionEnvironment myEnvironment;

    protected CommandLineState(ExecutionEnvironment environment) {
        this.myEnvironment = environment;
        if (this.myEnvironment != null) {
            Project project = this.myEnvironment.getProject();
            GlobalSearchScope searchScope = ExecutionSearchScopes.executionScope(project, this.myEnvironment.getRunProfile());
            this.myConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project, searchScope);
        }
    }

    public ExecutionEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    @Nullable
    public RunnerSettings getRunnerSettings() {
        return this.myEnvironment.getRunnerSettings();
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myEnvironment.getExecutionTarget();
        if (executionTarget == null) {
            CommandLineState.$$$reportNull$$$0(0);
        }
        return executionTarget;
    }

    public void addConsoleFilters(Filter ... filters) {
        this.myConsoleBuilder.filters(filters);
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            CommandLineState.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            CommandLineState.$$$reportNull$$$0(2);
        }
        ProcessHandler processHandler2 = this.startProcess();
        ConsoleView console = this.createConsole(executor);
        if (console != null) {
            console.attachToProcess(processHandler2);
        }
        return new DefaultExecutionResult(console, processHandler2, this.createActions(console, processHandler2, executor));
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        TextConsoleBuilder builder;
        if (executor == null) {
            CommandLineState.$$$reportNull$$$0(3);
        }
        return (builder = this.getConsoleBuilder()) != null ? builder.getConsole() : null;
    }

    @NotNull
    protected abstract ProcessHandler startProcess() throws ExecutionException;

    protected AnAction @NotNull [] createActions(ConsoleView console, ProcessHandler processHandler2) {
        AnAction[] anActionArray = this.createActions(console, processHandler2, null);
        if (anActionArray == null) {
            CommandLineState.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    protected AnAction @NotNull [] createActions(ConsoleView console, ProcessHandler processHandler2, Executor executor) {
        if (AnAction.EMPTY_ARRAY == null) {
            CommandLineState.$$$reportNull$$$0(5);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public TextConsoleBuilder getConsoleBuilder() {
        return this.myConsoleBuilder;
    }

    public void setConsoleBuilder(TextConsoleBuilder consoleBuilder) {
        this.myConsoleBuilder = consoleBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/CommandLineState";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/CommandLineState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

