/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksViewFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "<init>", "()V", "orientation", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "stateChanged", "manager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nBookmarksViewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksViewFactory.kt\ncom/intellij/ide/bookmark/ui/BookmarksViewFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class BookmarksViewFactory
implements DumbAware,
ToolWindowFactory,
ToolWindowManagerListener {
    @NotNull
    private final AtomicBoolean orientation = new AtomicBoolean(true);

    /*
     * WARNING - void declaration
     */
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        void $this$createToolWindowContent_u24lambda_u241;
        BookmarksView bookmarksView;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager manager = contentManager;
        BookmarksView it = bookmarksView = new BookmarksView(project, ToggleToolbarAction.isToolbarVisible((ToolWindow)toolWindow, (Project)project));
        boolean bl = false;
        it.setOrientation(this.orientation.get());
        BookmarksView panel2 = bookmarksView;
        it = bookmarksView = manager.getFactory().createContent((JComponent)((Object)panel2), null, false);
        ContentManager contentManager2 = manager;
        boolean bl2 = false;
        $this$createToolWindowContent_u24lambda_u241.setCloseable(false);
        contentManager2.addContent((Content)bookmarksView);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)manager);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
        toolWindow.setHelpId("bookmarks.tool.window.help");
        toolWindow.setTitleActions(CollectionsKt.listOfNotNull((Object)ActionUtil.getAction((String)"Bookmarks.ToolWindow.TitleActions")));
        if (toolWindow instanceof ToolWindowEx) {
            toolWindow.setAdditionalGearActions(ActionUtil.getActionGroup((String)"Bookmarks.ToolWindow.GearActions"));
        }
    }

    public void stateChanged(@NotNull ToolWindowManager manager) {
        boolean vertical;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ToolWindow toolWindow = manager.getToolWindow("Bookmarks");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window = toolWindow;
        if (window.isDisposed()) {
            return;
        }
        boolean bl = vertical = !window.getAnchor().isHorizontal();
        if (vertical != this.orientation.getAndSet(vertical)) {
            Content[] contentArray = window.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Content[] contentArray2 = contentArray;
            int n = contentArray2.length;
            for (int i = 0; i < n; ++i) {
                Splittable splittable;
                Content content;
                Content content2 = content = contentArray2[i];
                JComponent jComponent = content2 != null ? content2.getComponent() : null;
                Splittable splittable2 = splittable = jComponent instanceof Splittable ? (Splittable)jComponent : null;
                if (splittable2 == null) continue;
                splittable2.setOrientation(vertical);
            }
        }
    }
}

