/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.AppFontOptions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@State(name="ConsoleFont", storages={@Storage(value="console-font.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.UI)
@ApiStatus.Internal
public final class AppConsoleFontOptions
extends AppFontOptions<ConsoleFontState> {
    private FontPreferences myDelegatingPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());

    public static AppConsoleFontOptions getInstance() {
        return (AppConsoleFontOptions)ApplicationManager.getApplication().getService(AppConsoleFontOptions.class);
    }

    @Override
    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myDelegatingPreferences != null ? this.myDelegatingPreferences : super.getFontPreferences();
        if (fontPreferences == null) {
            AppConsoleFontOptions.$$$reportNull$$$0(0);
        }
        return fontPreferences;
    }

    @Override
    protected ConsoleFontState createFontState(@NotNull FontPreferences fontPreferences) {
        if (fontPreferences == null) {
            AppConsoleFontOptions.$$$reportNull$$$0(1);
        }
        if (this.myDelegatingPreferences != null) {
            return new ConsoleFontState();
        }
        return new ConsoleFontState(fontPreferences);
    }

    @Override
    public void loadState(@NotNull ConsoleFontState state) {
        if (state == null) {
            AppConsoleFontOptions.$$$reportNull$$$0(2);
        }
        if (state.USE_EDITOR_FONT) {
            this.setUseEditorFont(true);
        } else {
            this.setUseEditorFont(false);
            super.loadState(state);
        }
    }

    public void setUseEditorFont(boolean useEditorFont) {
        if (useEditorFont) {
            this.myDelegatingPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
            this.myTracker.incModificationCount();
        } else {
            this.myDelegatingPreferences = null;
            this.update(AppEditorFontOptions.getInstance().getFontPreferences());
        }
    }

    public boolean isUseEditorFont() {
        return this.myDelegatingPreferences != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/AppConsoleFontOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontPreferences";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/AppConsoleFontOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFontState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    static class ConsoleFontState
    extends AppEditorFontOptions.PersistentFontPreferences {
        public boolean USE_EDITOR_FONT = true;

        ConsoleFontState() {
        }

        ConsoleFontState(FontPreferences fontPreferences) {
            super(fontPreferences);
            this.USE_EDITOR_FONT = false;
        }
    }
}

