/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.impl.TextAttributeKeyColorType;
import com.intellij.ui.ColorWrapper;
import com.intellij.util.ui.ComparableColor;
import java.awt.Color;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/editor/colors/impl/TextAttributeKeyColor;", "Lcom/intellij/ui/ColorWrapper;", "color", "Ljava/awt/Color;", "keyName", "", "type", "Lcom/intellij/openapi/editor/colors/impl/TextAttributeKeyColorType;", "<init>", "(Ljava/awt/Color;Ljava/lang/String;Lcom/intellij/openapi/editor/colors/impl/TextAttributeKeyColorType;)V", "getKeyName", "()Ljava/lang/String;", "getType", "()Lcom/intellij/openapi/editor/colors/impl/TextAttributeKeyColorType;", "getPresentableName", "Lcom/intellij/openapi/util/NlsSafe;", "colorEquals", "", "other", "Lcom/intellij/util/ui/ComparableColor;", "colorHashCode", "", "intellij.platform.editor.ex"})
@ApiStatus.Internal
public final class TextAttributeKeyColor
extends ColorWrapper {
    @NotNull
    private final String keyName;
    @NotNull
    private final TextAttributeKeyColorType type;

    public TextAttributeKeyColor(@NotNull Color color, @NotNull String keyName, @NotNull TextAttributeKeyColorType type) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(color);
        this.keyName = keyName;
        this.type = type;
    }

    @NotNull
    public final String getKeyName() {
        return this.keyName;
    }

    @NotNull
    public final TextAttributeKeyColorType getType() {
        return this.type;
    }

    @NotNull
    public String getPresentableName() {
        return "TextAttributeKey: " + this.keyName;
    }

    public boolean colorEquals(@NotNull ComparableColor other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof TextAttributeKeyColor && Intrinsics.areEqual((Object)this.keyName, (Object)((TextAttributeKeyColor)other).keyName) && this.type == ((TextAttributeKeyColor)other).type && Intrinsics.areEqual((Object)((Object)this), (Object)other);
    }

    public int colorHashCode() {
        Object[] objectArray = new Object[]{this.keyName, this.type};
        return Objects.hash(objectArray);
    }
}

