/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev;

import com.intellij.remoteDev.OsRegistryConfigProvider;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/remoteDev/RemoteDevSystemSettings;", "", "<init>", "()V", "sectionName", "", "osRegistryConfigProvider", "Lcom/intellij/remoteDev/OsRegistryConfigProvider;", "productCodePlaceholder", "productsInfoUrlKey", "clientDownloadUrlKey", "jreDownloadUrlKey", "pgpPublicKeyUrlKey", "defaultProductsUrl", "productCode", "defaultClientUrlLocation", "defaultJreUrlLocation", "getProductsUrl", "Lcom/intellij/remoteDev/OsRegistryConfigProvider$OsRegistrySystemSetting;", "getPgpPublicKeyUrl", "getClientDownloadUrl", "Ljava/net/URI;", "getJreDownloadUrl", "intellij.remoteDev.util"})
public final class RemoteDevSystemSettings {
    @NotNull
    public static final RemoteDevSystemSettings INSTANCE = new RemoteDevSystemSettings();
    @NotNull
    public static final String sectionName = "RemoteDev";
    @NotNull
    private static final OsRegistryConfigProvider osRegistryConfigProvider = new OsRegistryConfigProvider("RemoteDev");
    @NotNull
    private static final String productCodePlaceholder = "<PRODUCT_CODE>";
    @NotNull
    private static final String productsInfoUrlKey = "productsInfoUrl";
    @NotNull
    private static final String clientDownloadUrlKey = "clientDownloadUrl";
    @NotNull
    private static final String jreDownloadUrlKey = "jreDownloadUrl";
    @NotNull
    private static final String pgpPublicKeyUrlKey = "pgpPublicKeyUrl";
    @NotNull
    private static final String defaultClientUrlLocation = "https://download.jetbrains.com/idea/code-with-me/";
    @NotNull
    private static final String defaultJreUrlLocation = "https://download.jetbrains.com/idea/jbr/";

    private RemoteDevSystemSettings() {
    }

    private final String defaultProductsUrl(String productCode) {
        return "https://data.services.jetbrains.com/products?code=" + productCode;
    }

    @NotNull
    public final OsRegistryConfigProvider.OsRegistrySystemSetting<String> getProductsUrl(@NotNull String productCode) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        OsRegistryConfigProvider.OsRegistrySystemSetting<String> systemValue = osRegistryConfigProvider.get(productsInfoUrlKey);
        if (systemValue != null) {
            return new OsRegistryConfigProvider.OsRegistrySystemSetting<String>(StringsKt.replace$default((String)systemValue.getValue(), (String)productCodePlaceholder, (String)productCode, (boolean)false, (int)4, null), systemValue.getOsOriginLocation());
        }
        return new OsRegistryConfigProvider.OsRegistrySystemSetting<String>(this.defaultProductsUrl(productCode), null);
    }

    @NotNull
    public final OsRegistryConfigProvider.OsRegistrySystemSetting<String> getPgpPublicKeyUrl() {
        OsRegistryConfigProvider.OsRegistrySystemSetting<String> systemValue = osRegistryConfigProvider.get(pgpPublicKeyUrlKey);
        if (systemValue != null) {
            return new OsRegistryConfigProvider.OsRegistrySystemSetting<String>(systemValue.getValue(), systemValue.getOsOriginLocation());
        }
        return new OsRegistryConfigProvider.OsRegistrySystemSetting<Object>(null, null);
    }

    @NotNull
    public final OsRegistryConfigProvider.OsRegistrySystemSetting<URI> getClientDownloadUrl() {
        OsRegistryConfigProvider.OsRegistrySystemSetting<String> systemValue = osRegistryConfigProvider.get(clientDownloadUrlKey);
        if (systemValue != null) {
            return new OsRegistryConfigProvider.OsRegistrySystemSetting<URI>(new URI(systemValue.getValue()), systemValue.getOsOriginLocation());
        }
        return new OsRegistryConfigProvider.OsRegistrySystemSetting<URI>(new URI(defaultClientUrlLocation), null);
    }

    @NotNull
    public final OsRegistryConfigProvider.OsRegistrySystemSetting<URI> getJreDownloadUrl() {
        OsRegistryConfigProvider.OsRegistrySystemSetting<String> systemValue = osRegistryConfigProvider.get(jreDownloadUrlKey);
        if (systemValue != null) {
            return new OsRegistryConfigProvider.OsRegistrySystemSetting<URI>(new URI(systemValue.getValue()), systemValue.getOsOriginLocation());
        }
        return new OsRegistryConfigProvider.OsRegistrySystemSetting<URI>(new URI(defaultJreUrlLocation), null);
    }
}

