/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UrlCollector {
    private static final Logger LOG = Logger.getInstance(UrlCollector.class);
    private List<File> myFiles;

    public URL[] collect(List<Path> libraries) {
        List<File> files = this.collectFiles(libraries);
        URL[] result2 = new URL[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            try {
                result2[i] = files.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result2;
    }

    public List<File> collectFiles(List<Path> libraries) {
        this.myFiles = new ArrayList<File>();
        for (Path path : libraries) {
            File library = path.toFile();
            if (!library.exists()) continue;
            this.addFile(library);
            if (!library.isDirectory()) continue;
            this.addLibraries(library);
        }
        return this.myFiles;
    }

    private void addLibraries(@NotNull File dir) {
        if (dir == null) {
            UrlCollector.$$$reportNull$$$0(0);
        }
        LOG.debug("addLibraries: " + dir.getAbsolutePath() + ", exists: " + dir.exists());
        File[] subFiles = dir.listFiles();
        if (subFiles == null) {
            LOG.warn("Can't list files in " + String.valueOf(dir));
            return;
        }
        for (File file : subFiles) {
            if (file.isDirectory()) {
                this.addLibraries(file);
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            this.addFile(file);
        }
    }

    private void addFile(@NotNull File file) {
        if (file == null) {
            UrlCollector.$$$reportNull$$$0(1);
        }
        LOG.debug("addFile: " + file.getAbsolutePath() + ", exists: " + file.exists());
        this.myFiles.add(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remoteServer/agent/impl/util/UrlCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibraries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

