/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.similarity.clustering;

import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.clustering.UsageCluster;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import com.intellij.util.MathUtil;
import org.jetbrains.annotations.NotNull;

public class Distance {
    public static final double MINIMUM_SIMILARITY = 0.0;
    public static final double MAXIMUM_SIMILARITY = 1.0;
    public static final double PRECISION = 1.0E-4;
    private final double myThreshold;

    public Distance(double threshold) {
        this.myThreshold = threshold;
    }

    double findMinimalSimilarity(@NotNull UsageCluster usageCluster, @NotNull Bag newUsageFeatures) {
        if (usageCluster == null) {
            Distance.$$$reportNull$$$0(0);
        }
        if (newUsageFeatures == null) {
            Distance.$$$reportNull$$$0(1);
        }
        double min = 1.0;
        double max = 0.0;
        for (SimilarUsage usage : usageCluster.getUsages()) {
            double similarity = Distance.jaccardSimilarityWithThreshold(usage.getFeatures(), newUsageFeatures, this.myThreshold);
            if (Distance.lessThen(similarity, min)) {
                min = similarity;
            }
            if (Distance.lessThen(max, similarity)) {
                max = similarity;
            }
            if (Distance.isCompleteMatch(max)) {
                return 1.0;
            }
            if (!Distance.lessThen(min, this.myThreshold)) continue;
            return 0.0;
        }
        return min;
    }

    static boolean isCompleteMatch(double similarity) {
        return MathUtil.equals((double)similarity, (double)1.0, (double)1.0E-4);
    }

    static boolean lessThen(double similarity1, double similarity2) {
        return similarity1 < similarity2 && !MathUtil.equals((double)similarity1, (double)similarity2, (double)1.0E-4);
    }

    /*
     * WARNING - void declaration
     */
    private static double jaccardSimilarity(@NotNull Bag bag1, @NotNull Bag bag2, double similarityThreshold, boolean bl) {
        void isOptimised;
        if (bag1 == null) {
            Distance.$$$reportNull$$$0(2);
        }
        if (bag2 == null) {
            Distance.$$$reportNull$$$0(3);
        }
        int cardinality1 = bag1.getCardinality();
        int cardinality2 = bag2.getCardinality();
        if (isOptimised == false && Distance.lessThen(Math.min(cardinality1, cardinality2), (double)Math.max(cardinality1, cardinality2) * similarityThreshold)) {
            return 0.0;
        }
        int intersectionSize = Bag.intersectionSize(bag1, bag2);
        return (double)intersectionSize / (double)(cardinality1 + cardinality2 - intersectionSize);
    }

    public static double jaccardSimilarityWithThreshold(@NotNull Bag bag1, @NotNull Bag bag2, double similarityThreshold) {
        if (bag1 == null) {
            Distance.$$$reportNull$$$0(4);
        }
        if (bag2 == null) {
            Distance.$$$reportNull$$$0(5);
        }
        return Distance.jaccardSimilarity(bag1, bag2, similarityThreshold, false);
    }

    public static double jaccardDistanceExact(@NotNull Bag bag1, @NotNull Bag bag2) {
        if (bag1 == null) {
            Distance.$$$reportNull$$$0(6);
        }
        if (bag2 == null) {
            Distance.$$$reportNull$$$0(7);
        }
        return 1.0 - Distance.jaccardSimilarity(bag1, bag2, 0.0, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageCluster";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUsageFeatures";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag1";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/similarity/clustering/Distance";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMinimalSimilarity";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "jaccardSimilarity";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "jaccardSimilarityWithThreshold";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "jaccardDistanceExact";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

