/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.internal.ml.ngram.NGramIncrementalModelRunner;
import com.intellij.internal.ml.ngram.NGramModelSerializer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryPersistence;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NGRAM_FILE_NAME_SUFFIX", "", "deleteLegacyFile", "", "project", "Lcom/intellij/openapi/project/Project;", "saveNGramsAsync", "runner", "Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;", "loadNGrams", "nGramLength", "", "getPathToStorage", "Ljava/nio/file/Path;", "suffix", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class FileHistoryPersistence {
    @NotNull
    public static final FileHistoryPersistence INSTANCE = new FileHistoryPersistence();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String NGRAM_FILE_NAME_SUFFIX = "-ngram";

    private FileHistoryPersistence() {
    }

    public final void deleteLegacyFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            Path path;
            if (!project.isDisposed() && (path = this.getPathToStorage(project, ".xml")) != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize file sequence ngrams", (Throwable)e);
        }
    }

    public final void saveNGramsAsync(@NotNull Project project, @NotNull NGramIncrementalModelRunner runner) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Path path = this.getPathToStorage(project, NGRAM_FILE_NAME_SUFFIX);
        if (path == null) {
            return;
        }
        Path path2 = path;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
        BuildersKt.launch$default((CoroutineScope)((ComponentManagerEx)application).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path2, runner, null){
            int label;
            final /* synthetic */ Path $path;
            final /* synthetic */ NGramIncrementalModelRunner $runner;
            {
                this.$path = $path;
                this.$runner = $runner;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            Files.createDirectories(this.$path.getParent(), new FileAttribute[0]);
                            NGramModelSerializer.INSTANCE.saveNGrams(this.$path, this.$runner);
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            FileHistoryPersistence.access$getLOG$p().warn("Cannot serialize file sequence ngrams", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final NGramIncrementalModelRunner loadNGrams(@NotNull Project project, int nGramLength) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            if (!project.isDisposed()) {
                Path path = this.getPathToStorage(project, NGRAM_FILE_NAME_SUFFIX);
                return NGramModelSerializer.INSTANCE.loadNGrams(path, nGramLength);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize file sequence ngrams", (Throwable)e);
        }
        return NGramModelSerializer.INSTANCE.loadNGrams(null, nGramLength);
    }

    private final Path getPathToStorage(Project project, String suffix) {
        String string = project.getPresentableUrl();
        if (string == null) {
            return null;
        }
        String url = string;
        Path projectPath = Paths.get(VirtualFileManager.extractPath((String)url), new String[0]);
        Object object = projectPath.getFileName();
        if (object == null || (object = object.toString()) == null) {
            String string2 = ((Object)projectPath).toString().substring(0, 1);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        Object dirName = object;
        String string3 = PathUtil.suggestFileName((String)((String)dirName + Integer.toHexString(((Object)projectPath).toString().hashCode())));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"suggestFileName(...)");
        String storageName = string3;
        String[] stringArray = new String[]{"fileHistory", storageName + suffix};
        return Path.of(PathManager.getSystemPath(), stringArray);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(FileHistoryPersistence.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

