/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.impl.util.network;

import com.intellij.codeWithMe.ClientId;
import com.intellij.mcpserver.impl.McpServerService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0013\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0019J%\u0010\u001a\u001a\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0002J\f\u0010\u001d\u001a\u00020\u0005*\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\u00a8\u0006!"}, d2={"Lcom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider;", "", "<init>", "()V", "loopbackHost", "", "serverService", "Lcom/intellij/mcpserver/impl/McpServerService;", "getServerService", "()Lcom/intellij/mcpserver/impl/McpServerService;", "currentHost", "getCurrentHost", "()Ljava/lang/String;", "currentPort", "", "getCurrentPort", "()I", "serverStreamUrl", "getServerStreamUrl", "serverSseUrl", "getServerSseUrl", "httpUrl", "path", "portOverride", "hostOverride", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/String;", "buildBaseUrl", "(Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/String;", "effectiveHost", "normalizeConnectorHost", "formatHostForUrl", "host", "Companion", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpServerConnectionAddressProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerConnectionAddressProvider.kt\ncom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n42#2,3:66\n1#3:69\n*S KotlinDebug\n*F\n+ 1 McpServerConnectionAddressProvider.kt\ncom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider\n*L\n15#1:66,3\n*E\n"})
public final class McpServerConnectionAddressProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String loopbackHost;

    public McpServerConnectionAddressProvider() {
        String string = InetAddress.getLoopbackAddress().getHostAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
        this.loopbackHost = string;
    }

    private final McpServerService getServerService() {
        boolean $i$f$service = false;
        Class<McpServerService> serviceClass$iv = McpServerService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (McpServerService)object;
    }

    @NotNull
    public final String getCurrentHost() {
        return this.effectiveHost(null);
    }

    public final int getCurrentPort() {
        return this.getServerService().getPort();
    }

    @NotNull
    public final String getServerStreamUrl() {
        return McpServerConnectionAddressProvider.httpUrl$default(this, "/stream", null, null, 6, null);
    }

    @NotNull
    public final String getServerSseUrl() {
        return McpServerConnectionAddressProvider.httpUrl$default(this, "/sse", null, null, 6, null);
    }

    @NotNull
    public final String httpUrl(@NotNull String path, @Nullable Integer portOverride, @Nullable String hostOverride) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String base = this.buildBaseUrl(portOverride, hostOverride);
        if (((CharSequence)path).length() == 0) {
            return base;
        }
        Object normalizedPath = StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) ? path : "/" + path;
        return base + (String)normalizedPath;
    }

    public static /* synthetic */ String httpUrl$default(McpServerConnectionAddressProvider mcpServerConnectionAddressProvider, String string, Integer n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        return mcpServerConnectionAddressProvider.httpUrl(string, n, string2);
    }

    private final String buildBaseUrl(Integer portOverride, String hostOverride) {
        String host = this.effectiveHost(hostOverride);
        Integer n = portOverride;
        int port = n != null ? n.intValue() : this.getCurrentPort();
        return "http://" + this.formatHostForUrl(host) + ":" + port;
    }

    static /* synthetic */ String buildBaseUrl$default(McpServerConnectionAddressProvider mcpServerConnectionAddressProvider, Integer n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        return mcpServerConnectionAddressProvider.buildBaseUrl(n, string);
    }

    private final String effectiveHost(String hostOverride) {
        String candidate;
        String string;
        String string2 = hostOverride;
        if (string2 == null) {
            String string3;
            String it = string3 = this.getServerService().resolvedConnectorHost$intellij_mcpserver();
            boolean bl = false;
            CharSequence charSequence = it;
            string2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string3 : null;
        }
        if ((string = (candidate = string2)) == null || (string = this.normalizeConnectorHost(string)) == null) {
            string = this.loopbackHost;
        }
        return string;
    }

    private final String normalizeConnectorHost(String $this$normalizeConnectorHost) {
        String trimmed;
        return switch (trimmed = ((Object)StringsKt.trim((CharSequence)$this$normalizeConnectorHost)).toString()) {
            case "", "0.0.0.0", "*" -> this.loopbackHost;
            case "::", "::0", "0:0:0:0:0:0:0:0" -> this.loopbackHost;
            default -> trimmed;
        };
    }

    private final String formatHostForUrl(String host) {
        return StringsKt.contains$default((CharSequence)host, (char)':', (boolean)false, (int)2, null) && (!StringsKt.startsWith$default((String)host, (String)"[", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)host, (String)"]", (boolean)false, (int)2, null)) ? "[" + host + "]" : host;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider$Companion;", "", "<init>", "()V", "getInstanceOrNull", "Lcom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider;", "intellij.mcpserver"})
    @SourceDebugExtension(value={"SMAP\nMcpServerConnectionAddressProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerConnectionAddressProvider.kt\ncom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,65:1\n50#2:66\n*S KotlinDebug\n*F\n+ 1 McpServerConnectionAddressProvider.kt\ncom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider$Companion\n*L\n62#1:66\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final McpServerConnectionAddressProvider getInstanceOrNull() {
            boolean $i$f$serviceOrNull = false;
            Application application = ApplicationManager.getApplication();
            return (McpServerConnectionAddressProvider)(application != null ? application.getService(McpServerConnectionAddressProvider.class) : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

