/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.statistics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.mcpserver.McpToolDescriptor;
import com.intellij.mcpserver.McpToolsProvider;
import com.intellij.mcpserver.statistics.ScopeHolder;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/mcpserver/statistics/McpServerCounterUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "MCP_CALL", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "getGroup", "reportMcpCall", "", "mcpToolDescriptor", "Lcom/intellij/mcpserver/McpToolDescriptor;", "McpToolNameValidator", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpServerCounterUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerCounterUsagesCollector.kt\ncom/intellij/mcpserver/statistics/McpServerCounterUsagesCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,52:1\n90#2,3:53\n*S KotlinDebug\n*F\n+ 1 McpServerCounterUsagesCollector.kt\ncom/intellij/mcpserver/statistics/McpServerCounterUsagesCollector\n*L\n22#1:53,3\n*E\n"})
public final class McpServerCounterUsagesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final McpServerCounterUsagesCollector INSTANCE = new McpServerCounterUsagesCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("mcpserver.events", 1, null, 4, null);
    @NotNull
    private static final EventId1<String> MCP_CALL;

    private McpServerCounterUsagesCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void reportMcpCall(@NotNull McpToolDescriptor mcpToolDescriptor) {
        Intrinsics.checkNotNullParameter((Object)mcpToolDescriptor, (String)"mcpToolDescriptor");
        MCP_CALL.log((Object)mcpToolDescriptor.getName());
    }

    static {
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "tool_name";
        String description$iv = null;
        boolean $i$f$StringValidatedByCustomRule = false;
        MCP_CALL = GROUP.registerEvent("mcp.tool.call", (EventField)EventFields.StringValidatedByCustomRule((String)name$iv, McpToolNameValidator.class, description$iv));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/mcpserver/statistics/McpServerCounterUsagesCollector$McpToolNameValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "<init>", "()V", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "getRuleId", "intellij.mcpserver"})
    @SourceDebugExtension(value={"SMAP\nMcpServerCounterUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerCounterUsagesCollector.kt\ncom/intellij/mcpserver/statistics/McpServerCounterUsagesCollector$McpToolNameValidator\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,52:1\n42#2,3:53\n*S KotlinDebug\n*F\n+ 1 McpServerCounterUsagesCollector.kt\ncom/intellij/mcpserver/statistics/McpServerCounterUsagesCollector$McpToolNameValidator\n*L\n30#1:53,3\n*E\n"})
    public static final class McpToolNameValidator
    extends CustomValidationRule {
        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            boolean $i$f$service = false;
            Class<ScopeHolder> serviceClass$iv = ScopeHolder.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            for (Map.Entry entry : ((Map)((ScopeHolder)object).valueMap.getValue()).entrySet()) {
                McpToolsProvider ext = (McpToolsProvider)entry.getKey();
                Sequence tools = (Sequence)entry.getValue();
                if (!SequencesKt.contains((Sequence)tools, (Object)data)) continue;
                return PluginInfoDetectorKt.getPluginInfo(ext.getClass()).isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            }
            return ValidationResultType.REJECTED;
        }

        @NotNull
        public String getRuleId() {
            return "tool_name_validator_id";
        }
    }
}

