/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.diff;

import com.intellij.profiler.model.diff.DiffCallWithValue;
import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer;", "", "<init>", "()V", "requiresMixedColor", "", "getRequiresMixedColor", "()Z", "paintDiffRectangle", "", "g", "Ljava/awt/Graphics2D;", "rectangle", "Ljava/awt/geom/RectangularShape;", "data", "Lcom/intellij/profiler/model/diff/DiffCallWithValue;", "backgroundType", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "WholeNodeIsDiff", "SeparatedDiffPart", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer$SeparatedDiffPart;", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer$WholeNodeIsDiff;", "intellij.profiler.common"})
public abstract sealed class DifferentialFlameGraphCellRenderer {
    private DifferentialFlameGraphCellRenderer() {
    }

    public abstract boolean getRequiresMixedColor();

    public abstract void paintDiffRectangle(@NotNull Graphics2D var1, @NotNull RectangularShape var2, @NotNull DiffCallWithValue<?> var3, @NotNull ColorType var4);

    public /* synthetic */ DifferentialFlameGraphCellRenderer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer$SeparatedDiffPart;", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer;", "<init>", "()V", "requiresMixedColor", "", "getRequiresMixedColor", "()Z", "paintDiffRectangle", "", "g", "Ljava/awt/Graphics2D;", "rectangle", "Ljava/awt/geom/RectangularShape;", "data", "Lcom/intellij/profiler/model/diff/DiffCallWithValue;", "backgroundType", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.common"})
    public static final class SeparatedDiffPart
    extends DifferentialFlameGraphCellRenderer {
        @NotNull
        public static final SeparatedDiffPart INSTANCE = new SeparatedDiffPart();
        private static final boolean requiresMixedColor;

        private SeparatedDiffPart() {
            super(null);
        }

        @Override
        public boolean getRequiresMixedColor() {
            return requiresMixedColor;
        }

        @Override
        public void paintDiffRectangle(@NotNull Graphics2D g, @NotNull RectangularShape rectangle, @NotNull DiffCallWithValue<?> data, @NotNull ColorType backgroundType) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)((Object)backgroundType), (String)"backgroundType");
            double diffFraction = (double)Math.abs(data.getValue()) / (double)Math.max(data.getBaselineValue(), data.getNewValue());
            double diffWidth = rectangle.getWidth() * diffFraction;
            g.setColor(new Color((data.getValue() > 0L ? (FlameChartColors.ChartColor2ColorScheme)FlameChartColors.DIFF_GREATER.INSTANCE : (FlameChartColors.ChartColor2ColorScheme)FlameChartColors.DIFF_LESS.INSTANCE).color(backgroundType).getRGB()));
            RectangularShape diffRectangle = rectangle instanceof RoundRectangle2D ? new RoundRectangle2D.Double(((RoundRectangle2D)rectangle).getX() + ((RoundRectangle2D)rectangle).getWidth() - diffWidth, ((RoundRectangle2D)rectangle).getY(), diffWidth, ((RoundRectangle2D)rectangle).getHeight(), ((RoundRectangle2D)rectangle).getArcWidth(), ((RoundRectangle2D)rectangle).getArcHeight()) : new Rectangle2D.Double(rectangle.getX() + rectangle.getWidth() - diffWidth, rectangle.getY(), diffWidth, rectangle.getHeight());
            g.fill(diffRectangle);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer$WholeNodeIsDiff;", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphCellRenderer;", "<init>", "()V", "requiresMixedColor", "", "getRequiresMixedColor", "()Z", "paintDiffRectangle", "", "g", "Ljava/awt/Graphics2D;", "rectangle", "Ljava/awt/geom/RectangularShape;", "data", "Lcom/intellij/profiler/model/diff/DiffCallWithValue;", "backgroundType", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.common"})
    public static final class WholeNodeIsDiff
    extends DifferentialFlameGraphCellRenderer {
        @NotNull
        public static final WholeNodeIsDiff INSTANCE = new WholeNodeIsDiff();
        private static final boolean requiresMixedColor = true;

        private WholeNodeIsDiff() {
            super(null);
        }

        @Override
        public boolean getRequiresMixedColor() {
            return requiresMixedColor;
        }

        @Override
        public void paintDiffRectangle(@NotNull Graphics2D g, @NotNull RectangularShape rectangle, @NotNull DiffCallWithValue<?> data, @NotNull ColorType backgroundType) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)((Object)backgroundType), (String)"backgroundType");
        }
    }
}

