/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamechart;

import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0015R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors;", "", "<init>", "()V", "baseColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "fireColor100", "Lcom/intellij/ui/JBColor;", "fireColor75", "fireColor50", "fireColor25", "greenColor100", "greenColor75", "greenColor50", "greenColor25", "getFireColor", "fraction", "", "getFireColor$intellij_profiler_common", "getGreenColor", "getGreenColor$intellij_profiler_common", "ChartColor2ColorScheme", "DEFAULT", "JAVA", "DIFF_GREATER", "DIFF_LESS", "Diff", "PARENT", "PALE", "ChartColor", "intellij.profiler.common"})
public final class FlameChartColors {
    @NotNull
    public static final FlameChartColors INSTANCE = new FlameChartColors();
    @NotNull
    private static final Color baseColor;
    @NotNull
    private static final JBColor fireColor100;
    @NotNull
    private static final Color fireColor75;
    @NotNull
    private static final Color fireColor50;
    @NotNull
    private static final Color fireColor25;
    @NotNull
    private static final JBColor greenColor100;
    @NotNull
    private static final Color greenColor75;
    @NotNull
    private static final Color greenColor50;
    @NotNull
    private static final Color greenColor25;

    private FlameChartColors() {
    }

    @NotNull
    public final Color getFireColor$intellij_profiler_common(double fraction) {
        return fraction >= 0.5 ? (Color)fireColor100 : (fraction >= 0.25 ? fireColor75 : (fraction >= 0.1 ? fireColor50 : (fraction >= 0.05 ? fireColor25 : baseColor)));
    }

    @NotNull
    public final Color getGreenColor$intellij_profiler_common(double fraction) {
        return fraction >= 0.5 ? (Color)greenColor100 : (fraction >= 0.25 ? greenColor75 : (fraction >= 0.1 ? greenColor50 : (fraction >= 0.05 ? greenColor25 : baseColor)));
    }

    static {
        Color color = JBColor.foreground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
        baseColor = color;
        JBColor jBColor = JBColor.namedColor((String)"Label.errorForeground", (Color)((Color)new JBColor(new Color(13050413), (Color)JBColor.RED)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        fireColor100 = jBColor;
        Color color2 = ColorUtil.mix((Color)baseColor, (Color)((Color)fireColor100), (double)0.75);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"mix(...)");
        fireColor75 = color2;
        Color color3 = ColorUtil.mix((Color)baseColor, (Color)((Color)fireColor100), (double)0.5);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"mix(...)");
        fireColor50 = color3;
        Color color4 = ColorUtil.mix((Color)baseColor, (Color)((Color)fireColor100), (double)0.25);
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"mix(...)");
        fireColor25 = color4;
        greenColor100 = new JBColor(new Color(2279213), (Color)JBColor.GREEN);
        Color color5 = ColorUtil.mix((Color)baseColor, (Color)((Color)greenColor100), (double)0.75);
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"mix(...)");
        greenColor75 = color5;
        Color color6 = ColorUtil.mix((Color)baseColor, (Color)((Color)greenColor100), (double)0.5);
        Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"mix(...)");
        greenColor50 = color6;
        Color color7 = ColorUtil.mix((Color)baseColor, (Color)((Color)greenColor100), (double)0.25);
        Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"mix(...)");
        greenColor25 = color7;
    }

    @Deprecated(message="Use FlameChartColorScheme instead", replaceWith=@ReplaceWith(expression="FlameChartColorScheme", imports={}))
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J \u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0012H\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor;", "", "base", "Lcom/intellij/ui/JBColor;", "getBase", "()Lcom/intellij/ui/JBColor;", "searchNotMatched", "getSearchNotMatched", "focus", "getFocus", "focusSearchNotMatched", "getFocusSearchNotMatched", "foreground", "getForeground", "focusedForeground", "getFocusedForeground", "getBackground", "searchActive", "", "searchMatch", "hovered", "intellij.profiler.common"})
    @ApiStatus.ScheduledForRemoval
    public static interface ChartColor {
        @NotNull
        public JBColor getBase();

        @NotNull
        public JBColor getSearchNotMatched();

        @NotNull
        public JBColor getFocus();

        @NotNull
        public JBColor getFocusSearchNotMatched();

        @NotNull
        public JBColor getForeground();

        @NotNull
        public JBColor getFocusedForeground();

        @Deprecated(message="Use FlameChartColorScheme instead", replaceWith=@ReplaceWith(expression="FlameChartColorScheme", imports={}))
        @ApiStatus.ScheduledForRemoval
        @NotNull
        default public JBColor getBackground(boolean searchActive, boolean searchMatch, boolean hovered) {
            if (searchActive && !searchMatch) {
                return hovered ? this.getFocusSearchNotMatched() : this.getSearchNotMatched();
            }
            return hovered ? this.getFocus() : this.getBase();
        }

        @Deprecated(message="Use FlameChartColorScheme instead", replaceWith=@ReplaceWith(expression="FlameChartColorScheme", imports={}))
        @ApiStatus.ScheduledForRemoval
        @NotNull
        default public JBColor getForeground(boolean hovered) {
            return hovered ? this.getFocusedForeground() : this.getForeground();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0014\u0010\u0015\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor;", "key", "", "<init>", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "base", "Lcom/intellij/ui/JBColor;", "getBase", "()Lcom/intellij/ui/JBColor;", "searchNotMatched", "getSearchNotMatched", "focus", "getFocus", "focusSearchNotMatched", "getFocusSearchNotMatched", "foreground", "getForeground", "focusedForeground", "getFocusedForeground", "getPrefix", "intellij.profiler.common"})
    public static abstract class ChartColor2ColorScheme
    extends FlameChartColorScheme
    implements ChartColor {
        @NotNull
        private final String key;
        @NotNull
        private final JBColor base;
        @NotNull
        private final JBColor searchNotMatched;
        @NotNull
        private final JBColor focus;
        @NotNull
        private final JBColor focusSearchNotMatched;
        @NotNull
        private final JBColor foreground;
        @NotNull
        private final JBColor focusedForeground;

        public ChartColor2ColorScheme(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.base = this.color(ColorType.BACKGROUND);
            this.searchNotMatched = this.color(ColorType.SEARCH_FAIL);
            this.focus = this.color(ColorType.BACKGROUND_HOVER);
            this.focusSearchNotMatched = this.color(ColorType.SEARCH_FAIL_HOVER);
            this.foreground = this.color(ColorType.FOREGROUND);
            this.focusedForeground = this.color(ColorType.FOREGROUND_HOVER);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public JBColor getBase() {
            return this.base;
        }

        @Override
        @NotNull
        public JBColor getSearchNotMatched() {
            return this.searchNotMatched;
        }

        @Override
        @NotNull
        public JBColor getFocus() {
            return this.focus;
        }

        @Override
        @NotNull
        public JBColor getFocusSearchNotMatched() {
            return this.focusSearchNotMatched;
        }

        @Override
        @NotNull
        public JBColor getForeground() {
            return this.foreground;
        }

        @Override
        @NotNull
        public JBColor getFocusedForeground() {
            return this.focusedForeground;
        }

        @Override
        @NotNull
        public String getPrefix() {
            return this.key;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$DEFAULT;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "<init>", "()V", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.common"})
    public static final class DEFAULT
    extends ChartColor2ColorScheme {
        @NotNull
        public static final DEFAULT INSTANCE = new DEFAULT();

        private DEFAULT() {
            super("Default");
        }

        @Override
        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            JBColor jBColor;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: {
                    JBColor jBColor2 = JBColor.namedColor((String)"FlameGraph.nativeFrameForeground", (Color)((Color)this.colorize(ColorType.BACKGROUND)));
                    jBColor = jBColor2;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
                    break;
                }
                case 3: {
                    JBColor jBColor3 = JBColor.namedColor((String)"FlameGraph.nativeFocusedFrameForeground", (Color)((Color)this.colorize(ColorType.BACKGROUND)));
                    jBColor = jBColor3;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
                    break;
                }
                case 4: 
                case 5: {
                    jBColor = this.colorize(ColorType.BACKGROUND_INACTIVE);
                    break;
                }
                case 6: {
                    jBColor = this.colorize(ColorType.BACKGROUND_HOVER_INACTIVE);
                    break;
                }
                case 7: {
                    JBColor jBColor4 = JBColor.namedColor((String)"FlameGraph.nativeBackground", (Color)((Color)new JBColor(11196658, 8563912)));
                    jBColor = jBColor4;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"namedColor(...)");
                    break;
                }
                case 8: 
                case 9: {
                    JBColor jBColor5 = JBColor.namedColor((String)"FlameGraph.nativeFocusBackground", (Color)((Color)new JBColor(10472160, 7444142)));
                    jBColor = jBColor5;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor5, (String)"namedColor(...)");
                    break;
                }
                case 10: {
                    jBColor = new JBColor(this.shadow(ColorType.BACKGROUND).getRGB(), 6981529);
                    break;
                }
                case 11: 
                case 12: {
                    jBColor = new JBColor(8166320, 6059397);
                    break;
                }
                case 13: {
                    jBColor = new JBColor(11196658, 8563912);
                    break;
                }
                case 14: {
                    jBColor = new JBColor(10472160, 7444142);
                    break;
                }
                case 15: {
                    jBColor = this.shadow(ColorType.SEARCH_OK);
                    break;
                }
                case 16: {
                    jBColor = this.shadow(ColorType.SEARCH_OK_INACTIVE);
                    break;
                }
                case 17: {
                    JBColor jBColor6 = JBColor.namedColor((String)"FlameGraph.nativeSearchNotMatchedBackground", (Color)((Color)new JBColor(9351882, 6716554)));
                    jBColor = jBColor6;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor6, (String)"namedColor(...)");
                    break;
                }
                case 18: 
                case 19: {
                    JBColor jBColor7 = JBColor.namedColor((String)"FlameGraph.nativeFocusSearchNotMatchedBackground", (Color)((Color)new JBColor(8166320, 5860472)));
                    jBColor = jBColor7;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor7, (String)"namedColor(...)");
                    break;
                }
                case 20: {
                    jBColor = new JBColor(7439505, 5333355);
                    break;
                }
                case 21: 
                case 22: {
                    jBColor = new JBColor(6452094, 4609117);
                    break;
                }
                case 23: 
                case 24: {
                    jBColor = new JBColor(new Color(77, 77, 77, 128), new Color(64, 64, 64, 128));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return jBColor;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorType.values().length];
                try {
                    nArray[ColorType.FOREGROUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_INACTIVE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL_INACTIVE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER_INACTIVE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_GROUP.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_INACTIVE.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE_GROUP.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_INACTIVE.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER_INACTIVE.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_GROUP.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_INACTIVE.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE_GROUP.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BORDER.ordinal()] = 23;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FOCUSED_BORDER.ordinal()] = 24;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$DIFF_GREATER;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "<init>", "()V", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.common"})
    public static final class DIFF_GREATER
    extends ChartColor2ColorScheme {
        @NotNull
        public static final DIFF_GREATER INSTANCE = new DIFF_GREATER();

        private DIFF_GREATER() {
            super("DiffGreater");
        }

        @Override
        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1, 2 -> this.colorize(ColorType.BACKGROUND);
                case 3 -> this.colorize(ColorType.BACKGROUND);
                case 4, 5 -> this.colorize(ColorType.BACKGROUND_INACTIVE);
                case 6 -> this.colorize(ColorType.BACKGROUND_HOVER_INACTIVE);
                case 7 -> new JBColor(0xFF9B9B, 14773352);
                case 8, 9 -> new JBColor(15043724, 13328734);
                case 10 -> new JBColor(0xCE7E7E, 11818835);
                case 11, 12 -> new JBColor(11496299, 10176837);
                case 13 -> new JBColor(0xFFA6A6, 14319484);
                case 14 -> new JBColor(15043724, 13328734);
                case 15 -> this.shadow(ColorType.SEARCH_OK);
                case 16 -> this.shadow(ColorType.SEARCH_OK_INACTIVE);
                case 17 -> new JBColor(0xCE7E7E, 11818835);
                case 18, 19 -> new JBColor(11496299, 10176837);
                case 20 -> new JBColor(12153201, 11161933);
                case 21, 22 -> new JBColor(11496299, 10176837);
                case 23, 24 -> new JBColor(new Color(77, 77, 77, 128), new Color(64, 64, 64, 128));
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorType.values().length];
                try {
                    nArray[ColorType.FOREGROUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_INACTIVE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL_INACTIVE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER_INACTIVE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_GROUP.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_INACTIVE.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE_GROUP.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_INACTIVE.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER_INACTIVE.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_GROUP.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_INACTIVE.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE_GROUP.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BORDER.ordinal()] = 23;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FOCUSED_BORDER.ordinal()] = 24;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$DIFF_LESS;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "<init>", "()V", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.common"})
    public static final class DIFF_LESS
    extends ChartColor2ColorScheme {
        @NotNull
        public static final DIFF_LESS INSTANCE = new DIFF_LESS();

        private DIFF_LESS() {
            super("DiffLess");
        }

        @Override
        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1, 2 -> this.colorize(ColorType.BACKGROUND);
                case 3 -> this.colorize(ColorType.BACKGROUND);
                case 4, 5 -> this.colorize(ColorType.BACKGROUND_INACTIVE);
                case 6 -> this.colorize(ColorType.BACKGROUND_HOVER_INACTIVE);
                case 7 -> new JBColor(8053391, 6006373);
                case 8, 9 -> new JBColor(6999678, 5412187);
                case 10 -> new JBColor(6009196, 4818257);
                case 11, 12 -> new JBColor(5412191, 4158790);
                case 13 -> new JBColor(9758885, 8173700);
                case 14 -> new JBColor(6999678, 5412187);
                case 15 -> this.shadow(ColorType.SEARCH_OK);
                case 16 -> this.shadow(ColorType.SEARCH_OK_INACTIVE);
                case 17 -> new JBColor(6009196, 4818257);
                case 18, 19 -> new JBColor(5412191, 4158790);
                case 20 -> new JBColor(6265194, 4422474);
                case 21, 22 -> new JBColor(5412191, 4158790);
                case 23, 24 -> new JBColor(new Color(77, 77, 77, 128), new Color(64, 64, 64, 128));
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorType.values().length];
                try {
                    nArray[ColorType.FOREGROUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_INACTIVE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL_INACTIVE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER_INACTIVE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_GROUP.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_INACTIVE.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE_GROUP.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_INACTIVE.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER_INACTIVE.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_GROUP.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_INACTIVE.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE_GROUP.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BORDER.ordinal()] = 23;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FOCUSED_BORDER.ordinal()] = 24;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$Diff;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "baselineValue", "", "newValue", "<init>", "(JJ)V", "valueForColoring", "", "scheme", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "getScheme", "()Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "getPrefix", "", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "Companion", "intellij.profiler.common"})
    public static final class Diff
    extends FlameChartColorScheme {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int valueForColoring;
        public static final int SCALE = 20;

        public Diff(long baselineValue, long newValue) {
            this.valueForColoring = Diff.Companion.valueForColoring(baselineValue, newValue);
        }

        private final ChartColor2ColorScheme getScheme() {
            return this.valueForColoring <= 0 ? (ChartColor2ColorScheme)DIFF_LESS.INSTANCE : (ChartColor2ColorScheme)DIFF_GREATER.INSTANCE;
        }

        @Override
        @NotNull
        public String getPrefix() {
            return "Diff_" + this.valueForColoring;
        }

        @Override
        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return type.isForeground() ? this.colorize(ColorType.BACKGROUND) : (type.isHover() ? new JBColor(() -> Diff.produce$lambda$0(this, type)) : new JBColor(() -> Diff.produce$lambda$1(this, type)));
        }

        private static final Color produce$lambda$0(Diff this$0, ColorType $type) {
            return ColorUtil.mix((Color)Color.LIGHT_GRAY, (Color)((Color)this$0.getScheme().color($type)), (double)((double)Math.abs(this$0.valueForColoring) / 20.0));
        }

        private static final Color produce$lambda$1(Diff this$0, ColorType $type) {
            return ColorUtil.mix((Color)Color.WHITE, (Color)((Color)this$0.getScheme().color($type)), (double)((double)Math.abs(this$0.valueForColoring) / 20.0));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$Diff$Companion;", "", "<init>", "()V", "SCALE", "", "valueForColoring", "baselineValue", "", "newValue", "intellij.profiler.common"})
        public static final class Companion {
            private Companion() {
            }

            private final int valueForColoring(long baselineValue, long newValue) {
                double coercedFactor = RangesKt.coerceAtMost((double)((double)newValue / (double)baselineValue - 1.0), (double)1.0);
                return MathKt.roundToInt((double)(coercedFactor * (double)20));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$JAVA;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "<init>", "()V", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.common"})
    public static final class JAVA
    extends ChartColor2ColorScheme {
        @NotNull
        public static final JAVA INSTANCE = new JAVA();

        private JAVA() {
            super("Application");
        }

        @Override
        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            JBColor jBColor;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: {
                    JBColor jBColor2 = JBColor.namedColor((String)"FlameGraph.JVMFrameForeground", (Color)((Color)this.colorize(ColorType.BACKGROUND)));
                    jBColor = jBColor2;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
                    break;
                }
                case 3: {
                    JBColor jBColor3 = JBColor.namedColor((String)"FlameGraph.JVMFocusedFrameForeground", (Color)((Color)this.colorize(ColorType.BACKGROUND)));
                    jBColor = jBColor3;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
                    break;
                }
                case 4: 
                case 5: {
                    jBColor = this.colorize(ColorType.BACKGROUND_INACTIVE);
                    break;
                }
                case 6: {
                    jBColor = this.colorize(ColorType.BACKGROUND_HOVER_INACTIVE);
                    break;
                }
                case 7: {
                    JBColor jBColor4 = JBColor.namedColor((String)"FlameGraph.JVMBackground", (Color)((Color)new JBColor(16571797, 12558179)));
                    jBColor = jBColor4;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"namedColor(...)");
                    break;
                }
                case 8: 
                case 9: {
                    JBColor jBColor5 = JBColor.namedColor((String)"FlameGraph.JVMFocusBackground", (Color)((Color)new JBColor(14928008, 10914390)));
                    jBColor = jBColor5;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor5, (String)"namedColor(...)");
                    break;
                }
                case 10: {
                    jBColor = new JBColor(this.shadow(ColorType.BACKGROUND).getRGB(), 9731926);
                    break;
                }
                case 11: 
                case 12: {
                    jBColor = new JBColor(11245676, 8482379);
                    break;
                }
                case 13: {
                    jBColor = new JBColor(16571797, 12558179);
                    break;
                }
                case 14: {
                    jBColor = new JBColor(14928008, 10914390);
                    break;
                }
                case 15: {
                    jBColor = this.shadow(ColorType.SEARCH_OK);
                    break;
                }
                case 16: {
                    jBColor = this.shadow(ColorType.SEARCH_OK_INACTIVE);
                    break;
                }
                case 17: {
                    JBColor jBColor6 = JBColor.namedColor((String)"FlameGraph.JVMSearchNotMatchedBackground", (Color)((Color)new JBColor(12889980, 8746068)));
                    jBColor = jBColor6;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor6, (String)"namedColor(...)");
                    break;
                }
                case 18: 
                case 19: {
                    JBColor jBColor7 = JBColor.namedColor((String)"FlameGraph.JVMFocusSearchNotMatchedBackground", (Color)((Color)new JBColor(11245676, 7628105)));
                    jBColor = jBColor7;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor7, (String)"namedColor(...)");
                    break;
                }
                case 20: {
                    jBColor = new JBColor(9208422, 7037001);
                    break;
                }
                case 21: 
                case 22: {
                    jBColor = new JBColor(8024409, 6116416);
                    break;
                }
                case 23: 
                case 24: {
                    jBColor = new JBColor(new Color(77, 77, 77, 128), new Color(64, 64, 64, 128));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return jBColor;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorType.values().length];
                try {
                    nArray[ColorType.FOREGROUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_INACTIVE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL_INACTIVE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER_INACTIVE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_GROUP.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_INACTIVE.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE_GROUP.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_INACTIVE.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER_INACTIVE.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_GROUP.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_INACTIVE.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE_GROUP.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BORDER.ordinal()] = 23;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FOCUSED_BORDER.ordinal()] = 24;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$PALE;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "<init>", "()V", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.common"})
    public static final class PALE
    extends ChartColor2ColorScheme {
        @NotNull
        public static final PALE INSTANCE = new PALE();

        private PALE() {
            super("Filtered");
        }

        @Override
        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return StringsKt.startsWith$default((String)type.name(), (String)"FOREGROUND", (boolean)false, (int)2, null) ? new JBColor(0x888888, 328965) : (StringsKt.contains$default((CharSequence)type.name(), (CharSequence)"HOVER", (boolean)false, (int)2, null) ? new JBColor(0xEEEEEE, 0x131313) : new JBColor(0xF8F8F8, 0x2B2B2B));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColors$PARENT;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColors$ChartColor2ColorScheme;", "<init>", "()V", "produce", "Lcom/intellij/ui/JBColor;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "intellij.profiler.common"})
    public static final class PARENT
    extends ChartColor2ColorScheme {
        @NotNull
        public static final PARENT INSTANCE = new PARENT();

        private PARENT() {
            super("Parent");
        }

        @Override
        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            JBColor jBColor;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: {
                    JBColor jBColor2 = JBColor.namedColor((String)"FlameGraph.parentFrameForeground", (Color)((Color)this.colorize(ColorType.BACKGROUND)));
                    jBColor = jBColor2;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
                    break;
                }
                case 3: {
                    JBColor jBColor3 = JBColor.namedColor((String)"FlameGraph.parentFocusedFrameForeground", (Color)((Color)this.colorize(ColorType.BACKGROUND)));
                    jBColor = jBColor3;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
                    break;
                }
                case 4: 
                case 5: {
                    jBColor = this.colorize(ColorType.BACKGROUND_INACTIVE);
                    break;
                }
                case 6: {
                    jBColor = this.colorize(ColorType.BACKGROUND_HOVER_INACTIVE);
                    break;
                }
                case 7: {
                    JBColor jBColor4 = JBColor.namedColor((String)"FlameGraph.parentBackground", (Color)((Color)new JBColor(0xDBDBDB, 0xA3A3A3)));
                    jBColor = jBColor4;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"namedColor(...)");
                    break;
                }
                case 8: 
                case 9: {
                    JBColor jBColor5 = JBColor.namedColor((String)"FlameGraph.parentFocusBackground", (Color)((Color)new JBColor(0xC7C7C7, 0x8F8F8F)));
                    jBColor = jBColor5;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor5, (String)"namedColor(...)");
                    break;
                }
                case 10: {
                    jBColor = this.shadow(ColorType.BACKGROUND);
                    break;
                }
                case 11: 
                case 12: {
                    jBColor = this.shadow(ColorType.BACKGROUND_HOVER);
                    break;
                }
                case 13: {
                    jBColor = new JBColor(0xDBDBDB, 0xA3A3A3);
                    break;
                }
                case 14: {
                    jBColor = new JBColor(0xC7C7C7, 0x8F8F8F);
                    break;
                }
                case 15: {
                    jBColor = this.shadow(ColorType.SEARCH_OK);
                    break;
                }
                case 16: {
                    jBColor = this.shadow(ColorType.SEARCH_OK_INACTIVE);
                    break;
                }
                case 17: {
                    JBColor jBColor6 = JBColor.namedColor((String)"FlameGraph.parentSearchNotMatchedBackground", (Color)((Color)new JBColor(0x8F8F8F, 0x616161)));
                    jBColor = jBColor6;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor6, (String)"namedColor(...)");
                    break;
                }
                case 18: 
                case 19: {
                    JBColor jBColor7 = JBColor.namedColor((String)"FlameGraph.parentFocusSearchNotMatchedBackground", (Color)((Color)new JBColor(0xABABAB, 0x6E6E6E)));
                    jBColor = jBColor7;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor7, (String)"namedColor(...)");
                    break;
                }
                case 20: {
                    jBColor = this.shadow(ColorType.SEARCH_FAIL);
                    break;
                }
                case 21: 
                case 22: {
                    jBColor = this.shadow(ColorType.SEARCH_FAIL_HOVER);
                    break;
                }
                case 23: 
                case 24: {
                    jBColor = new JBColor(new Color(77, 77, 77, 128), new Color(64, 64, 64, 128));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return jBColor;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorType.values().length];
                try {
                    nArray[ColorType.FOREGROUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_INACTIVE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_SEARCH_FAIL_INACTIVE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.FOREGROUND_HOVER_INACTIVE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_GROUP.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_INACTIVE.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BACKGROUND_HOVER_INACTIVE_GROUP.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_INACTIVE.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_OK_HOVER_INACTIVE.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_GROUP.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_INACTIVE.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FAIL_HOVER_INACTIVE_GROUP.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.BORDER.ordinal()] = 23;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorType.SEARCH_FOCUSED_BORDER.ordinal()] = 24;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

