/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.diagrams.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.microservices.diagrams.model.MsDiagramElement;
import com.intellij.microservices.diagrams.model.MsDiagramExternalEndpoint;
import com.intellij.microservices.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J(\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/diagrams/serialization/MsDiagramElementJsonConverter;", "Lcom/google/gson/JsonSerializer;", "Lcom/intellij/microservices/diagrams/model/MsDiagramElement;", "Lcom/google/gson/JsonDeserializer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "intellij.microservices.diagrams"})
@SourceDebugExtension(value={"SMAP\nMsDiagramElementJsonConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsDiagramElementJsonConverter.kt\ncom/intellij/microservices/diagrams/serialization/MsDiagramElementJsonConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class MsDiagramElementJsonConverter
implements JsonSerializer<MsDiagramElement>,
JsonDeserializer<MsDiagramElement> {
    @NotNull
    private final Project project;

    public MsDiagramElementJsonConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public JsonElement serialize(@Nullable MsDiagramElement src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
        JsonObject jsonObject;
        Intrinsics.checkNotNull((Object)src);
        JsonObject $this$serialize_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$serialize_u24lambda_u240.addProperty("typeTag", src.getClass().getName());
        MsDiagramElement msDiagramElement = src;
        if (!(msDiagramElement instanceof MsDiagramWholeProjectSeed)) {
            if (msDiagramElement instanceof MsDiagramWebservice) {
                $this$serialize_u24lambda_u240.addProperty("moduleName", ((MsDiagramWebservice)src).getName());
            } else if (msDiagramElement instanceof MsDiagramExternalEndpoint) {
                $this$serialize_u24lambda_u240.addProperty("urlAuthority", ((MsDiagramExternalEndpoint)src).getAuthority());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (JsonElement)jsonObject;
    }

    @Nullable
    public MsDiagramElement deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        MsDiagramElement msDiagramElement;
        JsonElement jsonElement = json;
        Intrinsics.checkNotNull((Object)jsonElement);
        JsonObject obj = jsonElement.getAsJsonObject();
        String string = obj.get("typeTag").getAsString();
        if (Intrinsics.areEqual((Object)string, (Object)MsDiagramWholeProjectSeed.class.getName())) {
            msDiagramElement = new MsDiagramWholeProjectSeed(this.project);
        } else if (Intrinsics.areEqual((Object)string, (Object)MsDiagramWebservice.class.getName())) {
            MsDiagramWebservice msDiagramWebservice;
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
            String string2 = obj.get("moduleName").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
            Module module = moduleManager.findModuleByName(string2);
            if (module != null) {
                Module it = module;
                boolean bl = false;
                msDiagramWebservice = new MsDiagramWebservice(it);
            } else {
                msDiagramWebservice = null;
            }
            msDiagramElement = msDiagramWebservice;
        } else if (Intrinsics.areEqual((Object)string, (Object)MsDiagramExternalEndpoint.class.getName())) {
            String string3 = obj.get("urlAuthority").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAsString(...)");
            msDiagramElement = new MsDiagramExternalEndpoint(this.project, string3, null);
        } else {
            msDiagramElement = null;
        }
        return msDiagramElement;
    }
}

