/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.model.Pointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueEntitiesContainer;
import org.jetbrains.vuejs.model.VueFilter;
import org.jetbrains.vuejs.model.VueGlobalImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/vuejs/model/source/VueSourceFilter;", "Lorg/jetbrains/vuejs/model/VueFilter;", "name", "", "originalSource", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getName", "()Ljava/lang/String;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "source", "getSource", "()Lcom/intellij/psi/PsiElement;", "createPointer", "Lcom/intellij/model/Pointer;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vuejs.backend"})
public final class VueSourceFilter
implements VueFilter {
    @NotNull
    private final String name;
    @NotNull
    private final PsiElement originalSource;

    public VueSourceFilter(@NotNull String name, @NotNull PsiElement originalSource) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
        this.name = name;
        this.originalSource = originalSource;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return VueGlobalImpl.Companion.getParents(this);
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        PsiElement psiElement = this.originalSource;
        PsiReference psiReference = psiElement instanceof PsiReference ? (PsiReference)psiElement : null;
        if (psiReference == null || (psiReference = psiReference.resolve()) == null) {
            psiReference = this.originalSource;
        }
        return psiReference;
    }

    @NotNull
    public Pointer<VueSourceFilter> createPointer() {
        String name = this.getName();
        SmartPsiElementPointer originalSourcePtr = SmartPointersKt.createSmartPointer((PsiElement)this.originalSource);
        return () -> VueSourceFilter.createPointer$lambda$0(name, originalSourcePtr);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    private final PsiElement component2() {
        return this.originalSource;
    }

    @NotNull
    public final VueSourceFilter copy(@NotNull String name, @NotNull PsiElement originalSource) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
        return new VueSourceFilter(name, originalSource);
    }

    public static /* synthetic */ VueSourceFilter copy$default(VueSourceFilter vueSourceFilter, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 1) != 0) {
            string = vueSourceFilter.name;
        }
        if ((n & 2) != 0) {
            psiElement = vueSourceFilter.originalSource;
        }
        return vueSourceFilter.copy(string, psiElement);
    }

    @NotNull
    public String toString() {
        return "VueSourceFilter(name=" + this.name + ", originalSource=" + this.originalSource + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.originalSource.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VueSourceFilter)) {
            return false;
        }
        VueSourceFilter vueSourceFilter = (VueSourceFilter)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)vueSourceFilter.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.originalSource, (Object)vueSourceFilter.originalSource);
    }

    private static final VueSourceFilter createPointer$lambda$0(String $name, SmartPsiElementPointer $originalSourcePtr) {
        PsiElement psiElement = $originalSourcePtr.dereference();
        if (psiElement == null) {
            return null;
        }
        return new VueSourceFilter($name, psiElement);
    }
}

