/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionResult {
    private final LookupElement myLookupElement;
    private final PrefixMatcher myMatcher;
    private final CompletionSorter mySorter;
    @ApiStatus.Internal
    public static final Key<Boolean> SHOULD_NOT_CHECK_WHEN_WRAP = Key.create((String)"SHOULD_NOT_CHECK_WHEN_WRAP");

    private CompletionResult(@NotNull LookupElement lookupElement, @NotNull PrefixMatcher matcher, @NotNull CompletionSorter sorter) {
        if (lookupElement == null) {
            CompletionResult.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            CompletionResult.$$$reportNull$$$0(1);
        }
        if (sorter == null) {
            CompletionResult.$$$reportNull$$$0(2);
        }
        this.myLookupElement = lookupElement;
        this.myMatcher = matcher;
        this.mySorter = sorter;
    }

    @Nullable
    public static CompletionResult wrap(@NotNull LookupElement lookupElement, @NotNull PrefixMatcher matcher, @NotNull CompletionSorter sorter) {
        Boolean shouldNotCheckWhenWrap;
        if (lookupElement == null) {
            CompletionResult.$$$reportNull$$$0(3);
        }
        if (matcher == null) {
            CompletionResult.$$$reportNull$$$0(4);
        }
        if (sorter == null) {
            CompletionResult.$$$reportNull$$$0(5);
        }
        if ((shouldNotCheckWhenWrap = (Boolean)lookupElement.getUserData(SHOULD_NOT_CHECK_WHEN_WRAP)) == Boolean.TRUE || matcher.prefixMatches(lookupElement)) {
            return new CompletionResult(lookupElement, matcher, sorter);
        }
        return null;
    }

    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.myMatcher;
        if (prefixMatcher == null) {
            CompletionResult.$$$reportNull$$$0(6);
        }
        return prefixMatcher;
    }

    @NotNull
    public CompletionSorter getSorter() {
        CompletionSorter completionSorter = this.mySorter;
        if (completionSorter == null) {
            CompletionResult.$$$reportNull$$$0(7);
        }
        return completionSorter;
    }

    @NotNull
    public LookupElement getLookupElement() {
        LookupElement lookupElement = this.myLookupElement;
        if (lookupElement == null) {
            CompletionResult.$$$reportNull$$$0(8);
        }
        return lookupElement;
    }

    @NotNull
    public CompletionResult withLookupElement(@NotNull LookupElement element) {
        if (element == null) {
            CompletionResult.$$$reportNull$$$0(9);
        }
        if (!this.myMatcher.prefixMatches(element)) {
            throw new AssertionError((Object)"The new element doesn't match the prefix");
        }
        return new CompletionResult(element, this.myMatcher, this.mySorter);
    }

    public boolean isStartMatch() {
        return this.myMatcher.isStartMatch(this.myLookupElement);
    }

    public String toString() {
        return this.myLookupElement.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionResult";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionResult";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixMatcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withLookupElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

