/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.modcompletion;

import com.intellij.openapi.util.text.MarkupText;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public final class ModCompletionItemPresentation {
    private static final Supplier<@Nullable Icon> NO_ICON = () -> null;
    private final MarkupText mainText;
    private final Supplier<@Nullable Icon> mainIcon;
    private final MarkupText detailText;
    private final Supplier<@Nullable Icon> detailIcon;

    private ModCompletionItemPresentation(MarkupText mainText, Supplier<@Nullable Icon> mainIcon, MarkupText detailText, Supplier<@Nullable Icon> detailIcon) {
        this.mainText = mainText;
        this.mainIcon = mainIcon;
        this.detailText = detailText;
        this.detailIcon = detailIcon;
    }

    public ModCompletionItemPresentation(MarkupText mainText) {
        this(mainText, NO_ICON, MarkupText.empty(), NO_ICON);
    }

    public ModCompletionItemPresentation withMainText(MarkupText mainText) {
        return new ModCompletionItemPresentation(mainText, this.mainIcon, this.detailText, this.detailIcon);
    }

    public ModCompletionItemPresentation withMainIcon(Supplier<@Nullable Icon> icon) {
        return new ModCompletionItemPresentation(this.mainText, icon, this.detailText, this.detailIcon);
    }

    public ModCompletionItemPresentation withDetailText(MarkupText detailText) {
        return new ModCompletionItemPresentation(this.mainText, this.mainIcon, detailText, this.detailIcon);
    }

    public ModCompletionItemPresentation withDetailIcon(Supplier<@Nullable Icon> icon) {
        return new ModCompletionItemPresentation(this.mainText, this.mainIcon, this.detailText, icon);
    }

    public MarkupText mainText() {
        return this.mainText;
    }

    @Nullable
    public Icon mainIcon() {
        return this.mainIcon.get();
    }

    public MarkupText detailText() {
        return this.detailText;
    }

    @Nullable
    public Icon detailIcon() {
        return this.detailIcon.get();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModCompletionItemPresentation that = (ModCompletionItemPresentation)obj;
        return Objects.equals(this.mainText, that.mainText) && Objects.equals(this.mainIcon, that.mainIcon) && Objects.equals(this.detailText, that.detailText) && Objects.equals(this.detailIcon, that.detailIcon);
    }

    public int hashCode() {
        return Objects.hash(this.mainText, this.mainIcon, this.detailText, this.detailIcon);
    }

    public String toString() {
        return "ModCompletionItemPresentation[mainText=" + String.valueOf(this.mainText) + ", mainIcon=" + String.valueOf(this.mainIcon) + ", detailText=" + String.valueOf(this.detailText) + ", detailIcon=" + String.valueOf(this.detailIcon) + "]";
    }
}

