/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remoteDev.util.RemoteDevPaths;
import com.jetbrains.rdserver.unattendedHost.CustomInstallPathHelper;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0007J\b\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/CustomInstallPathHelper;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "checkPath", "", "checkLinks", "", "ideInstallPath", "Ljava/nio/file/Path;", "dirToCheck", "isDefaultInstallationPath", "isLinkAlreadyCreated", "createLink", "ideLinksDir", "getLinkName", "", "DIST", "getIdeDistDir", "getIdeLinksDir", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nCustomInstallPathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomInstallPathUtil.kt\ncom/jetbrains/rdserver/unattendedHost/CustomInstallPathHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n13#2:109\n*S KotlinDebug\n*F\n+ 1 CustomInstallPathUtil.kt\ncom/jetbrains/rdserver/unattendedHost/CustomInstallPathHelper\n*L\n17#1:109\n*E\n"})
public final class CustomInstallPathHelper {
    @NotNull
    public static final CustomInstallPathHelper INSTANCE = new CustomInstallPathHelper();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String DIST = "dist";

    private CustomInstallPathHelper() {
    }

    public final void checkPath() {
        try {
            if (SystemInfo.isWindows) {
                return;
            }
            String string = PathManager.getHomePath((boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHomePath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path ideInstallPath = path;
            if (this.isDefaultInstallationPath(ideInstallPath)) {
                logger.info("IDE is installed in default dir");
                return;
            }
            if (this.checkLinks(ideInstallPath, this.getIdeDistDir())) {
                return;
            }
            Path ideLinksDir = this.getIdeLinksDir();
            if (this.checkLinks(ideInstallPath, ideLinksDir)) {
                return;
            }
            this.createLink(ideInstallPath, ideLinksDir);
        }
        catch (Throwable e) {
            logger.warn("An error occurred while checking install path");
        }
    }

    private final boolean checkLinks(Path ideInstallPath, Path dirToCheck) {
        logger.info("Checking '" + dirToCheck + "' for link to '" + ideInstallPath + "'");
        if (Files.isDirectory(dirToCheck, new LinkOption[0]) && this.isLinkAlreadyCreated(ideInstallPath, dirToCheck)) {
            logger.info("Link to the IDE is already exists");
            return true;
        }
        return false;
    }

    private final boolean isDefaultInstallationPath(Path ideInstallPath) {
        Path defaultInstallPath;
        Path ideInstallDir = ideInstallPath.getParent();
        boolean isDefaultDir = ideInstallDir.startsWith(defaultInstallPath = this.getIdeDistDir()) && defaultInstallPath.startsWith(ideInstallDir);
        Path ideLinksDir = this.getIdeLinksDir();
        boolean isLinksDir = ideInstallDir.startsWith(ideLinksDir) && ideLinksDir.startsWith(ideInstallDir);
        return isDefaultDir || isLinksDir;
    }

    private final boolean isLinkAlreadyCreated(Path ideInstallPath, Path dirToCheck) {
        List links2 = Files.walk(dirToCheck, 1, new FileVisitOption[0]).filter(arg_0 -> CustomInstallPathHelper.isLinkAlreadyCreated$lambda$0(isLinkAlreadyCreated.links.1.INSTANCE, arg_0)).collect(Collectors.toList());
        for (Path link : links2) {
            try {
                Path realPath = Files.readSymbolicLink(link);
                if (!Intrinsics.areEqual((Object)realPath, (Object)ideInstallPath)) continue;
                return true;
            }
            catch (IOException e) {
                logger.warn("An error occurred while reading link '" + link + "'", (Throwable)e);
            }
        }
        return false;
    }

    private final void createLink(Path ideInstallPath, Path ideLinksDir) {
        logger.info("Creating link to '" + ideInstallPath + "' in directory '" + ideLinksDir + "'");
        if (!Files.isDirectory(ideLinksDir, new LinkOption[0])) {
            logger.info("Creating links directory '" + ideLinksDir + "'");
            Files.createDirectories(ideLinksDir, new FileAttribute[0]);
        }
        String linkName = this.getLinkName(ideInstallPath);
        Path link = ideLinksDir.resolve(linkName);
        logger.info("Creating link: '" + link + "' -> '" + ideInstallPath + "'");
        Files.createSymbolicLink(link, ideInstallPath, new FileAttribute[0]);
    }

    private final String getLinkName(Path ideInstallPath) {
        String separator = FileSystems.getDefault().getSeparator();
        String string = ((Object)ideInstallPath.toAbsolutePath()).toString();
        Intrinsics.checkNotNull((Object)separator);
        return StringsKt.replace$default((String)string, (String)separator, (String)"_", (boolean)false, (int)4, null);
    }

    @ApiStatus.Internal
    @NotNull
    public final Path getIdeDistDir() {
        return RemoteDevPaths.INSTANCE.getLocalDistDir();
    }

    private final Path getIdeLinksDir() {
        return RemoteDevPaths.INSTANCE.getUserProvidedDistDir();
    }

    private static final boolean isLinkAlreadyCreated$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CustomInstallPathHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CustomInstallPathHelper.logger = logger;
    }
}

