/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteDev.hostStatus.UnattendedHostPerProjectStatus;
import com.intellij.remoteDev.hostStatus.UnattendedHostStatus;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdserver.connection.HttpLinkManager;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.unattendedHost.UnattendedHostUiDiagnosticsService;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedModeManagerImpl;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedModeManagerImplKt;
import com.jetbrains.rdserver.unattendedHost.status.UnattendedHostActivityTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ)\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000fJ\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/UnattendedStatusUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getStatusCompatibleProjectPath", "", "project", "Lcom/intellij/openapi/project/Project;", "getStatus", "Lcom/intellij/remoteDev/hostStatus/UnattendedHostStatus;", "projects", "", "linkToPath", "([Lcom/intellij/openapi/project/Project;Ljava/lang/String;)Lcom/intellij/remoteDev/hostStatus/UnattendedHostStatus;", "getStatusJson", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nUnattendedStatusUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedStatusUtil.kt\ncom/jetbrains/rdserver/unattendedHost/UnattendedStatusUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n60#2,5:107\n13#2:123\n13225#3,2:112\n14060#3:114\n14061#3:122\n777#4:115\n873#4,2:116\n1586#4:118\n1661#4,3:119\n*S KotlinDebug\n*F\n+ 1 UnattendedStatusUtil.kt\ncom/jetbrains/rdserver/unattendedHost/UnattendedStatusUtil\n*L\n34#1:107,5\n23#1:123\n43#1:112,2\n72#1:114\n72#1:122\n74#1:115\n74#1:116,2\n74#1:118\n74#1:119,3\n*E\n"})
public final class UnattendedStatusUtil {
    @NotNull
    public static final UnattendedStatusUtil INSTANCE = new UnattendedStatusUtil();
    @NotNull
    private static final Logger logger;

    private UnattendedStatusUtil() {
    }

    @Nullable
    public final String getStatusCompatibleProjectPath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = (String)project.getUserData(UnattendedModeManagerImpl.Companion.getUNATTENDED_HOST_PROJECT_PATH_KEY());
        if (string == null) {
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
            string = virtualFile != null ? virtualFile.getPath() : null;
            if (string == null) {
                string = project.getProjectFilePath();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UnattendedHostStatus getStatus(@Nullable Project[] projects, @Nullable String linkToPath) {
        boolean bl;
        boolean isUnattendedMode;
        UnattendedModeManagerImpl hostManager;
        String jreBuild;
        String appVersion;
        long currentPid;
        Project[] projectsToProcess;
        block11: {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("Get unattended host status status", t$iv);
            }
            Project[] projectArray = projects;
            if (projects == null) {
                Project[] projectArray2 = ProjectManager.getInstance().getOpenProjects();
                projectArray = projectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)projectArray2, (String)"getOpenProjects(...)");
            }
            projectsToProcess = projectArray;
            currentPid = ProcessHandle.current().pid();
            String string = ApplicationInfo.getInstance().getBuild().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            appVersion = string;
            jreBuild = UnattendedModeManagerImplKt.getJreBuild();
            hostManager = UnattendedModeManagerImpl.Companion.getInstance();
            isUnattendedMode = hostManager.isUnattendedMode();
            Project[] $this$any$iv = projectsToProcess;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Project element$iv;
                Project it = element$iv = $this$any$iv[i];
                boolean bl3 = false;
                if (!(!it.isDefault())) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        boolean isProjectOpen = bl;
        UnattendedHostUiDiagnosticsService diagnosticsService = UnattendedHostUiDiagnosticsService.Companion.getInstance();
        Pair<Boolean, Boolean> pair = diagnosticsService.checkMainThreadStatus();
        boolean modalDialogOpen = (Boolean)pair.component1();
        boolean mainThreadFrozen = (Boolean)pair.component2();
        String remoteDevLink = hostManager.remoteDevDirectLink();
        if (remoteDevLink == null) {
            logger.warn("RemoteDev direct link is null");
        }
        Pair httpLinks = HttpLinkManager.Companion.getInstance().getLinks();
        String string = PathManager.getHomePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHomePath(...)");
        String string2 = string;
        boolean bl4 = diagnosticsService.isBackendUnresponsive() || mainThreadFrozen;
        String string3 = PathManager.getConfigPath();
        Pair pair2 = httpLinks;
        String string4 = pair2 != null ? (String)pair2.getFirst() : null;
        Pair pair3 = httpLinks;
        String string5 = pair3 != null ? (String)pair3.getSecond() : null;
        UnattendedHostStatus status = new UnattendedHostStatus(currentPid, appVersion, jreBuild, isUnattendedMode, bl4, modalDialogOpen, string2, string3, remoteDevLink, string4, string5, null, 2048, null);
        if (isProjectOpen && isUnattendedMode) {
            List perProject = new ArrayList();
            Project[] $this$forEach$iv = projectsToProcess;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String string6;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ClientAppSession it;
                void $this$filterTo$iv$iv;
                Project element$iv;
                Project project = element$iv = $this$forEach$iv[i];
                boolean bl5 = false;
                String string7 = INSTANCE.getStatusCompatibleProjectPath(project);
                if (string7 == null) {
                    string7 = "<unknown>";
                }
                String projectPath = string7;
                Iterable $this$filter$iv = ClientSessionsUtil.sessions((Application)ApplicationKt.getApplication(), (ClientKind)ClientKind.ALL);
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ClientAppSession)element$iv$iv;
                    boolean bl6 = false;
                    if (!((Boolean)RemoteSessionKt.isConnected((ClientAppSession)it).getValue()).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ClientAppSession)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl7 = false;
                    collection.add(it.getName());
                }
                List connectedUsers = (List)destination$iv$iv;
                if (remoteDevLink == null) continue;
                UnattendedHostActivityTracker activityTracker = UnattendedHostActivityTracker.Companion.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)project.getName(), (String)"getName(...)");
                String string8 = (String)project.getUserData(UnattendedModeManagerImpl.Companion.getUNATTENDED_HOST_PROJECT_LINK_KEY());
                if (string8 == null) {
                    string8 = linkToPath;
                }
                object = string8;
                String string9 = remoteDevLink;
                boolean bl8 = UtilKt.getControllerSessionOrNull((Application)ApplicationKt.getApplication()) != null;
                long l = System.currentTimeMillis();
                long l2 = activityTracker.getSecondsSinceLastControllerActivity();
                boolean bl9 = activityTracker.getAnyProgressRunning();
                Pair pair4 = httpLinks;
                String string10 = pair4 != null ? (String)pair4.getFirst() : null;
                Pair pair5 = httpLinks;
                String string11 = pair5 != null ? (String)pair5.getSecond() : null;
                perProject.add(new UnattendedHostPerProjectStatus(string6, projectPath, (String)object, Long.valueOf(l), string9, string10, string11, bl8, l2, bl9, connectedUsers));
            }
            if (perProject.size() != projectsToProcess.length) {
                logger.warn("Not all projects succeeded to produce status");
            }
            status = UnattendedHostStatus.copy$default((UnattendedHostStatus)status, (long)0L, null, null, (boolean)false, (boolean)false, (boolean)false, null, null, null, null, null, (List)perProject, (int)2047, null);
        }
        return status;
    }

    public static /* synthetic */ UnattendedHostStatus getStatus$default(UnattendedStatusUtil unattendedStatusUtil, Project[] projectArray, String string, int n, Object object) {
        if ((n & 1) != 0) {
            projectArray = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return unattendedStatusUtil.getStatus(projectArray, string);
    }

    @NotNull
    public final String getStatusJson() {
        return UnattendedStatusUtil.getStatus$default(this, null, null, 3, null).toJson();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnattendedStatusUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnattendedStatusUtil.logger = logger;
    }
}

