/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.metrics;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.Metric;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.MetricType;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.MetricsStatus;
import com.jetbrains.rd.platform.codeWithMe.unattendedHost.metrics.providers.MetricProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/IdeMetricsProvider;", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/providers/MetricProvider;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "getMetrics", "", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/Metric;", "ideMetric", "status", "Lcom/jetbrains/rd/platform/codeWithMe/unattendedHost/metrics/MetricsStatus;", "value", "Companion", "intellij.platform.remoteController.backend"})
public final class IdeMetricsProvider
implements MetricProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String FULL_PRODUCT_NAME = "fullProductName";
    @NotNull
    public static final String IDE_VERSION = "ideVersion";
    @NotNull
    public static final String PRODUCT_CODE = "productCode";

    public IdeMetricsProvider() {
        this.id = "ideMetrics";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Map<String, Metric> getMetrics() {
        LOG.trace("Updating IDE data");
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        Metric fullProductNameMetric = this.ideMetric(MetricsStatus.NORMAL, string);
        String string2 = ApplicationInfo.getInstance().getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFullVersion(...)");
        Metric ideVersionMetric = this.ideMetric(MetricsStatus.NORMAL, string2);
        String string3 = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProductCode(...)");
        Metric productCodeMetric = this.ideMetric(MetricsStatus.NORMAL, string3);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)FULL_PRODUCT_NAME, (Object)fullProductNameMetric), TuplesKt.to((Object)IDE_VERSION, (Object)ideVersionMetric), TuplesKt.to((Object)PRODUCT_CODE, (Object)productCodeMetric)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Metric ideMetric(MetricsStatus status, String value) {
        return new Metric(MetricType.OTHER, status, (Object)value);
    }

    static {
        Logger logger = Logger.getInstance(IdeMetricsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/metrics/IdeMetricsProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "FULL_PRODUCT_NAME", "", "IDE_VERSION", "PRODUCT_CODE", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

